/*
 * Decompiled with CFR 0.152.
 */
package de.idyl.winzipaes.impl;

import de.idyl.winzipaes.impl.AESEncrypter;
import de.idyl.winzipaes.impl.AESUtilsJCA;
import java.security.SecureRandom;
import java.util.Random;

public class AESEncrypterJCA
implements AESEncrypter {
    private byte[] salt;
    private AESUtilsJCA utils;
    private static final Random RANDOM = new SecureRandom();

    @Override
    public void init(String password, int keySize) {
        this.salt = AESEncrypterJCA.createSalt(keySize / 16);
        this.utils = new AESUtilsJCA(password, keySize, this.salt);
    }

    @Override
    public void encrypt(byte[] in, int length) {
        this.utils.cryptUpdate(in, length);
        this.utils.authUpdate(in, length);
    }

    @Override
    public byte[] getSalt() {
        return this.salt;
    }

    @Override
    public byte[] getPwVerification() {
        return this.utils.getPasswordVerifier();
    }

    @Override
    public byte[] getFinalAuthentication() {
        return this.utils.getFinalAuthentifier();
    }

    private static byte[] createSalt(int size) {
        byte[] salt = new byte[size];
        RANDOM.nextBytes(salt);
        return salt;
    }
}

