/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.jboss.as.clustering.controller.Operation;
import org.jboss.as.clustering.infinispan.subsystem.BackupSiteOperationContext;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanResourceDescriptionResolver;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.dmr.ModelNode;

public enum BackupSiteOperation implements Operation<BackupSiteOperationContext>
{
    BRING_SITE_ONLINE("bring-site-online", false){

        public ModelNode execute(BackupSiteOperationContext context) {
            return new ModelNode(context.getOperations().bringSiteOnline(context.getSite()));
        }
    }
    ,
    TAKE_SITE_OFFLINE("take-site-offline", false){

        public ModelNode execute(BackupSiteOperationContext context) {
            return new ModelNode(context.getOperations().takeSiteOffline(context.getSite()));
        }
    }
    ,
    SITE_STATUS("site-status", true){

        public ModelNode execute(BackupSiteOperationContext context) {
            return new ModelNode(context.getOperations().siteStatus(context.getSite()));
        }
    };

    private final OperationDefinition definition;

    private BackupSiteOperation(String name, boolean readOnly) {
        SimpleOperationDefinitionBuilder builder = new SimpleOperationDefinitionBuilder(name, (ResourceDescriptionResolver)new InfinispanResourceDescriptionResolver("backup"));
        if (readOnly) {
            builder.setReadOnly();
        }
        this.definition = builder.setRuntimeOnly().build();
    }

    public OperationDefinition getDefinition() {
        return this.definition;
    }
}

