/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.federation.kerberos.impl;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import net.iharder.Base64;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.jboss.logging.Logger;
import org.keycloak.federation.kerberos.CommonKerberosConfig;
import org.keycloak.federation.kerberos.impl.KerberosServerSubjectAuthenticator;
import org.keycloak.util.KerberosSerializationUtils;

public class SPNEGOAuthenticator {
    private static final Logger log = Logger.getLogger(SPNEGOAuthenticator.class);
    private final KerberosServerSubjectAuthenticator kerberosSubjectAuthenticator;
    private final String spnegoToken;
    private final CommonKerberosConfig kerberosConfig;
    private boolean authenticated = false;
    private String authenticatedKerberosPrincipal = null;
    private GSSCredential delegationCredential;
    private String responseToken = null;

    public SPNEGOAuthenticator(CommonKerberosConfig kerberosConfig, KerberosServerSubjectAuthenticator kerberosSubjectAuthenticator, String spnegoToken) {
        this.kerberosConfig = kerberosConfig;
        this.kerberosSubjectAuthenticator = kerberosSubjectAuthenticator;
        this.spnegoToken = spnegoToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void authenticate() {
        if (log.isTraceEnabled()) {
            log.trace((Object)("SPNEGO Login with token: " + this.spnegoToken));
        }
        try {
            Subject serverSubject = this.kerberosSubjectAuthenticator.authenticateServerSubject();
            this.authenticated = Subject.doAs(serverSubject, new AcceptSecContext());
        }
        catch (Exception e) {
            log.warn((Object)"SPNEGO login failed", (Throwable)e);
        }
        finally {
            this.kerberosSubjectAuthenticator.logoutServerSubject();
        }
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public String getResponseToken() {
        return this.responseToken;
    }

    public String getSerializedDelegationCredential() {
        if (this.delegationCredential == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"No delegation credential available.");
            }
            return null;
        }
        try {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Serializing credential " + this.delegationCredential));
            }
            return KerberosSerializationUtils.serializeCredential((GSSCredential)this.delegationCredential);
        }
        catch (KerberosSerializationUtils.KerberosSerializationException kse) {
            log.warn((Object)("Couldn't serialize credential: " + this.delegationCredential), (Throwable)kse);
            return null;
        }
    }

    public String getAuthenticatedUsername() {
        String[] tokens = this.authenticatedKerberosPrincipal.split("@");
        String username = tokens[0];
        if (!tokens[1].equalsIgnoreCase(this.kerberosConfig.getKerberosRealm())) {
            throw new IllegalStateException("Invalid kerberos realm. Realm from the ticket: " + tokens[1] + ", configured realm: " + this.kerberosConfig.getKerberosRealm());
        }
        return username;
    }

    protected GSSContext establishContext() throws GSSException, IOException {
        GSSManager manager = GSSManager.getInstance();
        GSSContext gssContext = manager.createContext((GSSCredential)null);
        byte[] inputToken = Base64.decode((String)this.spnegoToken);
        byte[] respToken = gssContext.acceptSecContext(inputToken, 0, inputToken.length);
        this.responseToken = Base64.encodeBytes((byte[])respToken);
        return gssContext;
    }

    protected void logAuthDetails(GSSContext gssContext) throws GSSException {
        if (log.isDebugEnabled()) {
            String message = "SPNEGO Security context accepted with token: " + this.responseToken + ", established: " + gssContext.isEstablished() + ", credDelegState: " + gssContext.getCredDelegState() + ", mutualAuthState: " + gssContext.getMutualAuthState() + ", lifetime: " + gssContext.getLifetime() + ", confState: " + gssContext.getConfState() + ", integState: " + gssContext.getIntegState() + ", srcName: " + gssContext.getSrcName() + ", targName: " + gssContext.getTargName();
            log.debug((Object)message);
        }
    }

    private class AcceptSecContext
    implements PrivilegedExceptionAction<Boolean> {
        private AcceptSecContext() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean run() throws Exception {
            GSSContext gssContext = null;
            try {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"Going to establish security context");
                }
                gssContext = SPNEGOAuthenticator.this.establishContext();
                SPNEGOAuthenticator.this.logAuthDetails(gssContext);
                if (gssContext.isEstablished()) {
                    SPNEGOAuthenticator.this.authenticatedKerberosPrincipal = gssContext.getSrcName().toString();
                    if (gssContext.getCredDelegState()) {
                        SPNEGOAuthenticator.this.delegationCredential = gssContext.getDelegCred();
                    }
                    Boolean bl = true;
                    return bl;
                }
                Boolean bl = false;
                return bl;
            }
            finally {
                if (gssContext != null) {
                    gssContext.dispose();
                }
            }
        }
    }
}

