/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.transport.tcp;

import java.net.SocketAddress;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.pool.BaseKeyedPoolableObjectFactory;
import org.infinispan.client.hotrod.impl.operations.PingOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.transport.tcp.TcpTransport;
import org.infinispan.client.hotrod.impl.transport.tcp.TcpTransportFactory;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;

public class TransportObjectFactory
extends BaseKeyedPoolableObjectFactory<SocketAddress, TcpTransport> {
    private static final Log log = LogFactory.getLog(TransportObjectFactory.class);
    protected final TcpTransportFactory tcpTransportFactory;
    protected final AtomicInteger defaultCacheTopologyId;
    protected final boolean pingOnStartup;
    protected volatile boolean firstPingExecuted = false;
    protected final Codec codec;

    public TransportObjectFactory(Codec codec, TcpTransportFactory tcpTransportFactory, AtomicInteger defaultCacheTopologyId, boolean pingOnStartup) {
        this.tcpTransportFactory = tcpTransportFactory;
        this.defaultCacheTopologyId = defaultCacheTopologyId;
        this.pingOnStartup = pingOnStartup;
        this.codec = codec;
    }

    public TcpTransport makeObject(SocketAddress address) throws Exception {
        TcpTransport tcpTransport = new TcpTransport(address, this.tcpTransportFactory);
        if (log.isTraceEnabled()) {
            log.tracef("Created tcp transport: %s", tcpTransport);
        }
        if (this.pingOnStartup && !this.firstPingExecuted) {
            log.trace("Executing first ping!");
            this.firstPingExecuted = true;
            this.ping(tcpTransport, this.defaultCacheTopologyId);
        }
        return tcpTransport;
    }

    protected PingOperation.PingResult ping(TcpTransport tcpTransport, AtomicInteger topologyId) {
        PingOperation po = new PingOperation(this.codec, topologyId, tcpTransport);
        return po.execute();
    }

    public boolean validateObject(SocketAddress address, TcpTransport transport) {
        try {
            boolean valid = this.ping(transport, this.defaultCacheTopologyId) == PingOperation.PingResult.SUCCESS;
            log.tracef("Is connection %s valid? %s", transport, valid);
            return valid;
        }
        catch (Throwable e) {
            log.tracef(e, "Error validating the connection %s. Marking it as invalid.", transport);
            return false;
        }
    }

    public void destroyObject(SocketAddress address, TcpTransport transport) throws Exception {
        if (log.isTraceEnabled()) {
            log.tracef("About to destroy tcp transport: %s", transport);
        }
        transport.destroy();
    }

    public void activateObject(SocketAddress address, TcpTransport transport) throws Exception {
        super.activateObject((Object)address, (Object)transport);
        if (log.isTraceEnabled()) {
            log.tracef("Fetching from pool: %s", transport);
        }
    }

    public void passivateObject(SocketAddress address, TcpTransport transport) throws Exception {
        super.passivateObject((Object)address, (Object)transport);
        if (log.isTraceEnabled()) {
            log.tracef("Returning to pool: %s", transport);
        }
    }
}

