/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.registry;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.registry.Registry;
import org.wildfly.clustering.registry.RegistryEntryProvider;

public class LocalRegistry<K, V>
implements Registry<K, V> {
    private final AtomicReference<Map.Entry<K, V>> entryRef = new AtomicReference();
    private final RegistryEntryProvider<K, V> provider;
    private final Group group;

    public LocalRegistry(Group group, RegistryEntryProvider<K, V> provider) {
        this.group = group;
        this.provider = provider;
        this.getLocalEntry();
    }

    public Group getGroup() {
        return this.group;
    }

    public void addListener(Registry.Listener<K, V> listener) {
    }

    public void removeListener(Registry.Listener<K, V> listener) {
    }

    public Map<K, V> getEntries() {
        Map.Entry<K, V> entry = this.entryRef.get();
        return entry != null ? Collections.singletonMap(entry.getKey(), entry.getValue()) : Collections.emptyMap();
    }

    public Map.Entry<K, V> getEntry(Node node) {
        return node.equals(this.group.getLocalNode()) ? this.entryRef.get() : null;
    }

    public Map.Entry<K, V> getLocalEntry() {
        Map.Entry<K, V> entry = this.entryRef.get();
        if (entry == null && !this.entryRef.compareAndSet(null, entry = new AbstractMap.SimpleImmutableEntry<Object, Object>(this.provider.getKey(), this.provider.getValue()))) {
            entry = this.entryRef.get();
        }
        return entry;
    }

    public void close() {
        this.entryRef.set(null);
    }
}

