/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.map.ObjectMapper;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.connections.file.DefaultFileConnectionProvider;
import org.keycloak.connections.file.FileConnectionProvider;
import org.keycloak.connections.file.FileConnectionProviderFactory;
import org.keycloak.connections.file.InMemoryModel;
import org.keycloak.connections.file.Model;
import org.keycloak.exportimport.Strategy;
import org.keycloak.exportimport.util.ExportUtils;
import org.keycloak.exportimport.util.ImportUtils;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakTransaction;
import org.keycloak.models.RealmModel;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.util.JsonSerialization;

public class DefaultFileConnectionProviderFactory
implements FileConnectionProviderFactory {
    protected static final Logger logger = Logger.getLogger(DefaultFileConnectionProviderFactory.class);
    private File kcdata;
    private final Map<KeycloakSession, FileConnectionProvider> allProviders = new HashMap<KeycloakSession, FileConnectionProvider>();

    public void init(Config.Scope config) {
        String directory;
        String fileName = config.get("fileName");
        if (fileName == null) {
            fileName = "keycloak-model.json";
        }
        if ((directory = config.get("directory")) == null) {
            directory = System.getProperty("jboss.server.data.dir");
        }
        if (directory == null) {
            directory = ".";
        }
        this.kcdata = new File(directory, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionClosed(KeycloakSession session) {
        Map<KeycloakSession, FileConnectionProvider> map = this.allProviders;
        synchronized (map) {
            this.allProviders.remove(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readModelFile(KeycloakSession session) {
        Map<KeycloakSession, FileConnectionProvider> map = this.allProviders;
        synchronized (map) {
            if (!this.kcdata.exists()) {
                return;
            }
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(this.kcdata);
                Model model = (Model)JsonSerialization.readValue((InputStream)fis, Model.class);
                ImportUtils.importFromStream((KeycloakSession)session, (ObjectMapper)JsonSerialization.mapper, (InputStream)fis, (Strategy)Strategy.IGNORE_EXISTING);
                session.realms().getMigrationModel().setStoredVersion(model.getModelVersion());
                ImportUtils.importRealms((KeycloakSession)session, model.getRealms(), (Strategy)Strategy.IGNORE_EXISTING);
            }
            catch (IOException ioe) {
                logger.error((Object)("Unable to read model file " + this.kcdata.getAbsolutePath()), (Throwable)ioe);
            }
            finally {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException e) {
                    logger.error((Object)"Failed to close output stream.", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeModelFile(KeycloakSession session) {
        Map<KeycloakSession, FileConnectionProvider> map = this.allProviders;
        synchronized (map) {
            FileOutputStream outStream = null;
            try {
                outStream = new FileOutputStream(this.kcdata);
                this.exportModel(session, outStream);
            }
            catch (IOException e) {
                logger.error((Object)("Unable to write model file " + this.kcdata.getAbsolutePath()), (Throwable)e);
            }
            finally {
                try {
                    if (outStream != null) {
                        outStream.close();
                    }
                }
                catch (IOException e) {
                    logger.error((Object)"Failed to close output stream.", (Throwable)e);
                }
            }
        }
    }

    private void exportModel(KeycloakSession session, FileOutputStream outStream) throws IOException {
        List realms = session.realms().getRealms();
        ArrayList<RealmRepresentation> reps = new ArrayList<RealmRepresentation>();
        for (RealmModel realm : realms) {
            reps.add(ExportUtils.exportRealm((KeycloakSession)session, (RealmModel)realm, (boolean)true));
        }
        Model model = new Model();
        model.setRealms(reps);
        model.setModelVersion(session.realms().getMigrationModel().getStoredVersion());
        JsonSerialization.prettyMapper.writeValue((OutputStream)outStream, (Object)model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileConnectionProvider create(KeycloakSession session) {
        Map<KeycloakSession, FileConnectionProvider> map = this.allProviders;
        synchronized (map) {
            FileConnectionProvider fcProvider = this.allProviders.get(session);
            if (fcProvider == null) {
                InMemoryModel model = new InMemoryModel();
                fcProvider = new DefaultFileConnectionProvider(this, session, model);
                this.allProviders.put(session, fcProvider);
                session.getTransaction().enlist((KeycloakTransaction)fcProvider);
                this.readModelFile(session);
            }
            return fcProvider;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void commit(KeycloakSession session) {
        Map<KeycloakSession, FileConnectionProvider> map = this.allProviders;
        synchronized (map) {
            if (!this.allProviders.containsKey(session)) {
                return;
            }
            try {
                this.writeModelFile(session);
            }
            finally {
                this.allProviders.remove(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rollback(KeycloakSession session) {
        Map<KeycloakSession, FileConnectionProvider> map = this.allProviders;
        synchronized (map) {
            this.allProviders.remove(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isActive(KeycloakSession session) {
        Map<KeycloakSession, FileConnectionProvider> map = this.allProviders;
        synchronized (map) {
            return this.allProviders.containsKey(session);
        }
    }

    public void close() {
    }

    public String getId() {
        return "default";
    }

    public void postInit(KeycloakSessionFactory factory) {
    }
}

