/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.connections.ldap;

import java.net.URI;
import java.util.Hashtable;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.net.ssl.SSLContext;
import org.jboss.as.domain.management.connections.ldap.LdapConnectionManager;
import org.jboss.as.domain.management.connections.ldap.LdapConnectionManagerRegistry;
import org.jboss.as.domain.management.connections.ldap.LdapConnectionResourceDefinition;
import org.jboss.as.domain.management.connections.ldap.ThreadLocalSSLSocketFactory;
import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.security.manager.WildFlySecurityManager;

public class LdapConnectionManagerService
implements Service<LdapConnectionManager>,
LdapConnectionManager {
    private static final ServiceName BASE_SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"server", "controller", "management", "connection_manager"});
    private final LdapConnectionManagerRegistry connectionManagerRegistry;
    private final String name;
    private final InjectedValue<SSLContext> fullSSLContext = new InjectedValue();
    private final InjectedValue<SSLContext> trustSSLContext = new InjectedValue();
    private volatile Config configuration;
    private volatile Hashtable<String, String> properties = new Hashtable();

    public LdapConnectionManagerService(String name, LdapConnectionManagerRegistry connectionManagerRegistry) {
        this.name = name;
        this.connectionManagerRegistry = connectionManagerRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Config setConfiguration(String initialContextFactory, String url, String searchDn, String searchCredential, LdapConnectionResourceDefinition.ReferralHandling referralHandling, Set<URI> referralURIs) {
        Config configuration = new Config(initialContextFactory, url, searchDn, searchCredential, referralHandling, referralURIs);
        try {
            Config config = this.configuration;
            return config;
        }
        finally {
            this.configuration = configuration;
        }
    }

    void setConfiguration(Config configuration) {
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start(final StartContext context) throws StartException {
        try {
            context.execute(new Runnable(){

                @Override
                public void run() {
                    LdapConnectionManagerService.this.connectionManagerRegistry.addLdapConnectionManagerService(LdapConnectionManagerService.this.name, LdapConnectionManagerService.this);
                    context.complete();
                }
            });
        }
        finally {
            context.asynchronous();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop(final StopContext context) {
        try {
            context.execute(new Runnable(){

                @Override
                public void run() {
                    LdapConnectionManagerService.this.connectionManagerRegistry.removeLdapConnectionManagerService(LdapConnectionManagerService.this.name);
                    context.complete();
                }
            });
        }
        finally {
            context.asynchronous();
        }
    }

    public synchronized LdapConnectionManagerService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public InjectedValue<SSLContext> getFullSSLContextInjector() {
        return this.fullSSLContext;
    }

    public InjectedValue<SSLContext> getTrustOnlySSLContextInjector() {
        return this.trustSSLContext;
    }

    synchronized void setProperty(String name, String value) {
        Hashtable<String, String> properties = new Hashtable<String, String>(this.properties);
        properties.put(name, value);
        this.properties = properties;
    }

    synchronized void removeProperty(String name) {
        Hashtable<String, String> properties = new Hashtable<String, String>(this.properties);
        properties.remove(name);
        this.properties = properties;
    }

    void setPropertyImmediate(String name, String value) {
        this.properties.put(name, value);
    }

    String getName() {
        return this.name;
    }

    boolean handlesReferralFor(URI uri) {
        return this.configuration.getReferralURIs().contains(uri);
    }

    @Override
    public DirContext getConnection() throws NamingException {
        return this.getConnection(this.configuration);
    }

    private DirContext getConnection(Config configuration) throws NamingException {
        return this.getConnection(this.getFullProperties(configuration), this.getSSLContext(false));
    }

    @Override
    public void verifyIdentity(String bindDn, String bindCredential) throws NamingException {
        this.verifyIdentity(this.configuration, bindDn, bindCredential);
    }

    private void verifyIdentity(Config configuration, String bindDn, String bindCredential) throws NamingException {
        Hashtable<String, String> connectionProperties = this.getConnectionOnlyProperties(configuration);
        connectionProperties.put("java.naming.security.principal", bindDn);
        connectionProperties.put("java.naming.security.credentials", bindCredential);
        DirContext context = this.getConnection(connectionProperties, this.getSSLContext(true));
        context.close();
    }

    @Override
    public LdapConnectionManager findForReferral(final URI referralUri) {
        Config config = this.configuration;
        switch (config.referralHandling) {
            case FOLLOW: {
                return new LdapConnectionManager(){

                    @Override
                    public void verifyIdentity(String bindDn, String bindCredential) throws NamingException {
                        LdapConnectionManagerService.this.verifyIdentity(new Config(referralUri.toString(), LdapConnectionManagerService.this.configuration), bindDn, bindCredential);
                    }

                    @Override
                    public DirContext getConnection() throws NamingException {
                        return LdapConnectionManagerService.this.getConnection(new Config(referralUri.toString(), LdapConnectionManagerService.this.configuration));
                    }

                    @Override
                    public LdapConnectionManager findForReferral(URI referralUri2) {
                        return LdapConnectionManagerService.this.findForReferral(referralUri2);
                    }
                };
            }
            case THROW: {
                if (this.handlesReferralFor(referralUri)) {
                    return this;
                }
                for (LdapConnectionManagerService current : this.connectionManagerRegistry.availableServices()) {
                    if (current == null || !current.handlesReferralFor(referralUri)) continue;
                    return current;
                }
                break;
            }
            default: {
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DirContext getConnection(Hashtable<String, String> properties, SSLContext sslContext) throws NamingException {
        ClassLoader old = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            if (sslContext != null) {
                ThreadLocalSSLSocketFactory.setSSLSocketFactory(sslContext.getSocketFactory());
                WildFlySecurityManager.setCurrentContextClassLoaderPrivileged(ThreadLocalSSLSocketFactory.class);
                properties.put("java.naming.ldap.factory.socket", ThreadLocalSSLSocketFactory.class.getName());
            }
            if (DomainManagementLogger.SECURITY_LOGGER.isTraceEnabled()) {
                Hashtable<String, String> logProperties;
                if (properties.containsKey("java.naming.security.credentials")) {
                    logProperties = new Hashtable<String, String>(properties);
                    logProperties.put("java.naming.security.credentials", "***");
                } else {
                    logProperties = properties;
                }
                DomainManagementLogger.SECURITY_LOGGER.tracef("Connecting to LDAP with properties (%s)", logProperties.toString());
            }
            InitialDirContext initialDirContext = new InitialDirContext(properties);
            return initialDirContext;
        }
        finally {
            if (sslContext != null) {
                ThreadLocalSSLSocketFactory.removeSSLSocketFactory();
            }
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)old);
        }
    }

    private SSLContext getSSLContext(boolean trustOnly) {
        if (trustOnly) {
            return (SSLContext)this.trustSSLContext.getOptionalValue();
        }
        SSLContext sslContext = (SSLContext)this.fullSSLContext.getOptionalValue();
        if (sslContext == null) {
            sslContext = (SSLContext)this.trustSSLContext.getOptionalValue();
        }
        return sslContext;
    }

    private Hashtable<String, String> getConnectionOnlyProperties(Config configuration) {
        Hashtable<String, String> result = new Hashtable<String, String>(this.properties);
        result.put("java.naming.factory.initial", configuration.initialContextFactory);
        result.put("java.naming.provider.url", configuration.url);
        result.put("java.naming.referral", configuration.referralHandling.getValue());
        return result;
    }

    private Hashtable<String, String> getFullProperties(Config configuration) {
        Hashtable<String, String> result = this.getConnectionOnlyProperties(configuration);
        if (configuration.searchDn != null) {
            result.put("java.naming.security.principal", configuration.searchDn);
        }
        if (configuration.searchCredential != null) {
            result.put("java.naming.security.credentials", configuration.searchCredential);
        }
        return result;
    }

    static class Config {
        private final String initialContextFactory;
        private final String url;
        private final String searchDn;
        private final String searchCredential;
        private final LdapConnectionResourceDefinition.ReferralHandling referralHandling;
        private final Set<URI> referralURIs;

        private Config(String initialContextFactory, String url, String searchDn, String searchCredential, LdapConnectionResourceDefinition.ReferralHandling referralHandling, Set<URI> referralURIs) {
            this.initialContextFactory = initialContextFactory;
            this.url = url;
            this.searchDn = searchDn;
            this.searchCredential = searchCredential;
            this.referralHandling = referralHandling;
            this.referralURIs = referralURIs;
        }

        private Config(String url, Config config) {
            this.url = url;
            this.initialContextFactory = config.initialContextFactory;
            this.searchDn = config.searchDn;
            this.searchCredential = config.searchCredential;
            this.referralHandling = config.referralHandling;
            this.referralURIs = config.referralURIs;
        }

        public String getInitialContextFactory() {
            return this.initialContextFactory;
        }

        public String getUrl() {
            return this.url;
        }

        public String getSearchDn() {
            return this.searchDn;
        }

        public String getSearchCredential() {
            return this.searchCredential;
        }

        public LdapConnectionResourceDefinition.ReferralHandling getReferralHandling() {
            return this.referralHandling;
        }

        public Set<URI> getReferralURIs() {
            return this.referralURIs;
        }
    }

    public static final class ServiceUtil {
        private ServiceUtil() {
        }

        public static ServiceName createServiceName(String connectionName) {
            return BASE_SERVICE_NAME.append(new String[]{connectionName});
        }

        public static ServiceBuilder<?> addDependency(ServiceBuilder<?> sb, Injector<LdapConnectionManager> injector, String connectionName, boolean optional) {
            ServiceBuilder.DependencyType type = optional ? ServiceBuilder.DependencyType.OPTIONAL : ServiceBuilder.DependencyType.REQUIRED;
            sb.addDependency(type, ServiceUtil.createServiceName(connectionName), LdapConnectionManager.class, injector);
            return sb;
        }
    }
}

