/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.resourceadapters;

import java.util.Map;
import org.jboss.as.connector.services.mdr.AS7MetadataRepository;
import org.jboss.as.connector.subsystems.resourceadapters.Constants;
import org.jboss.as.connector.subsystems.resourceadapters.IronJacamarResource;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.jca.common.api.metadata.common.Credential;
import org.jboss.jca.common.api.metadata.common.Extension;
import org.jboss.jca.common.api.metadata.common.Pool;
import org.jboss.jca.common.api.metadata.common.Recovery;
import org.jboss.jca.common.api.metadata.common.Security;
import org.jboss.jca.common.api.metadata.common.TimeOut;
import org.jboss.jca.common.api.metadata.common.Validation;
import org.jboss.jca.common.api.metadata.common.XaPool;
import org.jboss.jca.common.api.metadata.resourceadapter.Activation;
import org.jboss.jca.common.api.metadata.resourceadapter.AdminObject;
import org.jboss.jca.common.api.metadata.resourceadapter.ConnectionDefinition;
import org.jboss.jca.common.api.metadata.resourceadapter.WorkManagerSecurity;

public class IronJacamarResourceCreator {
    public static final IronJacamarResourceCreator INSTANCE = new IronJacamarResourceCreator();

    private void setAttribute(ModelNode model, SimpleAttributeDefinition node, String value) {
        if (value != null) {
            model.get(node.getName()).set(value);
        }
    }

    private void setAttribute(ModelNode model, SimpleAttributeDefinition node, Boolean value) {
        if (value != null) {
            model.get(node.getName()).set(value.booleanValue());
        }
    }

    private void setAttribute(ModelNode model, SimpleAttributeDefinition node, Integer value) {
        if (value != null) {
            model.get(node.getName()).set(value.intValue());
        }
    }

    private void setAttribute(ModelNode model, SimpleAttributeDefinition node, Long value) {
        if (value != null) {
            model.get(node.getName()).set(value.longValue());
        }
    }

    private void addConfigProperties(Resource parent, String name, String value) {
        IronJacamarResource.IronJacamarRuntimeResource config = new IronJacamarResource.IronJacamarRuntimeResource();
        ModelNode model = config.getModel();
        model.get(Constants.CONFIG_PROPERTY_VALUE.getName()).set(value);
        PathElement element = PathElement.pathElement((String)Constants.CONFIG_PROPERTIES.getName(), (String)name);
        parent.registerChild(element, (Resource)config);
    }

    private void addConnectionDefinition(Resource parent, ConnectionDefinition connDef) {
        Recovery recovery;
        Validation validation;
        TimeOut timeOut;
        Security security;
        IronJacamarResource.IronJacamarRuntimeResource connDefResource = new IronJacamarResource.IronJacamarRuntimeResource();
        ModelNode model = connDefResource.getModel();
        this.setAttribute(model, Constants.JNDINAME, connDef.getJndiName());
        if (connDef.getConfigProperties() != null) {
            for (Map.Entry entry : connDef.getConfigProperties().entrySet()) {
                this.addConfigProperties((Resource)connDefResource, (String)entry.getKey(), (String)entry.getValue());
            }
        }
        this.setAttribute(model, Constants.CLASS_NAME, connDef.getClassName());
        this.setAttribute(model, Constants.JNDINAME, connDef.getJndiName());
        this.setAttribute(model, Constants.USE_JAVA_CONTEXT, connDef.isUseJavaContext());
        this.setAttribute(model, Constants.ENABLED, connDef.isEnabled());
        this.setAttribute(model, Constants.CONNECTABLE, connDef.isConnectable());
        if (connDef.isTracking() != null) {
            this.setAttribute(model, Constants.TRACKING, connDef.isTracking());
        }
        this.setAttribute(model, Constants.USE_CCM, connDef.isUseCcm());
        this.setAttribute(model, Constants.SHARABLE, connDef.isSharable());
        this.setAttribute(model, Constants.ENLISTMENT, connDef.isEnlistment());
        Pool pool = connDef.getPool();
        if (pool != null) {
            this.setAttribute(model, org.jboss.as.connector.subsystems.common.pool.Constants.MAX_POOL_SIZE, pool.getMaxPoolSize());
            this.setAttribute(model, org.jboss.as.connector.subsystems.common.pool.Constants.MIN_POOL_SIZE, pool.getMinPoolSize());
            this.setAttribute(model, org.jboss.as.connector.subsystems.common.pool.Constants.INITIAL_POOL_SIZE, pool.getInitialPoolSize());
            if (pool.getCapacity() != null) {
                if (pool.getCapacity().getIncrementer() != null) {
                    this.setAttribute(model, org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_INCREMENTER_CLASS, pool.getCapacity().getIncrementer().getClassName());
                    if (pool.getCapacity().getIncrementer().getConfigPropertiesMap() != null) {
                        for (Map.Entry config : pool.getCapacity().getIncrementer().getConfigPropertiesMap().entrySet()) {
                            model.get(new String[]{org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_INCREMENTER_PROPERTIES.getName(), (String)config.getKey()}).set((String)config.getValue());
                        }
                    }
                }
                if (pool.getCapacity().getDecrementer() != null) {
                    this.setAttribute(model, org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_DECREMENTER_CLASS, pool.getCapacity().getDecrementer().getClassName());
                    if (pool.getCapacity().getDecrementer().getConfigPropertiesMap() != null) {
                        for (Map.Entry config : pool.getCapacity().getDecrementer().getConfigPropertiesMap().entrySet()) {
                            model.get(new String[]{org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_DECREMENTER_PROPERTIES.getName(), (String)config.getKey()}).set((String)config.getValue());
                        }
                    }
                }
            }
            this.setAttribute(model, org.jboss.as.connector.subsystems.common.pool.Constants.POOL_USE_STRICT_MIN, pool.isUseStrictMin());
            if (pool.getFlushStrategy() != null) {
                this.setAttribute(model, org.jboss.as.connector.subsystems.common.pool.Constants.POOL_FLUSH_STRATEGY, pool.getFlushStrategy().name());
            }
            this.setAttribute(model, org.jboss.as.connector.subsystems.common.pool.Constants.POOL_PREFILL, pool.isPrefill());
            if (connDef.isXa().booleanValue()) {
                assert (connDef.getPool() instanceof XaPool);
                XaPool xaPool = (XaPool)connDef.getPool();
                this.setAttribute(model, Constants.WRAP_XA_RESOURCE, xaPool.isWrapXaResource());
                this.setAttribute(model, Constants.SAME_RM_OVERRIDE, xaPool.isSameRmOverride());
                this.setAttribute(model, Constants.PAD_XID, xaPool.isPadXid());
                this.setAttribute(model, Constants.INTERLEAVING, xaPool.isInterleaving());
                this.setAttribute(model, Constants.NOTXSEPARATEPOOL, xaPool.isNoTxSeparatePool());
            }
        }
        if ((security = connDef.getSecurity()) != null) {
            this.setAttribute(model, Constants.SECURITY_DOMAIN_AND_APPLICATION, security.getSecurityDomainAndApplication());
            this.setAttribute(model, Constants.APPLICATION, security.isApplication());
            this.setAttribute(model, Constants.SECURITY_DOMAIN, security.getSecurityDomain());
        }
        if ((timeOut = connDef.getTimeOut()) != null) {
            this.setAttribute(model, Constants.ALLOCATION_RETRY, timeOut.getAllocationRetry());
            this.setAttribute(model, Constants.ALLOCATION_RETRY_WAIT_MILLIS, timeOut.getAllocationRetryWaitMillis());
            this.setAttribute(model, org.jboss.as.connector.subsystems.common.pool.Constants.BLOCKING_TIMEOUT_WAIT_MILLIS, timeOut.getBlockingTimeoutMillis());
            this.setAttribute(model, org.jboss.as.connector.subsystems.common.pool.Constants.IDLETIMEOUTMINUTES, timeOut.getIdleTimeoutMinutes());
            this.setAttribute(model, Constants.XA_RESOURCE_TIMEOUT, timeOut.getXaResourceTimeout());
        }
        if ((validation = connDef.getValidation()) != null) {
            this.setAttribute(model, org.jboss.as.connector.subsystems.common.pool.Constants.BACKGROUNDVALIDATIONMILLIS, validation.getBackgroundValidationMillis());
            this.setAttribute(model, org.jboss.as.connector.subsystems.common.pool.Constants.BACKGROUNDVALIDATION, validation.isBackgroundValidation());
            this.setAttribute(model, org.jboss.as.connector.subsystems.common.pool.Constants.USE_FAST_FAIL, validation.isUseFastFail());
            this.setAttribute(model, org.jboss.as.connector.subsystems.common.pool.Constants.VALIDATE_ON_MATCH, validation.isValidateOnMatch());
        }
        if ((recovery = connDef.getRecovery()) != null) {
            Credential recoveryCredential;
            this.setAttribute(model, Constants.NO_RECOVERY, recovery.getNoRecovery());
            Extension recoverPlugin = recovery.getRecoverPlugin();
            if (recoverPlugin != null) {
                this.setAttribute(model, Constants.RECOVERLUGIN_CLASSNAME, recoverPlugin.getClassName());
                if (recoverPlugin.getConfigPropertiesMap() != null) {
                    for (Map.Entry config : recoverPlugin.getConfigPropertiesMap().entrySet()) {
                        model.get(new String[]{Constants.RECOVERLUGIN_PROPERTIES.getName(), (String)config.getKey()}).set((String)config.getValue());
                    }
                }
            }
            if ((recoveryCredential = recovery.getCredential()) != null) {
                this.setAttribute(model, Constants.RECOVERY_PASSWORD, recoveryCredential.getPassword());
                this.setAttribute(model, Constants.RECOVERY_SECURITY_DOMAIN, recoveryCredential.getSecurityDomain());
                this.setAttribute(model, Constants.RECOVERY_USERNAME, recoveryCredential.getUserName());
            }
        }
        PathElement element = PathElement.pathElement((String)"connection-definitions", (String)connDef.getJndiName());
        parent.registerChild(element, (Resource)connDefResource);
    }

    private void addAdminObject(Resource parent, AdminObject adminObject) {
        IronJacamarResource.IronJacamarRuntimeResource adminObjectResource = new IronJacamarResource.IronJacamarRuntimeResource();
        ModelNode model = adminObjectResource.getModel();
        this.setAttribute(model, Constants.CLASS_NAME, adminObject.getClassName());
        this.setAttribute(model, Constants.JNDINAME, adminObject.getJndiName());
        this.setAttribute(model, Constants.USE_JAVA_CONTEXT, adminObject.isUseJavaContext());
        this.setAttribute(model, Constants.ENABLED, adminObject.isEnabled());
        if (adminObject.getConfigProperties() != null) {
            for (Map.Entry config : adminObject.getConfigProperties().entrySet()) {
                this.addConfigProperties((Resource)adminObjectResource, (String)config.getKey(), (String)config.getValue());
            }
        }
        PathElement element = PathElement.pathElement((String)"admin-objects", (String)adminObject.getJndiName());
        parent.registerChild(element, (Resource)adminObjectResource);
    }

    private void addResourceAdapter(Resource parent, String name, Activation ironJacamarMetadata) {
        IronJacamarResource.IronJacamarRuntimeResource ijResourceAdapter = new IronJacamarResource.IronJacamarRuntimeResource();
        ModelNode model = ijResourceAdapter.getModel();
        model.get(Constants.ARCHIVE.getName()).set(name);
        this.setAttribute(model, Constants.BOOTSTRAP_CONTEXT, ironJacamarMetadata.getBootstrapContext());
        if (ironJacamarMetadata.getTransactionSupport() != null) {
            model.get(Constants.TRANSACTION_SUPPORT.getName()).set(ironJacamarMetadata.getTransactionSupport().name());
        }
        if (ironJacamarMetadata.getWorkManager() != null && ironJacamarMetadata.getWorkManager().getSecurity() != null) {
            PathElement element;
            ModelNode subModel;
            IronJacamarResource.IronJacamarRuntimeResource mapping;
            WorkManagerSecurity security = ironJacamarMetadata.getWorkManager().getSecurity();
            model.get(Constants.WM_SECURITY.getName()).set(true);
            if (security.getDefaultGroups() != null) {
                for (String string : security.getDefaultGroups()) {
                    model.get(Constants.WM_SECURITY_DEFAULT_GROUPS.getName()).add(string);
                }
            }
            if (security.getDefaultPrincipal() != null) {
                model.get(Constants.WM_SECURITY_DEFAULT_PRINCIPAL.getName()).set(security.getDefaultPrincipal());
            }
            model.get(Constants.WM_SECURITY_MAPPING_REQUIRED.getName()).set(security.isMappingRequired());
            model.get(Constants.WM_SECURITY_DOMAIN.getName()).set(security.getDomain());
            if (security.getGroupMappings() != null) {
                for (Map.Entry entry : security.getGroupMappings().entrySet()) {
                    mapping = new IronJacamarResource.IronJacamarRuntimeResource();
                    subModel = mapping.getModel();
                    subModel.get(Constants.WM_SECURITY_MAPPING_FROM.getName()).set((String)entry.getKey());
                    subModel.get(Constants.WM_SECURITY_MAPPING_TO.getName()).set((String)entry.getKey());
                    element = PathElement.pathElement((String)Constants.WM_SECURITY_MAPPING_GROUPS.getName(), (String)Constants.WM_SECURITY_MAPPING_GROUP.getName());
                    ijResourceAdapter.registerChild(element, (Resource)mapping);
                }
            }
            if (security.getUserMappings() != null) {
                for (Map.Entry entry : security.getUserMappings().entrySet()) {
                    mapping = new IronJacamarResource.IronJacamarRuntimeResource();
                    subModel = mapping.getModel();
                    subModel.get(Constants.WM_SECURITY_MAPPING_FROM.getName()).set((String)entry.getKey());
                    subModel.get(Constants.WM_SECURITY_MAPPING_TO.getName()).set((String)entry.getKey());
                    element = PathElement.pathElement((String)Constants.WM_SECURITY_MAPPING_USERS.getName(), (String)Constants.WM_SECURITY_MAPPING_USER.getName());
                    ijResourceAdapter.registerChild(element, (Resource)mapping);
                }
            }
        }
        if (ironJacamarMetadata.getBeanValidationGroups() != null) {
            for (String string : ironJacamarMetadata.getBeanValidationGroups()) {
                model.get(Constants.BEANVALIDATION_GROUPS.getName()).add(new ModelNode().set(string));
            }
        }
        if (ironJacamarMetadata.getConfigProperties() != null) {
            for (Map.Entry entry : ironJacamarMetadata.getConfigProperties().entrySet()) {
                this.addConfigProperties((Resource)ijResourceAdapter, (String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (ironJacamarMetadata.getConnectionDefinitions() != null) {
            for (ConnectionDefinition connectionDefinition : ironJacamarMetadata.getConnectionDefinitions()) {
                this.addConnectionDefinition((Resource)ijResourceAdapter, connectionDefinition);
            }
        }
        if (ironJacamarMetadata.getAdminObjects() != null) {
            for (AdminObject adminObject : ironJacamarMetadata.getAdminObjects()) {
                this.addAdminObject((Resource)ijResourceAdapter, adminObject);
            }
        }
        PathElement element = PathElement.pathElement((String)"resource-adapter", (String)name);
        parent.registerChild(element, (Resource)ijResourceAdapter);
    }

    private Resource getIronJacamarResource(AS7MetadataRepository mdr) {
        Resource resource = Resource.Factory.create();
        for (String name : mdr.getResourceAdaptersWithIronJacamarMetadata()) {
            this.addResourceAdapter(resource, name, mdr.getIronJacamarMetaData(name));
        }
        return resource;
    }

    public void execute(Resource parentResource, AS7MetadataRepository mdr) {
        IronJacamarResource ironJacamarResource = new IronJacamarResource();
        Resource storeModel = this.getIronJacamarResource(mdr);
        ironJacamarResource.update(storeModel);
        PathElement ijPe = PathElement.pathElement((String)"ironjacamar", (String)"ironjacamar");
        if (parentResource.getChild(ijPe) == null) {
            parentResource.registerChild(ijPe, (Resource)ironJacamarResource);
        }
    }
}

