/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.migration;

import org.jboss.logging.Logger;
import org.keycloak.migration.MigrationModel;
import org.keycloak.migration.ModelVersion;
import org.keycloak.migration.migrators.MigrateTo1_3_0;
import org.keycloak.migration.migrators.MigrateTo1_4_0;
import org.keycloak.migration.migrators.MigrateTo1_5_0;
import org.keycloak.migration.migrators.MigrationTo1_2_0_CR1;
import org.keycloak.models.KeycloakSession;

public class MigrationModelManager {
    private static Logger logger = Logger.getLogger(MigrationModelManager.class);

    public static void migrate(KeycloakSession session) {
        MigrationModel model = session.realms().getMigrationModel();
        String storedVersion = model.getStoredVersion();
        if ("1.5.0".equals(storedVersion)) {
            return;
        }
        ModelVersion stored = null;
        if (storedVersion != null) {
            stored = new ModelVersion(storedVersion);
        }
        if (stored == null || stored.lessThan(MigrationTo1_2_0_CR1.VERSION)) {
            if (stored != null) {
                logger.debug((Object)"Migrating older model to 1.2.0.CR1 updates");
            }
            new MigrationTo1_2_0_CR1().migrate(session);
        }
        if (stored == null || stored.lessThan(MigrateTo1_3_0.VERSION)) {
            if (stored != null) {
                logger.debug((Object)"Migrating older model to 1.3.0 updates");
            }
            new MigrateTo1_3_0().migrate(session);
        }
        if (stored == null || stored.lessThan(MigrateTo1_4_0.VERSION)) {
            if (stored != null) {
                logger.debug((Object)"Migrating older model to 1.4.0 updates");
            }
            new MigrateTo1_4_0().migrate(session);
        }
        if (stored == null || stored.lessThan(MigrateTo1_5_0.VERSION)) {
            if (stored != null) {
                logger.debug((Object)"Migrating older model to 1.5.0 updates");
            }
            new MigrateTo1_5_0().migrate(session);
        }
        model.setStoredVersion("1.5.0");
    }
}

