/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.configuration.attributes;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeListener;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;

public class AttributeSet
implements AttributeListener<Object> {
    private static final Log log = LogFactory.getLog(AttributeSet.class);
    private final String name;
    private final Map<String, Attribute<? extends Object>> attributes;
    private boolean protect;

    @SafeVarargs
    public AttributeSet(Class<?> klass, AttributeDefinition<?> ... attributeDefinitions) {
        this(klass.getSimpleName(), attributeDefinitions);
    }

    @SafeVarargs
    public AttributeSet(String name, AttributeDefinition<?> ... attributeDefinitions) {
        this.name = name;
        this.attributes = new HashMap<String, Attribute<? extends Object>>(attributeDefinitions.length);
        for (AttributeDefinition<?> def : attributeDefinitions) {
            if (this.attributes.containsKey(def.name())) {
                throw log.attributeSetDuplicateAttribute(def.name(), name);
            }
            Attribute<?> attribute = def.toAttribute();
            if (!attribute.isImmutable()) {
                attribute.addListener(this);
            }
            this.attributes.put(def.name(), attribute);
        }
    }

    @SafeVarargs
    public AttributeSet(Class<?> klass, AttributeSet attributeSet, AttributeDefinition<?> ... attributeDefinitions) {
        this(klass.getSimpleName(), attributeSet, attributeDefinitions);
    }

    public AttributeSet(String name, AttributeSet attributeSet, AttributeDefinition<?>[] attributeDefinitions) {
        this.name = name;
        this.attributes = new HashMap<String, Attribute<? extends Object>>(attributeDefinitions.length + attributeSet.attributes.size());
        for (Attribute<? extends Object> attribute : attributeSet.attributes.values()) {
            this.attributes.put(attribute.name(), attribute.getAttributeDefinition().toAttribute());
        }
        for (AttributeDefinition<?> def : attributeDefinitions) {
            Attribute<?> attribute = def.toAttribute();
            if (!attribute.isImmutable()) {
                attribute.addListener(this);
            }
            this.attributes.put(def.name(), attribute);
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean contains(String name) {
        return this.attributes.containsKey(name);
    }

    public <T> boolean contains(AttributeDefinition<T> def) {
        return this.contains(def.name());
    }

    public <T> Attribute<T> attribute(String name) {
        return this.attributes.get(name);
    }

    public <T> Attribute<T> attribute(AttributeDefinition<T> def) {
        Attribute<T> attribute = this.attribute(def.name());
        if (attribute != null) {
            return attribute;
        }
        throw log.noSuchAttribute(def.name(), this.name);
    }

    public void read(AttributeSet other) {
        for (Attribute<? extends Object> attribute : this.attributes.values()) {
            Attribute a = other.attribute(attribute.name());
            if (!a.isModified()) continue;
            attribute.read(a);
        }
    }

    public AttributeSet protect() {
        AttributeDefinition[] attrDefs = new AttributeDefinition[this.attributes.size()];
        int i = 0;
        for (Attribute<? extends Object> attribute : this.attributes.values()) {
            attrDefs[i++] = attribute.getAttributeDefinition();
        }
        AttributeSet protectedSet = new AttributeSet(this.name, attrDefs);
        for (Attribute<? extends Object> attribute : protectedSet.attributes.values()) {
            Attribute<? extends Object> localAttr = this.attributes.get(attribute.name());
            attribute.read(localAttr);
            attribute.protect();
        }
        protectedSet.protect = true;
        return protectedSet;
    }

    public boolean isProtected() {
        return this.protect;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AttributeSet other = (AttributeSet)obj;
        return !(this.attributes == null ? other.attributes != null : !this.attributes.equals(other.attributes));
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String name) {
        StringBuilder sb = new StringBuilder();
        if (name != null) {
            sb.append(name);
            sb.append(" = ");
        }
        sb.append("[");
        boolean comma = false;
        for (Attribute<? extends Object> value : this.attributes.values()) {
            if (comma) {
                sb.append(", ");
            } else {
                comma = true;
            }
            sb.append(value.toString());
        }
        sb.append("]");
        return sb.toString();
    }

    public AttributeSet checkProtection() {
        if (!this.protect) {
            throw log.unprotectedAttributeSet(this.name);
        }
        return this;
    }

    public void reset() {
        if (this.protect) {
            throw log.protectedAttributeSet(this.name);
        }
        Iterator<Attribute<? extends Object>> iterator = this.attributes.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().reset();
        }
    }

    @Override
    public void attributeChanged(Attribute<Object> attribute, Object oldValue) {
    }
}

