/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.token.validator;

import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.CallbackHandler;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.sts.STSPropertiesMBean;
import org.apache.cxf.sts.cache.CacheUtils;
import org.apache.cxf.sts.request.ReceivedToken;
import org.apache.cxf.sts.token.realm.CertConstraintsParser;
import org.apache.cxf.sts.token.realm.SAMLRealmCodec;
import org.apache.cxf.sts.token.validator.DefaultSAMLRoleParser;
import org.apache.cxf.sts.token.validator.SAMLRoleParser;
import org.apache.cxf.sts.token.validator.TokenValidator;
import org.apache.cxf.sts.token.validator.TokenValidatorParameters;
import org.apache.cxf.sts.token.validator.TokenValidatorResponse;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.cxf.ws.security.tokenstore.TokenStore;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.principal.SAMLTokenPrincipalImpl;
import org.apache.wss4j.common.saml.SAMLKeyInfo;
import org.apache.wss4j.common.saml.SAMLKeyInfoProcessor;
import org.apache.wss4j.common.saml.SAMLUtil;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.apache.wss4j.dom.WSDocInfo;
import org.apache.wss4j.dom.WSSConfig;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.saml.WSSSAMLKeyInfoProcessor;
import org.apache.wss4j.dom.validate.Credential;
import org.apache.wss4j.dom.validate.SignatureTrustValidator;
import org.apache.wss4j.dom.validate.Validator;
import org.joda.time.DateTime;
import org.opensaml.common.SAMLVersion;
import org.opensaml.xml.signature.KeyInfo;
import org.opensaml.xml.signature.Signature;
import org.w3c.dom.Element;

public class SAMLTokenValidator
implements TokenValidator {
    private static final Logger LOG = LogUtils.getL7dLogger(SAMLTokenValidator.class);
    private Validator validator = new SignatureTrustValidator();
    private CertConstraintsParser certConstraints = new CertConstraintsParser();
    private SAMLRealmCodec samlRealmCodec;
    private SAMLRoleParser samlRoleParser = new DefaultSAMLRoleParser();
    private boolean validateSignatureAgainstProfile = true;

    public void setSubjectConstraints(List<String> subjectConstraints) {
        this.certConstraints.setSubjectConstraints(subjectConstraints);
    }

    public void setValidator(Validator validator) {
        this.validator = validator;
    }

    public void setSamlRealmCodec(SAMLRealmCodec samlRealmCodec) {
        this.samlRealmCodec = samlRealmCodec;
    }

    @Override
    public boolean canHandleToken(ReceivedToken validateTarget) {
        return this.canHandleToken(validateTarget, null);
    }

    @Override
    public boolean canHandleToken(ReceivedToken validateTarget, String realm) {
        Object token = validateTarget.getToken();
        if (token instanceof Element) {
            Element tokenElement = (Element)token;
            String namespace = tokenElement.getNamespaceURI();
            String localname = tokenElement.getLocalName();
            if (("urn:oasis:names:tc:SAML:1.0:assertion".equals(namespace) || "urn:oasis:names:tc:SAML:2.0:assertion".equals(namespace)) && "Assertion".equals(localname)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public TokenValidatorResponse validateToken(TokenValidatorParameters tokenParameters) {
        LOG.fine("Validating SAML Token");
        STSPropertiesMBean stsProperties = tokenParameters.getStsProperties();
        Crypto sigCrypto = stsProperties.getSignatureCrypto();
        CallbackHandler callbackHandler = stsProperties.getCallbackHandler();
        TokenValidatorResponse response = new TokenValidatorResponse();
        ReceivedToken validateTarget = tokenParameters.getToken();
        validateTarget.setState(ReceivedToken.STATE.INVALID);
        response.setToken(validateTarget);
        if (!validateTarget.isDOMElement()) {
            return response;
        }
        try {
            Element validateTargetElement = (Element)validateTarget.getToken();
            SamlAssertionWrapper assertion = new SamlAssertionWrapper(validateTargetElement);
            if (!assertion.isSigned()) {
                LOG.log(Level.WARNING, "The received assertion is not signed, and therefore not trusted");
                return response;
            }
            RequestData requestData = new RequestData();
            requestData.setSigVerCrypto(sigCrypto);
            WSSConfig wssConfig = WSSConfig.getNewInstance();
            requestData.setWssConfig(wssConfig);
            requestData.setCallbackHandler(callbackHandler);
            requestData.setMsgContext((Object)tokenParameters.getWebServiceContext().getMessageContext());
            requestData.setSubjectCertConstraints(this.certConstraints.getCompiledSubjectContraints());
            WSDocInfo docInfo = new WSDocInfo(validateTargetElement.getOwnerDocument());
            Signature sig = assertion.getSignature();
            KeyInfo keyInfo = sig.getKeyInfo();
            SAMLKeyInfo samlKeyInfo = SAMLUtil.getCredentialFromKeyInfo((Element)keyInfo.getDOM(), (SAMLKeyInfoProcessor)new WSSSAMLKeyInfoProcessor(requestData, docInfo), (Crypto)sigCrypto);
            assertion.verifySignature(samlKeyInfo);
            SecurityToken secToken = null;
            byte[] signatureValue = assertion.getSignatureValue();
            if (tokenParameters.getTokenStore() != null && signatureValue != null && signatureValue.length > 0) {
                int hash = Arrays.hashCode(signatureValue);
                secToken = tokenParameters.getTokenStore().getToken(Integer.toString(hash));
                if (secToken != null && secToken.getTokenHash() != hash) {
                    secToken = null;
                }
            }
            if (secToken != null && secToken.isExpired()) {
                LOG.fine("Token: " + secToken.getId() + " is in the cache but expired - revalidating");
                secToken = null;
            }
            Object principal = null;
            if (secToken == null) {
                this.validateAssertion(assertion);
                Credential trustCredential = new Credential();
                trustCredential.setPublicKey(samlKeyInfo.getPublicKey());
                trustCredential.setCertificates(samlKeyInfo.getCerts());
                trustCredential = this.validator.validate(trustCredential, requestData);
                principal = trustCredential.getPrincipal();
                X509Certificate cert = null;
                if (trustCredential.getCertificates() != null) {
                    cert = trustCredential.getCertificates()[0];
                }
                if (!this.certConstraints.matches(cert)) {
                    return response;
                }
            }
            if (principal == null) {
                principal = new SAMLTokenPrincipalImpl(assertion);
            }
            if (this.samlRoleParser != null) {
                Set<Principal> roles = this.samlRoleParser.parseRolesFromAssertion((Principal)principal, null, assertion);
                response.setRoles(roles);
            }
            String tokenRealm = null;
            if (this.samlRealmCodec != null) {
                String cachedRealm;
                Properties props;
                tokenRealm = this.samlRealmCodec.getRealmFromToken(assertion);
                if (secToken != null && (props = secToken.getProperties()) != null && (cachedRealm = props.getProperty("org.apache.cxf.sts.token.realm")) != null && !tokenRealm.equals(cachedRealm)) {
                    return response;
                }
            }
            response.setTokenRealm(tokenRealm);
            if (!this.validateConditions(assertion, validateTarget)) {
                return response;
            }
            if (secToken == null) {
                this.storeTokenInCache(tokenParameters.getTokenStore(), assertion, tokenParameters.getPrincipal(), tokenRealm);
            }
            HashMap<String, Object> addProps = new HashMap<String, Object>();
            addProps.put(SamlAssertionWrapper.class.getName(), assertion);
            response.setAdditionalProperties(addProps);
            response.setPrincipal((Principal)principal);
            validateTarget.setState(ReceivedToken.STATE.VALID);
            LOG.fine("SAML Token successfully validated");
        }
        catch (WSSecurityException ex) {
            LOG.log(Level.WARNING, "", ex);
        }
        return response;
    }

    protected void validateAssertion(SamlAssertionWrapper assertion) throws WSSecurityException {
        assertion.validateAssertion(this.validateSignatureAgainstProfile);
    }

    protected boolean validateConditions(SamlAssertionWrapper assertion, ReceivedToken validateTarget) {
        DateTime validFrom = null;
        DateTime validTill = null;
        DateTime issueInstant = null;
        if (assertion.getSamlVersion().equals(SAMLVersion.VERSION_20)) {
            validFrom = assertion.getSaml2().getConditions().getNotBefore();
            validTill = assertion.getSaml2().getConditions().getNotOnOrAfter();
            issueInstant = assertion.getSaml2().getIssueInstant();
        } else {
            validFrom = assertion.getSaml1().getConditions().getNotBefore();
            validTill = assertion.getSaml1().getConditions().getNotOnOrAfter();
            issueInstant = assertion.getSaml1().getIssueInstant();
        }
        if (validFrom != null && validFrom.isAfterNow()) {
            LOG.log(Level.WARNING, "SAML Token condition not met");
            return false;
        }
        if (validTill != null && validTill.isBeforeNow()) {
            LOG.log(Level.WARNING, "SAML Token condition not met");
            validateTarget.setState(ReceivedToken.STATE.EXPIRED);
            return false;
        }
        if (issueInstant != null && issueInstant.isAfterNow()) {
            LOG.log(Level.WARNING, "SAML Token IssueInstant not met");
            return false;
        }
        return true;
    }

    private void storeTokenInCache(TokenStore tokenStore, SamlAssertionWrapper assertion, Principal principal, String tokenRealm) throws WSSecurityException {
        byte[] signatureValue = assertion.getSignatureValue();
        if (tokenStore != null && signatureValue != null && signatureValue.length > 0) {
            DateTime validTill = null;
            validTill = assertion.getSamlVersion().equals(SAMLVersion.VERSION_20) ? assertion.getSaml2().getConditions().getNotOnOrAfter() : assertion.getSaml1().getConditions().getNotOnOrAfter();
            SecurityToken securityToken = CacheUtils.createSecurityTokenForStorage(assertion.getElement(), assertion.getId(), validTill.toDate(), principal, tokenRealm, null);
            CacheUtils.storeTokenInCache(securityToken, tokenStore, signatureValue);
        }
    }

    public SAMLRoleParser getSamlRoleParser() {
        return this.samlRoleParser;
    }

    public void setSamlRoleParser(SAMLRoleParser samlRoleParser) {
        this.samlRoleParser = samlRoleParser;
    }

    public boolean isValidateSignatureAgainstProfile() {
        return this.validateSignatureAgainstProfile;
    }

    public void setValidateSignatureAgainstProfile(boolean validateSignatureAgainstProfile) {
        this.validateSignatureAgainstProfile = validateSignatureAgainstProfile;
    }
}

