/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.edit;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jboss.aesh.console.Config;
import org.jboss.aesh.edit.EditMode;
import org.jboss.aesh.edit.KeyOperation;
import org.jboss.aesh.edit.KeyOperationManager;
import org.jboss.aesh.edit.Mode;
import org.jboss.aesh.edit.actions.Action;
import org.jboss.aesh.edit.actions.Operation;

public class ViEditMode
implements EditMode {
    private Action mode;
    private Action previousMode;
    private Operation previousAction;
    private KeyOperationManager operationManager;
    private List<KeyOperation> currentOperations = new ArrayList<KeyOperation>();
    private int operationLevel = 0;

    public ViEditMode(KeyOperationManager operations) {
        this.mode = Action.EDIT;
        this.previousMode = Action.EDIT;
        this.operationManager = operations;
    }

    public boolean isInEditMode() {
        return this.mode == Action.EDIT;
    }

    private void switchEditMode() {
        this.mode = this.mode == Action.EDIT ? Action.MOVE : Action.EDIT;
    }

    private boolean isDeleteMode() {
        return this.mode == Action.DELETE;
    }

    private boolean isChangeMode() {
        return this.mode == Action.CHANGE;
    }

    private boolean isInReplaceMode() {
        return this.mode == Action.REPLACE;
    }

    private boolean isYankMode() {
        return this.mode == Action.YANK;
    }

    private Operation saveAction(Operation action) {
        this.previousMode = this.mode;
        if (action.getAction() != Action.MOVE) {
            this.previousAction = action;
        }
        if (this.isDeleteMode() || this.isYankMode()) {
            this.mode = Action.MOVE;
        }
        if (this.isChangeMode()) {
            this.mode = Action.EDIT;
        }
        return action;
    }

    @Override
    public Operation parseInput(int[] in, String buffer) {
        int input = in[0];
        if (Config.isOSPOSIXCompatible() && in.length > 1) {
            KeyOperation ko = this.operationManager.findOperation(in);
            if (ko != null) {
                this.currentOperations.clear();
                this.currentOperations.add(ko);
            }
        } else if (this.operationLevel > 0) {
            Iterator<KeyOperation> operationIterator = this.currentOperations.iterator();
            while (operationIterator.hasNext()) {
                if (input == operationIterator.next().getKeyValues()[this.operationLevel]) continue;
                operationIterator.remove();
            }
        } else {
            for (KeyOperation ko : this.operationManager.getOperations()) {
                if (input != ko.getFirstValue() || ko.getKeyValues().length != in.length) continue;
                this.currentOperations.add(ko);
            }
        }
        if (this.mode == Action.SEARCH) {
            if (this.currentOperations.size() == 1) {
                if (this.currentOperations.get(0).getOperation() == Operation.NEW_LINE) {
                    this.mode = Action.EDIT;
                    this.currentOperations.clear();
                    return Operation.SEARCH_END;
                }
                if (this.currentOperations.get(0).getOperation() == Operation.SEARCH_PREV) {
                    this.currentOperations.clear();
                    return Operation.SEARCH_PREV_WORD;
                }
                if (this.currentOperations.get(0).getOperation() == Operation.DELETE_PREV_CHAR) {
                    this.currentOperations.clear();
                    return Operation.SEARCH_DELETE;
                }
                if (this.currentOperations.get(0).getOperation() == Operation.ESCAPE) {
                    this.mode = Action.EDIT;
                    this.currentOperations.clear();
                    return Operation.SEARCH_EXIT;
                }
                this.currentOperations.clear();
                return Operation.SEARCH_INPUT;
            }
            if (this.currentOperations.size() > 1) {
                this.mode = Action.EDIT;
                this.currentOperations.clear();
                return Operation.SEARCH_EXIT;
            }
            this.currentOperations.clear();
            return Operation.SEARCH_INPUT;
        }
        if (this.isInReplaceMode()) {
            if (this.currentOperations.size() == 1 && this.currentOperations.get(0).getOperation() == Operation.ESCAPE) {
                this.operationLevel = 0;
                this.currentOperations.clear();
                this.mode = Action.MOVE;
                return Operation.NO_ACTION;
            }
            this.operationLevel = 0;
            this.currentOperations.clear();
            this.mode = Action.MOVE;
            return this.saveAction(Operation.REPLACE);
        }
        if (this.currentOperations.isEmpty()) {
            if (this.isInEditMode()) {
                return Operation.EDIT;
            }
            return Operation.NO_ACTION;
        }
        if (this.currentOperations.size() == 1) {
            Operation operation = this.currentOperations.get(0).getOperation();
            Action workingMode = this.currentOperations.get(0).getWorkingMode();
            this.operationLevel = 0;
            this.currentOperations.clear();
            if (operation == Operation.EXIT) {
                if (buffer.isEmpty()) {
                    return operation;
                }
                return Operation.NEW_LINE;
            }
            if (operation == Operation.NEW_LINE) {
                this.mode = Action.EDIT;
                return Operation.NEW_LINE;
            }
            if (operation == Operation.REPLACE && !this.isInEditMode()) {
                this.mode = Action.REPLACE;
                return Operation.NO_ACTION;
            }
            if (operation == Operation.DELETE_PREV_CHAR && workingMode == Action.NO_ACTION) {
                if (this.isInEditMode()) {
                    return Operation.DELETE_PREV_CHAR;
                }
                return Operation.MOVE_PREV_CHAR;
            }
            if (operation == Operation.DELETE_NEXT_CHAR && workingMode == Action.COMMAND) {
                if (this.isInEditMode()) {
                    return Operation.NO_ACTION;
                }
                return this.saveAction(Operation.DELETE_NEXT_CHAR);
            }
            if (operation == Operation.COMPLETE) {
                if (this.isInEditMode()) {
                    return Operation.COMPLETE;
                }
                return Operation.NO_ACTION;
            }
            if (operation == Operation.ESCAPE) {
                this.switchEditMode();
                if (this.isInEditMode()) {
                    return Operation.NO_ACTION;
                }
                return Operation.MOVE_PREV_CHAR;
            }
            if (operation == Operation.SEARCH_PREV) {
                this.mode = Action.SEARCH;
                return Operation.SEARCH_PREV;
            }
            if (operation == Operation.CLEAR) {
                return Operation.CLEAR;
            }
            if (operation == Operation.MOVE_PREV_CHAR && workingMode.equals((Object)Action.EDIT)) {
                return Operation.MOVE_PREV_CHAR;
            }
            if (operation == Operation.MOVE_NEXT_CHAR && workingMode.equals((Object)Action.EDIT)) {
                return Operation.MOVE_NEXT_CHAR;
            }
            if (operation == Operation.HISTORY_PREV && workingMode.equals((Object)Action.EDIT)) {
                return operation;
            }
            if (operation == Operation.HISTORY_NEXT && workingMode.equals((Object)Action.EDIT)) {
                return operation;
            }
            if (!this.isInEditMode()) {
                return this.inCommandMode(operation, workingMode);
            }
            return Operation.EDIT;
        }
        ++this.operationLevel;
        return Operation.NO_ACTION;
    }

    private Operation inCommandMode(Operation operation, Action workingMode) {
        if (operation == Operation.PREV_CHAR) {
            if (this.mode == Action.MOVE) {
                return this.saveAction(Operation.MOVE_PREV_CHAR);
            }
            if (this.mode == Action.DELETE) {
                return this.saveAction(Operation.DELETE_PREV_CHAR);
            }
            if (this.mode == Action.CHANGE) {
                return this.saveAction(Operation.CHANGE_PREV_CHAR);
            }
            return this.saveAction(Operation.YANK_PREV_CHAR);
        }
        if (operation == Operation.NEXT_CHAR) {
            if (this.mode == Action.MOVE) {
                return this.saveAction(Operation.MOVE_NEXT_CHAR);
            }
            if (this.mode == Action.DELETE) {
                return this.saveAction(Operation.DELETE_NEXT_CHAR);
            }
            if (this.mode == Action.CHANGE) {
                return this.saveAction(Operation.CHANGE_NEXT_CHAR);
            }
            return this.saveAction(Operation.YANK_NEXT_CHAR);
        }
        if (operation == Operation.HISTORY_NEXT) {
            return this.saveAction(Operation.HISTORY_NEXT);
        }
        if (operation == Operation.HISTORY_PREV) {
            return this.saveAction(Operation.HISTORY_PREV);
        }
        if (operation == Operation.PREV_WORD) {
            if (this.mode == Action.MOVE) {
                return this.saveAction(Operation.MOVE_PREV_WORD);
            }
            if (this.mode == Action.DELETE) {
                return this.saveAction(Operation.DELETE_PREV_WORD);
            }
            if (this.mode == Action.CHANGE) {
                return this.saveAction(Operation.CHANGE_PREV_WORD);
            }
            return this.saveAction(Operation.YANK_PREV_WORD);
        }
        if (operation == Operation.PREV_BIG_WORD) {
            if (this.mode == Action.MOVE) {
                return this.saveAction(Operation.MOVE_PREV_BIG_WORD);
            }
            if (this.mode == Action.DELETE) {
                return this.saveAction(Operation.DELETE_PREV_BIG_WORD);
            }
            if (this.mode == Action.CHANGE) {
                return this.saveAction(Operation.CHANGE_PREV_BIG_WORD);
            }
            return this.saveAction(Operation.YANK_PREV_BIG_WORD);
        }
        if (operation == Operation.NEXT_WORD) {
            if (this.mode == Action.MOVE) {
                return this.saveAction(Operation.MOVE_NEXT_WORD);
            }
            if (this.mode == Action.DELETE) {
                return this.saveAction(Operation.DELETE_NEXT_WORD);
            }
            if (this.mode == Action.CHANGE) {
                return this.saveAction(Operation.CHANGE_NEXT_WORD);
            }
            return this.saveAction(Operation.YANK_NEXT_WORD);
        }
        if (operation == Operation.NEXT_BIG_WORD) {
            if (this.mode == Action.MOVE) {
                return this.saveAction(Operation.MOVE_NEXT_BIG_WORD);
            }
            if (this.mode == Action.DELETE) {
                return this.saveAction(Operation.DELETE_NEXT_BIG_WORD);
            }
            if (this.mode == Action.CHANGE) {
                return this.saveAction(Operation.CHANGE_NEXT_BIG_WORD);
            }
            return this.saveAction(Operation.YANK_NEXT_BIG_WORD);
        }
        if (operation == Operation.BEGINNING) {
            if (this.mode == Action.MOVE) {
                return this.saveAction(Operation.MOVE_BEGINNING);
            }
            if (this.mode == Action.DELETE) {
                return this.saveAction(Operation.DELETE_BEGINNING);
            }
            if (this.mode == Action.CHANGE) {
                return this.saveAction(Operation.CHANGE_BEGINNING);
            }
            return this.saveAction(Operation.YANK_BEGINNING);
        }
        if (operation == Operation.END) {
            if (this.mode == Action.MOVE) {
                return this.saveAction(Operation.MOVE_END);
            }
            if (this.mode == Action.DELETE) {
                return this.saveAction(Operation.DELETE_END);
            }
            if (this.mode == Action.CHANGE) {
                return this.saveAction(Operation.CHANGE_END);
            }
            return this.saveAction(Operation.YANK_END);
        }
        if (operation == Operation.DELETE_NEXT_CHAR) {
            return this.saveAction(operation);
        }
        if (operation == Operation.DELETE_PREV_CHAR && workingMode == Action.COMMAND) {
            return this.saveAction(operation);
        }
        if (operation == Operation.PASTE_AFTER) {
            return this.saveAction(operation);
        }
        if (operation == Operation.PASTE_BEFORE) {
            return this.saveAction(operation);
        }
        if (operation == Operation.CHANGE_NEXT_CHAR) {
            this.switchEditMode();
            return this.saveAction(operation);
        }
        if (operation == Operation.CHANGE_ALL) {
            this.mode = Action.CHANGE;
            return this.saveAction(operation);
        }
        if (operation == Operation.MOVE_NEXT_CHAR) {
            this.switchEditMode();
            return this.saveAction(operation);
        }
        if (operation == Operation.MOVE_END) {
            this.switchEditMode();
            return this.saveAction(operation);
        }
        if (operation == Operation.INSERT) {
            this.switchEditMode();
            return this.saveAction(Operation.NO_ACTION);
        }
        if (operation == Operation.INSERT_BEGINNING) {
            this.switchEditMode();
            return this.saveAction(Operation.MOVE_BEGINNING);
        }
        if (operation == Operation.DELETE_ALL) {
            if (this.isDeleteMode()) {
                return this.saveAction(operation);
            }
            this.mode = Action.DELETE;
        } else {
            if (operation == Operation.DELETE_END) {
                this.mode = Action.DELETE;
                return this.saveAction(operation);
            }
            if (operation == Operation.CHANGE) {
                if (this.isChangeMode()) {
                    return this.saveAction(Operation.CHANGE_ALL);
                }
                this.mode = Action.CHANGE;
            } else {
                if (operation == Operation.CHANGE_END) {
                    this.mode = Action.CHANGE;
                    return this.saveAction(operation);
                }
                if (operation == Operation.REPEAT) {
                    this.mode = this.previousMode;
                    return this.previousAction;
                }
                if (operation == Operation.UNDO) {
                    return this.saveAction(operation);
                }
                if (operation == Operation.CASE) {
                    return this.saveAction(operation);
                }
                if (operation == Operation.YANK_ALL) {
                    if (this.isYankMode()) {
                        return this.saveAction(operation);
                    }
                    this.mode = Action.YANK;
                } else if (operation == Operation.VI_EDIT_MODE || operation == Operation.EMACS_EDIT_MODE) {
                    return operation;
                }
            }
        }
        return Operation.NO_ACTION;
    }

    @Override
    public Action getCurrentAction() {
        return this.mode;
    }

    @Override
    public Mode getMode() {
        return Mode.VI;
    }
}

