/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import java.util.Collection;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ejb3.cache.CacheFactoryBuilder;
import org.jboss.as.ejb3.cache.CacheFactoryBuilderRegistry;
import org.jboss.as.ejb3.cache.CacheFactoryBuilderRegistryService;
import org.jboss.as.ejb3.component.stateful.VersionedMarshallingConfigurationService;
import org.jboss.as.ejb3.deployment.ModuleDeployment;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;

public class CacheDependenciesProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext context) {
        DeploymentUnit unit = context.getDeploymentUnit();
        final ServiceName name = unit.getServiceName();
        EEModuleDescription moduleDescription = (EEModuleDescription)unit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        if (moduleDescription == null) {
            return;
        }
        final ServiceTarget target = context.getServiceTarget();
        final InjectedValue registry = new InjectedValue();
        AbstractService<Void> service = new AbstractService<Void>(){

            public void start(StartContext context) {
                Collection builders = ((CacheFactoryBuilderRegistry)registry.getValue()).getBuilders();
                for (CacheFactoryBuilder builder : builders) {
                    builder.installDeploymentUnitDependencies(target, name);
                }
            }
        };
        target.addService(name.append(new String[]{"cache-dependencies-installer"}), (Service)service).addDependency(CacheFactoryBuilderRegistryService.SERVICE_NAME, CacheFactoryBuilderRegistry.class, (Injector)registry).install();
        InjectedValue deployment = new InjectedValue();
        Module module = (Module)unit.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE);
        ImmediateValue moduleLoader = new ImmediateValue((Object)module.getModuleLoader());
        target.addService(VersionedMarshallingConfigurationService.getServiceName(name), (Service)new VersionedMarshallingConfigurationService((Value<ModuleDeployment>)deployment, (Value<ModuleLoader>)moduleLoader)).addDependency(name.append(ModuleDeployment.SERVICE_NAME), ModuleDeployment.class, (Injector)deployment).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
    }

    public void undeploy(DeploymentUnit context) {
    }
}

