/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.clustered;

import java.util.UUID;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.infinispan.query.clustered.ClusteredDoc;
import org.infinispan.query.clustered.ClusteredScoreDoc;
import org.infinispan.remoting.transport.Address;

public class ClusteredTopDocs {
    private int currentIndex = 0;
    private final TopDocs topDocs;
    private final UUID id;
    private Address nodeAddress;

    ClusteredTopDocs(TopDocs topDocs, UUID id) {
        this.topDocs = topDocs;
        this.id = id;
    }

    public UUID getId() {
        return this.id;
    }

    public boolean hasNext() {
        return this.currentIndex < this.topDocs.scoreDocs.length;
    }

    public TopDocs getTopDocs() {
        return this.topDocs;
    }

    public ClusteredDoc getNext() {
        if (this.currentIndex >= this.topDocs.scoreDocs.length) {
            return null;
        }
        ScoreDoc scoreDoc = this.topDocs.scoreDocs[this.currentIndex];
        return new ClusteredScoreDoc(scoreDoc, this.id, this.currentIndex++);
    }

    public void setNodeAddress(Address nodeAddress) {
        this.nodeAddress = nodeAddress;
    }

    public Address getNodeAddress() {
        return this.nodeAddress;
    }
}

