/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.HashConfigurationBuilder;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.distribution.ch.impl.DefaultConsistentHashFactory;
import org.infinispan.distribution.ch.impl.ReplicatedConsistentHashFactory;
import org.infinispan.distribution.ch.impl.SyncConsistentHashFactory;
import org.infinispan.distribution.ch.impl.TopologyAwareConsistentHashFactory;
import org.infinispan.distribution.ch.impl.TopologyAwareSyncConsistentHashFactory;

public enum ConsistentHashStrategy {
    INTER_CACHE{

        @Override
        ConsistentHashFactory<? extends ConsistentHash> createConsistentHashFactory(boolean topologyAware) {
            return topologyAware ? new TopologyAwareSyncConsistentHashFactory() : new SyncConsistentHashFactory();
        }
    }
    ,
    INTRA_CACHE{

        @Override
        ConsistentHashFactory<? extends ConsistentHash> createConsistentHashFactory(boolean topologyAware) {
            return topologyAware ? new TopologyAwareConsistentHashFactory() : new DefaultConsistentHashFactory();
        }
    };

    static final ConsistentHashStrategy DEFAULT;

    abstract ConsistentHashFactory<? extends ConsistentHash> createConsistentHashFactory(boolean var1);

    public void buildHashConfiguration(HashConfigurationBuilder builder, CacheMode mode, boolean topologyAware) {
        if (mode.isClustered()) {
            if (mode.isDistributed()) {
                builder.consistentHashFactory(this.createConsistentHashFactory(topologyAware));
            } else {
                builder.consistentHashFactory((ConsistentHashFactory)new ReplicatedConsistentHashFactory());
            }
        }
    }

    static {
        DEFAULT = INTRA_CACHE;
    }
}

