/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.internal;

import java.util.List;
import org.picketlink.idm.IDMInternalMessages;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.PartitionManager;
import org.picketlink.idm.RelationshipManager;
import org.picketlink.idm.config.IdentityStoreConfiguration;
import org.picketlink.idm.event.RelationshipCreatedEvent;
import org.picketlink.idm.event.RelationshipDeletedEvent;
import org.picketlink.idm.event.RelationshipUpdatedEvent;
import org.picketlink.idm.internal.AbstractAttributedTypeManager;
import org.picketlink.idm.internal.DefaultPartitionManager;
import org.picketlink.idm.internal.PrivilegeChainQuery;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.query.RelationshipQuery;
import org.picketlink.idm.query.internal.DefaultRelationshipQuery;
import org.picketlink.idm.spi.IdentityContext;

public class ContextualRelationshipManager
extends AbstractAttributedTypeManager<Relationship>
implements RelationshipManager {
    private final PartitionManager partitionManager;

    public ContextualRelationshipManager(DefaultPartitionManager partitionManager) {
        super(partitionManager.getConfiguration(), null);
        this.partitionManager = partitionManager;
    }

    @Override
    protected void doAdd(Relationship relationship) {
        IdentityContext identityContext = this.getIdentityContext();
        this.getStoreSelector().getStoreForRelationshipOperation(identityContext, relationship.getClass(), relationship, IdentityStoreConfiguration.IdentityOperation.create).add(identityContext, (AttributedType)relationship);
    }

    @Override
    protected void fireAttributedTypeAddedEvent(Relationship relationship) {
        this.fireEvent(new RelationshipCreatedEvent(relationship, this.partitionManager));
    }

    @Override
    protected void fireAttributedTypeUpdatedEvent(Relationship relationship) {
        this.fireEvent(new RelationshipUpdatedEvent(relationship, this.partitionManager));
    }

    @Override
    protected void doUpdate(Relationship relationship) {
        IdentityContext identityContext = this.getIdentityContext();
        this.getStoreSelector().getStoreForRelationshipOperation(identityContext, relationship.getClass(), relationship, IdentityStoreConfiguration.IdentityOperation.update).update(identityContext, (AttributedType)relationship);
    }

    @Override
    protected void fireAttributedTypeRemovedEvent(Relationship attributedType) {
        this.fireEvent(new RelationshipDeletedEvent(attributedType, this.partitionManager));
    }

    @Override
    protected void doRemove(Relationship relationship) {
        IdentityContext identityContext = this.getIdentityContext();
        this.getStoreSelector().getStoreForRelationshipOperation(identityContext, relationship.getClass(), relationship, IdentityStoreConfiguration.IdentityOperation.delete).remove(identityContext, (AttributedType)relationship);
    }

    public <T extends Relationship> RelationshipQuery<T> createRelationshipQuery(Class<T> relationshipClass) {
        if (relationshipClass == null) {
            IDMInternalMessages.MESSAGES.nullArgument("Relationship Type");
        }
        return new DefaultRelationshipQuery<T>(this.getIdentityContext(), relationshipClass, this);
    }

    public <C extends Relationship> C lookupById(Class<C> attributedType, String id) throws IdentityManagementException {
        List result = this.createRelationshipQuery(attributedType).setParameter(Relationship.ID, new Object[]{id}).getResultList();
        if (!result.isEmpty()) {
            return (C)((Relationship)result.get(0));
        }
        return null;
    }

    public boolean inheritsPrivileges(IdentityType identity, IdentityType assignee) {
        if (identity.equals(assignee)) {
            return true;
        }
        PrivilegeChainQuery privilegeChainQuery = this.getConfiguration().getPrivilegeChainQuery();
        return privilegeChainQuery.inheritsPrivileges(this, identity, assignee);
    }

    @Override
    protected void checkUniqueness(Relationship attributedType) throws IdentityManagementException {
    }

    @Override
    protected void checkIfExists(Relationship attributedType) throws IdentityManagementException {
    }

    public PartitionManager getPartitionManager() {
        return this.partitionManager;
    }
}

