/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.timerservice.schedule.attribute;

import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.timerservice.schedule.attribute.IntegerBasedExpression;
import org.jboss.as.ejb3.timerservice.schedule.util.CalendarUtil;
import org.jboss.as.ejb3.timerservice.schedule.value.RangeValue;
import org.jboss.as.ejb3.timerservice.schedule.value.ScheduleExpressionType;
import org.jboss.as.ejb3.timerservice.schedule.value.ScheduleValue;
import org.jboss.as.ejb3.timerservice.schedule.value.SingleValue;

public class DayOfMonth
extends IntegerBasedExpression {
    public static final Integer MAX_DAY_OF_MONTH = 31;
    public static final Integer MIN_DAY_OF_MONTH = -7;
    private static final Map<String, Integer> DAY_OF_MONTH_ALIAS = new HashMap<String, Integer>();
    private static final Set<String> ORDINALS;
    private static final Map<String, Integer> ORDINAL_TO_WEEK_NUMBER_MAPPING;

    public DayOfMonth(String value) {
        super(value);
    }

    @Override
    protected Integer getMaxValue() {
        return MAX_DAY_OF_MONTH;
    }

    @Override
    protected Integer getMinValue() {
        return MIN_DAY_OF_MONTH;
    }

    public Integer getNextMatch(Calendar currentCal) {
        if (this.scheduleExpressionType == ScheduleExpressionType.WILDCARD) {
            return currentCal.get(5);
        }
        int currentDayOfMonth = currentCal.get(5);
        SortedSet<Integer> eligibleDaysOfMonth = this.getEligibleDaysOfMonth(currentCal);
        if (eligibleDaysOfMonth.isEmpty()) {
            return null;
        }
        for (Integer hour : eligibleDaysOfMonth) {
            if (currentDayOfMonth == hour) {
                return currentDayOfMonth;
            }
            if (hour <= currentDayOfMonth) continue;
            return hour;
        }
        return eligibleDaysOfMonth.first();
    }

    @Override
    protected void assertValid(Integer value) throws IllegalArgumentException {
        if (value != null && value == 0) {
            throw EjbLogger.ROOT_LOGGER.invalidValueDayOfMonth(value);
        }
        super.assertValid(value);
    }

    private boolean hasRelativeDayOfMonth() {
        return !this.relativeValues.isEmpty();
    }

    private SortedSet<Integer> getEligibleDaysOfMonth(Calendar cal) {
        if (!this.hasRelativeDayOfMonth()) {
            return this.absoluteValues;
        }
        TreeSet<Integer> eligibleDaysOfMonth = new TreeSet<Integer>(this.absoluteValues);
        for (ScheduleValue relativeValue : this.relativeValues) {
            int i;
            if (relativeValue instanceof SingleValue) {
                SingleValue singleValue = (SingleValue)relativeValue;
                String value = singleValue.getValue();
                Integer absoluteDayOfMonth = this.getAbsoluteDayOfMonth(cal, value);
                eligibleDaysOfMonth.add(absoluteDayOfMonth);
                continue;
            }
            if (!(relativeValue instanceof RangeValue)) continue;
            RangeValue range = (RangeValue)relativeValue;
            String start = range.getStart();
            String end = range.getEnd();
            Integer dayOfMonthStart = null;
            dayOfMonthStart = this.isRelativeValue(start) ? Integer.valueOf(this.getAbsoluteDayOfMonth(cal, start)) : this.parseInt(start);
            Integer dayOfMonthEnd = null;
            dayOfMonthEnd = this.isRelativeValue(end) ? Integer.valueOf(this.getAbsoluteDayOfMonth(cal, end)) : this.parseInt(end);
            this.assertValid(dayOfMonthStart);
            this.assertValid(dayOfMonthEnd);
            if (dayOfMonthStart.equals(dayOfMonthEnd)) {
                eligibleDaysOfMonth.add(dayOfMonthEnd);
                continue;
            }
            if (dayOfMonthStart > dayOfMonthEnd) {
                for (i = dayOfMonthStart.intValue(); i <= this.getMaxValue(); ++i) {
                    eligibleDaysOfMonth.add(i);
                }
                for (i = this.getMinValue().intValue(); i <= dayOfMonthEnd; ++i) {
                    eligibleDaysOfMonth.add(i);
                }
                continue;
            }
            for (i = dayOfMonthStart.intValue(); i <= dayOfMonthEnd; ++i) {
                eligibleDaysOfMonth.add(i);
            }
        }
        return eligibleDaysOfMonth;
    }

    private int getAbsoluteDayOfMonth(Calendar cal, String relativeDayOfMonth) {
        if (relativeDayOfMonth == null || relativeDayOfMonth.trim().isEmpty()) {
            throw EjbLogger.ROOT_LOGGER.relativeDayOfMonthIsNull();
        }
        String trimmedRelativeDayOfMonth = relativeDayOfMonth.trim();
        if (trimmedRelativeDayOfMonth.equalsIgnoreCase("last")) {
            int lastDayOfCurrentMonth = CalendarUtil.getLastDateOfMonth(cal);
            return lastDayOfCurrentMonth;
        }
        if (this.isValidNegativeDayOfMonth(trimmedRelativeDayOfMonth)) {
            Integer negativeRelativeDayOfMonth = Integer.parseInt(trimmedRelativeDayOfMonth);
            int lastDayOfCurrentMonth = CalendarUtil.getLastDateOfMonth(cal);
            return lastDayOfCurrentMonth + negativeRelativeDayOfMonth;
        }
        if (this.isDayOfWeekBased(trimmedRelativeDayOfMonth)) {
            String[] parts = trimmedRelativeDayOfMonth.split("\\s+");
            String ordinal = parts[0];
            String day = parts[1];
            int dayOfWeek = DAY_OF_MONTH_ALIAS.get(day.toLowerCase(Locale.ENGLISH));
            Integer date = null;
            if (ordinal.equalsIgnoreCase("last")) {
                date = CalendarUtil.getDateOfLastDayOfWeekInMonth(cal, dayOfWeek);
            } else {
                int weekNumber = ORDINAL_TO_WEEK_NUMBER_MAPPING.get(ordinal.toLowerCase(Locale.ENGLISH));
                date = CalendarUtil.getNthDayOfMonth(cal, weekNumber, dayOfWeek);
            }
            if (date == null) {
                date = CalendarUtil.getLastDateOfMonth(cal);
            }
            return date;
        }
        throw EjbLogger.ROOT_LOGGER.invalidRelativeValue(relativeDayOfMonth);
    }

    private boolean isValidNegativeDayOfMonth(String dayOfMonth) {
        try {
            Integer val = Integer.parseInt(dayOfMonth.trim());
            return val <= -1 && val >= -7;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    private boolean isDayOfWeekBased(String relativeVal) {
        String trimmedVal = relativeVal.trim();
        Pattern p = Pattern.compile("\\s+");
        String[] relativeParts = p.split(trimmedVal);
        if (relativeParts == null) {
            return false;
        }
        if (relativeParts.length != 2) {
            return false;
        }
        String ordinal = relativeParts[0];
        String dayOfWeek = relativeParts[1];
        if (ordinal == null || dayOfWeek == null) {
            return false;
        }
        String lowerCaseOrdinal = ordinal.toLowerCase(Locale.ENGLISH);
        if (!ORDINALS.contains(lowerCaseOrdinal)) {
            return false;
        }
        String lowerCaseDayOfWeek = dayOfWeek.toLowerCase(Locale.ENGLISH);
        return DAY_OF_MONTH_ALIAS.containsKey(lowerCaseDayOfWeek);
    }

    @Override
    public boolean isRelativeValue(String value) {
        if (value == null) {
            throw EjbLogger.ROOT_LOGGER.relativeValueIsNull();
        }
        if (value.equalsIgnoreCase("last")) {
            return true;
        }
        if (this.isValidNegativeDayOfMonth(value)) {
            return true;
        }
        return this.isDayOfWeekBased(value);
    }

    @Override
    protected boolean accepts(ScheduleExpressionType scheduleExprType) {
        switch (scheduleExprType) {
            case RANGE: 
            case LIST: 
            case SINGLE_VALUE: 
            case WILDCARD: {
                return true;
            }
        }
        return false;
    }

    public Integer getFirstMatch(Calendar cal) {
        if (this.scheduleExpressionType == ScheduleExpressionType.WILDCARD) {
            return 1;
        }
        SortedSet<Integer> eligibleDaysOfMonth = this.getEligibleDaysOfMonth(cal);
        if (eligibleDaysOfMonth.isEmpty()) {
            return null;
        }
        return eligibleDaysOfMonth.first();
    }

    @Override
    protected Integer parseInt(String alias) {
        try {
            return super.parseInt(alias);
        }
        catch (NumberFormatException nfe) {
            if (DAY_OF_MONTH_ALIAS != null) {
                String lowerCaseAlias = alias.toLowerCase(Locale.ENGLISH);
                return DAY_OF_MONTH_ALIAS.get(lowerCaseAlias);
            }
            return null;
        }
    }

    static {
        DAY_OF_MONTH_ALIAS.put("sun", 1);
        DAY_OF_MONTH_ALIAS.put("mon", 2);
        DAY_OF_MONTH_ALIAS.put("tue", 3);
        DAY_OF_MONTH_ALIAS.put("wed", 4);
        DAY_OF_MONTH_ALIAS.put("thu", 5);
        DAY_OF_MONTH_ALIAS.put("fri", 6);
        DAY_OF_MONTH_ALIAS.put("sat", 7);
        ORDINALS = new HashSet<String>();
        ORDINAL_TO_WEEK_NUMBER_MAPPING = new HashMap<String, Integer>();
        ORDINALS.add("1st");
        ORDINALS.add("2nd");
        ORDINALS.add("3rd");
        ORDINALS.add("4th");
        ORDINALS.add("5th");
        ORDINALS.add("last");
        ORDINAL_TO_WEEK_NUMBER_MAPPING.put("1st", 1);
        ORDINAL_TO_WEEK_NUMBER_MAPPING.put("2nd", 2);
        ORDINAL_TO_WEEK_NUMBER_MAPPING.put("3rd", 3);
        ORDINAL_TO_WEEK_NUMBER_MAPPING.put("4th", 4);
        ORDINAL_TO_WEEK_NUMBER_MAPPING.put("5th", 5);
    }
}

