/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.jboss.logging.Logger;
import org.keycloak.freemarker.Theme;
import org.keycloak.services.resources.admin.AdminConsole;

public class AdminMessagesLoader {
    protected static final Logger logger = Logger.getLogger(AdminConsole.class);
    protected static final Map<String, Map<String, Properties>> allMessages = new HashMap<String, Map<String, Properties>>();

    static Properties getMessages(Theme theme, String strLocale) throws IOException {
        String themeName = theme.getName();
        Map<String, Properties> bundlesForTheme = allMessages.get(themeName);
        if (bundlesForTheme == null) {
            bundlesForTheme = new HashMap<String, Properties>();
            allMessages.put(themeName, bundlesForTheme);
        }
        return AdminMessagesLoader.findMessagesForTheme(theme, strLocale, bundlesForTheme);
    }

    private static Properties findMessagesForTheme(Theme theme, String strLocale, Map<String, Properties> bundlesForTheme) throws IOException {
        Properties messages = bundlesForTheme.get(strLocale);
        if (messages != null) {
            return messages;
        }
        Locale locale = Locale.forLanguageTag(strLocale);
        messages = theme.getMessages("admin-messages", locale);
        String themeName = theme.getName();
        if (messages == null) {
            throw new NullPointerException(themeName + ": Unable to find admin-messages bundle for locale=" + strLocale);
        }
        if (!bundlesForTheme.isEmpty()) {
            String standardLocale = bundlesForTheme.keySet().iterator().next();
            Properties standardBundle = bundlesForTheme.get(standardLocale);
            AdminMessagesLoader.validateMessages(themeName, standardBundle, standardLocale, messages, strLocale);
        }
        bundlesForTheme.put(strLocale, messages);
        return messages;
    }

    private static void validateMessages(String themeName, Properties standardBundle, String standardLocale, Properties messages, String strLocale) {
        if (standardBundle.keySet().containsAll(messages.keySet()) && messages.keySet().containsAll(standardBundle.keySet())) {
            return;
        }
        int warnCount = 0;
        for (Object key : standardBundle.keySet()) {
            if (!messages.containsKey(key)) {
                logger.error((Object)(themeName + " theme: Key '" + key + "' not found in admin-messages bundle for locale=" + strLocale + ". However, this key exists in previously loaded bundle for locale=" + standardLocale));
                ++warnCount;
            }
            if (warnCount <= 4) continue;
            return;
        }
        for (Object key : messages.keySet()) {
            if (!standardBundle.containsKey(key)) {
                logger.error((Object)(themeName + " theme: Key '" + key + "' was found in admin-messages bundle for locale=" + strLocale + ". However, this key does not exist in previously loaded bundle for locale=" + standardLocale));
                ++warnCount;
            }
            if (warnCount <= 4) continue;
            return;
        }
    }
}

