/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin.info;

public class MemoryInfoRepresentation {
    protected long total;
    protected long used;

    public static MemoryInfoRepresentation create() {
        MemoryInfoRepresentation rep = new MemoryInfoRepresentation();
        Runtime runtime = Runtime.getRuntime();
        rep.total = runtime.maxMemory();
        rep.used = runtime.totalMemory() - runtime.freeMemory();
        return rep;
    }

    public long getTotal() {
        return this.total;
    }

    public String getTotalFormated() {
        return this.formatMemory(this.getTotal());
    }

    public long getFree() {
        return this.getTotal() - this.getUsed();
    }

    public String getFreeFormated() {
        return this.formatMemory(this.getFree());
    }

    public long getUsed() {
        return this.used;
    }

    public String getUsedFormated() {
        return this.formatMemory(this.getUsed());
    }

    public long getFreePercentage() {
        return this.getFree() * 100L / this.getTotal();
    }

    private String formatMemory(long bytes) {
        if (bytes > 0x100000L) {
            return bytes / 0x100000L + " MB";
        }
        if (bytes > 1024L) {
            return bytes / 1024L + " kB";
        }
        return bytes + " B";
    }
}

