/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl;

import java.util.LinkedList;
import java.util.List;
import org.infinispan.AdvancedCache;
import org.infinispan.query.backend.KeyTransformationHandler;

public class ProjectionConverter {
    private final AdvancedCache<?, ?> cache;
    private final KeyTransformationHandler keyTransformationHandler;
    private final String[] hibernateSearchFields;
    private final List<Integer> indexesOfKey = new LinkedList<Integer>();

    public ProjectionConverter(String[] fields, AdvancedCache<?, ?> cache, KeyTransformationHandler keyTransformationHandler) {
        this.cache = cache;
        this.keyTransformationHandler = keyTransformationHandler;
        this.hibernateSearchFields = (String[])fields.clone();
        for (int i = 0; i < this.hibernateSearchFields.length; ++i) {
            String field = this.hibernateSearchFields[i];
            if (!field.equals("__ISPN_Key")) continue;
            this.hibernateSearchFields[i] = "__HSearch_id";
            this.indexesOfKey.add(i);
        }
    }

    public String[] getHSearchProjection() {
        return this.hibernateSearchFields;
    }

    public Object[] convert(Object[] projection) {
        for (Integer index : this.indexesOfKey) {
            projection[index.intValue()] = this.keyTransformationHandler.stringToKey((String)projection[index], this.cache.getClassLoader());
        }
        return projection;
    }
}

