/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa.session;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.jpa.session.PersistentClientSessionEntity;
import org.keycloak.models.jpa.session.PersistentUserSessionEntity;
import org.keycloak.models.session.PersistentClientSessionAdapter;
import org.keycloak.models.session.PersistentClientSessionModel;
import org.keycloak.models.session.PersistentUserSessionAdapter;
import org.keycloak.models.session.PersistentUserSessionModel;
import org.keycloak.models.session.UserSessionPersisterProvider;

public class JpaUserSessionPersisterProvider
implements UserSessionPersisterProvider {
    private final KeycloakSession session;
    private final EntityManager em;

    public JpaUserSessionPersisterProvider(KeycloakSession session, EntityManager em) {
        this.session = session;
        this.em = em;
    }

    public void createUserSession(UserSessionModel userSession, boolean offline) {
        PersistentUserSessionAdapter adapter = new PersistentUserSessionAdapter(userSession);
        PersistentUserSessionModel model = adapter.getUpdatedModel();
        PersistentUserSessionEntity entity = new PersistentUserSessionEntity();
        entity.setUserSessionId(model.getUserSessionId());
        entity.setRealmId(adapter.getRealm().getId());
        entity.setUserId(adapter.getUser().getId());
        entity.setOffline(offline);
        entity.setLastSessionRefresh(model.getLastSessionRefresh());
        entity.setData(model.getData());
        this.em.persist((Object)entity);
        this.em.flush();
    }

    public void createClientSession(ClientSessionModel clientSession, boolean offline) {
        PersistentClientSessionAdapter adapter = new PersistentClientSessionAdapter(clientSession);
        PersistentClientSessionModel model = adapter.getUpdatedModel();
        PersistentClientSessionEntity entity = new PersistentClientSessionEntity();
        entity.setClientSessionId(clientSession.getId());
        entity.setClientId(clientSession.getClient().getId());
        entity.setTimestamp(clientSession.getTimestamp());
        entity.setOffline(offline);
        entity.setUserSessionId(clientSession.getUserSession().getId());
        entity.setData(model.getData());
        this.em.persist((Object)entity);
        this.em.flush();
    }

    public void updateUserSession(UserSessionModel userSession, boolean offline) {
        PersistentUserSessionAdapter adapter = userSession instanceof PersistentUserSessionAdapter ? (PersistentUserSessionAdapter)userSession : new PersistentUserSessionAdapter(userSession);
        PersistentUserSessionModel model = adapter.getUpdatedModel();
        PersistentUserSessionEntity entity = (PersistentUserSessionEntity)this.em.find(PersistentUserSessionEntity.class, (Object)new PersistentUserSessionEntity.Key(userSession.getId(), offline));
        if (entity == null) {
            throw new ModelException("UserSession with ID " + userSession.getId() + ", offline: " + offline + " not found");
        }
        entity.setLastSessionRefresh(model.getLastSessionRefresh());
        entity.setData(model.getData());
    }

    public void removeUserSession(String userSessionId, boolean offline) {
        this.em.createNamedQuery("deleteClientSessionsByUserSession").setParameter("userSessionId", (Object)userSessionId).setParameter("offline", (Object)offline).executeUpdate();
        PersistentUserSessionEntity sessionEntity = (PersistentUserSessionEntity)this.em.find(PersistentUserSessionEntity.class, (Object)new PersistentUserSessionEntity.Key(userSessionId, offline));
        if (sessionEntity != null) {
            this.em.remove((Object)sessionEntity);
            this.em.flush();
        }
    }

    public void removeClientSession(String clientSessionId, boolean offline) {
        PersistentClientSessionEntity sessionEntity = (PersistentClientSessionEntity)this.em.find(PersistentClientSessionEntity.class, (Object)new PersistentClientSessionEntity.Key(clientSessionId, offline));
        if (sessionEntity != null) {
            PersistentUserSessionEntity userSessionEntity;
            this.em.remove((Object)sessionEntity);
            List<PersistentClientSessionEntity> clientSessions = this.getClientSessionsByUserSession(sessionEntity.getUserSessionId(), offline);
            if (clientSessions.size() == 0 && (userSessionEntity = (PersistentUserSessionEntity)this.em.find(PersistentUserSessionEntity.class, (Object)new PersistentUserSessionEntity.Key(sessionEntity.getUserSessionId(), offline))) != null) {
                this.em.remove((Object)userSessionEntity);
            }
            this.em.flush();
        }
    }

    private List<PersistentClientSessionEntity> getClientSessionsByUserSession(String userSessionId, boolean offline) {
        TypedQuery query = this.em.createNamedQuery("findClientSessionsByUserSession", PersistentClientSessionEntity.class);
        query.setParameter("userSessionId", (Object)userSessionId);
        query.setParameter("offline", (Object)offline);
        return query.getResultList();
    }

    public void onRealmRemoved(RealmModel realm) {
        int num = this.em.createNamedQuery("deleteClientSessionsByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
        num = this.em.createNamedQuery("deleteUserSessionsByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
    }

    public void onClientRemoved(RealmModel realm, ClientModel client) {
        int num = this.em.createNamedQuery("deleteClientSessionsByClient").setParameter("clientId", (Object)client.getId()).executeUpdate();
        num = this.em.createNamedQuery("deleteDetachedUserSessions").executeUpdate();
    }

    public void onUserRemoved(RealmModel realm, UserModel user) {
        int num = this.em.createNamedQuery("deleteClientSessionsByUser").setParameter("userId", (Object)user.getId()).executeUpdate();
        num = this.em.createNamedQuery("deleteUserSessionsByUser").setParameter("userId", (Object)user.getId()).executeUpdate();
    }

    public void clearDetachedUserSessions() {
        int num = this.em.createNamedQuery("deleteDetachedClientSessions").executeUpdate();
        num = this.em.createNamedQuery("deleteDetachedUserSessions").executeUpdate();
    }

    public void updateAllTimestamps(int time) {
        int num = this.em.createNamedQuery("updateClientSessionsTimestamps").setParameter("timestamp", (Object)time).executeUpdate();
        num = this.em.createNamedQuery("updateUserSessionsTimestamps").setParameter("lastSessionRefresh", (Object)time).executeUpdate();
    }

    public List<UserSessionModel> loadUserSessions(int firstResult, int maxResults, boolean offline) {
        TypedQuery query = this.em.createNamedQuery("findUserSessions", PersistentUserSessionEntity.class);
        query.setParameter("offline", (Object)offline);
        if (firstResult != -1) {
            query.setFirstResult(firstResult);
        }
        if (maxResults != -1) {
            query.setMaxResults(maxResults);
        }
        List results = query.getResultList();
        ArrayList<UserSessionModel> result = new ArrayList<UserSessionModel>();
        ArrayList<String> userSessionIds = new ArrayList<String>();
        for (PersistentUserSessionEntity entity : results) {
            result.add((UserSessionModel)this.toAdapter(entity));
            userSessionIds.add(entity.getUserSessionId());
        }
        TypedQuery query2 = this.em.createNamedQuery("findClientSessionsByUserSessions", PersistentClientSessionEntity.class);
        query2.setParameter("userSessionIds", userSessionIds);
        query2.setParameter("offline", (Object)offline);
        List clientSessions = query2.getResultList();
        int j = 0;
        for (UserSessionModel ss : result) {
            PersistentUserSessionAdapter userSession = (PersistentUserSessionAdapter)ss;
            List currentClientSessions = userSession.getClientSessions();
            boolean next = true;
            while (next && j < clientSessions.size()) {
                PersistentClientSessionEntity clientSession = (PersistentClientSessionEntity)clientSessions.get(j);
                if (clientSession.getUserSessionId().equals(userSession.getId())) {
                    PersistentClientSessionAdapter clientSessAdapter = this.toAdapter(userSession.getRealm(), userSession, clientSession);
                    currentClientSessions.add(clientSessAdapter);
                    ++j;
                    continue;
                }
                next = false;
            }
        }
        return result;
    }

    private PersistentUserSessionAdapter toAdapter(PersistentUserSessionEntity entity) {
        RealmModel realm = this.session.realms().getRealm(entity.getRealmId());
        UserModel user = this.session.users().getUserById(entity.getUserId(), realm);
        PersistentUserSessionModel model = new PersistentUserSessionModel();
        model.setUserSessionId(entity.getUserSessionId());
        model.setLastSessionRefresh(entity.getLastSessionRefresh());
        model.setData(entity.getData());
        LinkedList clientSessions = new LinkedList();
        return new PersistentUserSessionAdapter(model, realm, user, clientSessions);
    }

    private PersistentClientSessionAdapter toAdapter(RealmModel realm, PersistentUserSessionAdapter userSession, PersistentClientSessionEntity entity) {
        ClientModel client = realm.getClientById(entity.getClientId());
        PersistentClientSessionModel model = new PersistentClientSessionModel();
        model.setClientSessionId(entity.getClientSessionId());
        model.setClientId(entity.getClientId());
        model.setUserSessionId(userSession.getId());
        model.setUserId(userSession.getUser().getId());
        model.setTimestamp(entity.getTimestamp());
        model.setData(entity.getData());
        return new PersistentClientSessionAdapter(model, realm, client, (UserSessionModel)userSession);
    }

    public int getUserSessionsCount(boolean offline) {
        Query query = this.em.createNamedQuery("findUserSessionsCount");
        query.setParameter("offline", (Object)offline);
        Number n = (Number)query.getSingleResult();
        return n.intValue();
    }

    public void close() {
    }
}

