/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.transport;

import java.io.IOException;
import java.util.List;
import javax.management.ObjectName;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.ws.handler.Handler;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.frontend.ServerFactoryBean;
import org.apache.cxf.jaxws.support.JaxWsEndpointImpl;
import org.jboss.ws.common.ObjectNameFactory;
import org.jboss.ws.common.configuration.ConfigDelegateHandler;
import org.jboss.ws.common.injection.InjectionHelper;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.classloading.ClassLoaderProvider;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.Reference;
import org.jboss.wsf.spi.invocation.EndpointAssociation;
import org.jboss.wsf.spi.invocation.RequestHandler;
import org.jboss.wsf.spi.management.EndpointRegistry;
import org.jboss.wsf.spi.management.EndpointRegistryFactory;
import org.jboss.wsf.stack.cxf.Messages;

public class ServletHelper {
    public static Endpoint initEndpoint(ServletConfig servletConfig, String servletName) {
        ClassLoader cl = ClassLoaderProvider.getDefaultProvider().getServerIntegrationClassLoader();
        EndpointRegistry epRegistry = ((EndpointRegistryFactory)SPIProvider.getInstance().getSPI(EndpointRegistryFactory.class, cl)).getEndpointRegistry();
        ServletContext context = servletConfig.getServletContext();
        String contextPath = context.getContextPath();
        context.setAttribute(ServletConfig.class.getName(), (Object)servletConfig);
        return ServletHelper.initServiceEndpoint(epRegistry, contextPath, servletName);
    }

    private static Endpoint initServiceEndpoint(EndpointRegistry epRegistry, String contextPath, String servletName) {
        ObjectName oname;
        Endpoint endpoint;
        if (contextPath.startsWith("/")) {
            contextPath = contextPath.substring(1);
        }
        if ((endpoint = epRegistry.getEndpoint(oname = ObjectNameFactory.create((String)("jboss.ws:context=" + contextPath + "," + "endpoint" + "=" + servletName)))) == null) {
            throw Messages.MESSAGES.cannotObtainEndpoint(oname);
        }
        ServletHelper.injectServiceAndHandlerResources(endpoint);
        return endpoint;
    }

    private static void injectServiceAndHandlerResources(Endpoint endpoint) {
        List chain;
        ServerFactoryBean factory = (ServerFactoryBean)endpoint.getAttachment(ServerFactoryBean.class);
        if (factory != null && (chain = ((JaxWsEndpointImpl)factory.getServer().getEndpoint()).getJaxwsBinding().getHandlerChain()) != null) {
            for (Handler handler : chain) {
                Reference handlerReference;
                if (handler instanceof ConfigDelegateHandler) {
                    handler = ((ConfigDelegateHandler)handler).getDelegate();
                }
                if ((handlerReference = endpoint.getInstanceProvider().getInstance(handler.getClass().getName())).isInitialized()) continue;
                Object handlerInstance = handlerReference.getValue();
                InjectionHelper.callPostConstructMethod((Object)handlerInstance);
                handlerReference.setInitialized();
            }
        }
    }

    public static void callPreDestroy(Endpoint endpoint) {
    }

    public static void callRequestHandler(HttpServletRequest req, HttpServletResponse res, ServletContext ctx, Bus bus, Endpoint endpoint) throws ServletException {
        try {
            BusFactory.setThreadDefaultBus((Bus)bus);
            EndpointAssociation.setEndpoint((Endpoint)endpoint);
            RequestHandler requestHandler = endpoint.getRequestHandler();
            requestHandler.handleHttpRequest(endpoint, req, res, ctx);
        }
        catch (IOException ioe) {
            throw new ServletException((Throwable)ioe);
        }
        finally {
            EndpointAssociation.removeEndpoint();
            BusFactory.setThreadDefaultBus(null);
        }
    }
}

