/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene;

import java.util.Properties;
import org.hibernate.search.backend.BackendFactory;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.impl.CommitPolicy;
import org.hibernate.search.backend.impl.lucene.AbstractWorkspaceImpl;
import org.hibernate.search.backend.impl.lucene.PerChangeSetCommitPolicy;
import org.hibernate.search.backend.impl.lucene.ScheduledCommitPolicy;
import org.hibernate.search.indexes.impl.PropertiesParseHelper;
import org.hibernate.search.indexes.spi.DirectoryBasedIndexManager;
import org.hibernate.search.spi.WorkerBuildContext;

public class ExclusiveIndexWorkspaceImpl
extends AbstractWorkspaceImpl {
    private final CommitPolicy commitPolicy;

    public ExclusiveIndexWorkspaceImpl(DirectoryBasedIndexManager indexManager, WorkerBuildContext context, Properties cfg) {
        super(indexManager, context, cfg);
        boolean async;
        boolean bl = async = !BackendFactory.isConfiguredAsSync(cfg);
        if (async) {
            int commitInterval = PropertiesParseHelper.extractFlushInterval(indexManager.getIndexName(), cfg);
            this.commitPolicy = new ScheduledCommitPolicy(this.writerHolder, indexManager.getIndexName(), commitInterval);
        } else {
            this.commitPolicy = new PerChangeSetCommitPolicy(this.writerHolder);
        }
    }

    @Override
    public void notifyWorkApplied(LuceneWork work) {
        this.incrementModificationCounter();
    }

    @Override
    public CommitPolicy getCommitPolicy() {
        return this.commitPolicy;
    }
}

