/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import java.io.InputStream;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;
import org.keycloak.Config;
import org.keycloak.common.Version;

@Path(value="/js")
public class JsResource {
    @GET
    @Path(value="/keycloak.js")
    @Produces(value={"text/javascript"})
    public Response getJs() {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("keycloak.js");
        if (inputStream != null) {
            CacheControl cacheControl = new CacheControl();
            cacheControl.setNoTransform(false);
            cacheControl.setMaxAge(Config.scope((String[])new String[]{"theme"}).getInt("staticMaxAge", Integer.valueOf(-1)).intValue());
            return Response.ok((Object)inputStream).type("text/javascript").cacheControl(cacheControl).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @GET
    @Path(value="/{version}/keycloak.js")
    @Produces(value={"text/javascript"})
    public Response getJsWithVersion(@PathParam(value="version") String version) {
        if (!version.equals(Version.RESOURCES_VERSION)) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return this.getJs();
    }

    @GET
    @Path(value="/keycloak.min.js")
    @Produces(value={"text/javascript"})
    public Response getMinJs() {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("keycloak.min.js");
        if (inputStream != null) {
            CacheControl cacheControl = new CacheControl();
            cacheControl.setNoTransform(false);
            cacheControl.setMaxAge(Config.scope((String[])new String[]{"theme"}).getInt("staticMaxAge", Integer.valueOf(-1)).intValue());
            return Response.ok((Object)inputStream).type("text/javascript").cacheControl(cacheControl).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @GET
    @Path(value="/{version}/keycloak.min.js")
    @Produces(value={"text/javascript"})
    public Response getMinJsWithVersion(@PathParam(value="version") String version) {
        if (!version.equals(Version.RESOURCES_VERSION)) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return this.getMinJs();
    }
}

