/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.gui.component;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import javax.swing.table.AbstractTableModel;
import org.jboss.as.cli.gui.CliGuiContext;
import org.jboss.dmr.ModelNode;

public class StandaloneDeploymentTableModel
extends AbstractTableModel {
    private ButtonGroup deploymentsButtonGroup = new ButtonGroup();
    protected String[] colNames = new String[]{"Name", "Runtime Name", "Enabled"};
    protected List<Object[]> data = new ArrayList<Object[]>();

    public StandaloneDeploymentTableModel(CliGuiContext cliGuiCtx) {
        this.setDeployments(cliGuiCtx);
    }

    private void setDeployments(CliGuiContext cliGuiCtx) {
        ModelNode deploymentsQuery = null;
        String queryString = "/deployment=*/:read-resource";
        try {
            deploymentsQuery = cliGuiCtx.getExecutor().doCommand(queryString);
            if (deploymentsQuery.get("outcome").asString().equals("failed")) {
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (ModelNode node : deploymentsQuery.get("result").asList()) {
            ModelNode deploymentNode = node.get("result");
            Object[] deployment = new Object[3];
            this.data.add(deployment);
            String name = deploymentNode.get("name").asString();
            JRadioButton radio = new JRadioButton(name);
            deployment[0] = radio;
            this.deploymentsButtonGroup.add(radio);
            deployment[1] = deploymentNode.get("runtime-name").asString();
            ModelNode enabled = deploymentNode.get("enabled");
            if (!enabled.isDefined()) continue;
            deployment[2] = deploymentNode.get("enabled").asString();
        }
        if (this.data.size() > 0) {
            JRadioButton first = (JRadioButton)this.data.get(0)[0];
            first.setSelected(true);
        }
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.data.get(rowIndex)[columnIndex];
    }

    @Override
    public String getColumnName(int column) {
        return this.colNames[column];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return JRadioButton.class;
        }
        return String.class;
    }

    public boolean hasDeployments() {
        return !this.data.isEmpty();
    }

    public String getSelectedDeployment() {
        if (!this.hasDeployments()) {
            return null;
        }
        Enumeration<AbstractButton> e = this.deploymentsButtonGroup.getElements();
        while (e.hasMoreElements()) {
            JRadioButton radio = (JRadioButton)e.nextElement();
            if (radio.getModel() != this.deploymentsButtonGroup.getSelection()) continue;
            return radio.getText();
        }
        throw new IllegalStateException("No deployment selected");
    }
}

