/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.file;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.jboss.util.file.ArchiveBrowser;

public class JarStreamBrowser
implements Iterator {
    JarInputStream jar;
    JarEntry next;
    ArchiveBrowser.Filter filter;

    public JarStreamBrowser(File file, ArchiveBrowser.Filter filter) throws IOException {
        this(new FileInputStream(file), filter);
    }

    public JarStreamBrowser(InputStream is, ArchiveBrowser.Filter filter) throws IOException {
        this.filter = filter;
        this.jar = new JarInputStream(is);
        this.setNext();
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    private void setNext() {
        try {
            if (this.next != null) {
                this.jar.closeEntry();
            }
            this.next = null;
            do {
                this.next = this.jar.getNextJarEntry();
            } while (this.next != null && (this.next.isDirectory() || !this.filter.accept(this.next.getName())));
            if (this.next == null) {
                this.jar.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("failed to browse jar", e);
        }
    }

    public Object next() {
        int size = (int)this.next.getSize();
        byte[] buf = new byte[size];
        int current = 0;
        try {
            for (int count = 0; (current = this.jar.read(buf, count, size - count)) != -1 && count < size; count += current) {
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(buf);
            this.setNext();
            return bais;
        }
        catch (IOException e) {
            try {
                this.jar.close();
            }
            catch (IOException ignored) {
                // empty catch block
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public void remove() {
        throw new RuntimeException("Illegal operation on ArchiveBrowser");
    }
}

