/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.security;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.jca.core.CoreLogger;
import org.jboss.jca.core.security.SimplePrincipal;
import org.jboss.jca.core.spi.security.Callback;
import org.jboss.logging.Logger;

public class CallbackImpl
implements Callback {
    private static final long serialVersionUID = 1L;
    private static CoreLogger log = (CoreLogger)Logger.getMessageLogger(CoreLogger.class, (String)CallbackImpl.class.getName());
    private static boolean trace = log.isTraceEnabled();
    private boolean mappingRequired;
    private String domain;
    private Principal defaultPrincipal;
    private String[] defaultGroups;
    private Map<String, String> principals;
    private Map<String, String> groups;

    CallbackImpl() {
    }

    public CallbackImpl(boolean mappingRequired, String domain, String defaultPrincipal, String[] defaultGroups, Map<String, String> principals, Map<String, String> groups) {
        this.mappingRequired = mappingRequired;
        this.domain = domain;
        this.defaultPrincipal = defaultPrincipal != null ? new SimplePrincipal(defaultPrincipal) : null;
        this.defaultGroups = defaultGroups != null ? Arrays.copyOf(defaultGroups, defaultGroups.length) : null;
        this.principals = principals != null ? Collections.synchronizedMap(new HashMap<String, String>(principals)) : null;
        this.groups = groups != null ? Collections.synchronizedMap(new HashMap<String, String>(groups)) : null;
    }

    public boolean isMappingRequired() {
        return this.mappingRequired;
    }

    public String getDomain() {
        return this.domain;
    }

    public Principal getDefaultPrincipal() {
        return this.defaultPrincipal;
    }

    public String[] getDefaultGroups() {
        if (this.defaultGroups == null) {
            return null;
        }
        return Arrays.copyOf(this.defaultGroups, this.defaultGroups.length);
    }

    public Principal mapPrincipal(String name) {
        String mapping;
        if (this.principals != null && (mapping = this.principals.get(name)) != null) {
            return new SimplePrincipal(mapping);
        }
        return null;
    }

    public String mapGroup(String name) {
        if (this.groups == null) {
            return null;
        }
        return this.groups.get(name);
    }

    public void start() throws Throwable {
    }

    public void stop() throws Throwable {
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeBoolean(this.mappingRequired);
        out.writeUTF(this.domain);
        if (this.defaultPrincipal != null) {
            out.writeBoolean(true);
            out.writeUTF(this.defaultPrincipal.getName());
        } else {
            out.writeBoolean(false);
        }
        out.writeObject(this.defaultGroups);
        if (this.principals != null && this.principals.size() > 0) {
            out.writeInt(this.principals.size());
            for (Map.Entry<String, String> entry : this.principals.entrySet()) {
                out.writeUTF(entry.getKey());
                out.writeUTF(entry.getValue());
            }
        } else {
            out.writeInt(0);
        }
        if (this.groups != null && this.groups.size() > 0) {
            out.writeInt(this.groups.size());
            for (Map.Entry<String, String> entry : this.groups.entrySet()) {
                out.writeUTF(entry.getKey());
                out.writeUTF(entry.getValue());
            }
        } else {
            out.writeInt(0);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        String to;
        String from;
        int j;
        this.mappingRequired = in.readBoolean();
        this.domain = in.readUTF();
        if (in.readBoolean()) {
            this.defaultPrincipal = new SimplePrincipal(in.readUTF());
        }
        this.defaultGroups = (String[])in.readObject();
        int i = in.readInt();
        if (i > 0) {
            for (j = 1; j <= i; ++j) {
                from = in.readUTF();
                to = in.readUTF();
                this.principals.put(from, to);
            }
        }
        if ((i = in.readInt()) > 0) {
            for (j = 1; j <= i; ++j) {
                from = in.readUTF();
                to = in.readUTF();
                this.groups.put(from, to);
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CallbackImpl@").append(Integer.toHexString(System.identityHashCode(this)));
        sb.append("[mappingRequired=").append(this.mappingRequired);
        sb.append(" domain=").append(this.domain);
        sb.append(" defaultPrincipal=").append(this.defaultPrincipal);
        sb.append(" defaultGroups=").append(this.defaultGroups == null ? "null" : Arrays.toString(this.defaultGroups));
        sb.append(" principals=").append(this.principals);
        sb.append(" groups=").append(this.groups);
        sb.append("]");
        return sb.toString();
    }
}

