/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import org.jgroups.Address;

public class Rsp<T> {
    protected boolean received;
    protected boolean suspected;
    protected boolean unreachable;
    protected final Address sender;
    protected T retval;
    protected Throwable exception;

    public Rsp(Address sender) {
        this.sender = sender;
    }

    public Rsp(Address sender, T retval) {
        this.sender = sender;
        this.setValue(retval);
    }

    public Rsp(Address sender, Throwable t) {
        this.sender = sender;
        this.setException(t);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Rsp)) {
            return false;
        }
        Rsp other = (Rsp)obj;
        if (this.sender != null) {
            return this.sender.equals(other.sender);
        }
        return other.sender == null;
    }

    public int hashCode() {
        return this.sender != null ? this.sender.hashCode() : 0;
    }

    public T getValue() {
        return this.retval;
    }

    public void setValue(T val) {
        this.retval = val;
        this.setReceived();
        this.exception = null;
    }

    public boolean hasException() {
        return this.exception != null;
    }

    public Throwable getException() {
        return this.exception;
    }

    public void setException(Throwable t) {
        if (t != null) {
            this.exception = t;
            this.setReceived();
            this.retval = null;
        }
    }

    public Address getSender() {
        return this.sender;
    }

    public boolean wasReceived() {
        return this.received;
    }

    public void setReceived() {
        this.received = true;
    }

    public boolean wasSuspected() {
        return this.suspected;
    }

    public boolean setSuspected() {
        boolean changed = !this.suspected;
        this.suspected = true;
        return changed;
    }

    public boolean wasUnreachable() {
        return this.unreachable;
    }

    public boolean setUnreachable() {
        boolean changed = !this.unreachable;
        this.unreachable = true;
        return changed;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("sender=").append(this.sender);
        if (this.retval != null) {
            sb.append(", retval=").append(this.retval);
        }
        if (this.exception != null) {
            sb.append(", exception=").append(this.exception);
        }
        sb.append(", received=").append(this.received).append(", suspected=").append(this.suspected);
        if (this.unreachable) {
            sb.append(" (unreachable)");
        }
        return sb.toString();
    }
}

