/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http;

import java.io.InputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.cxf.common.util.ReflectionUtil;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transport.http.ReferencingAuthenticator;

public class CXFAuthenticator
extends Authenticator {
    static CXFAuthenticator instance;

    public static synchronized void addAuthenticator() {
        if (instance == null) {
            instance = new CXFAuthenticator();
            Authenticator wrapped = null;
            for (Field f : Authenticator.class.getDeclaredFields()) {
                if (!f.getType().equals(Authenticator.class)) continue;
                ReflectionUtil.setAccessible((AccessibleObject)f);
                try {
                    wrapped = (Authenticator)f.get(null);
                    if (wrapped != null && wrapped.getClass().getName().equals(ReferencingAuthenticator.class.getName())) {
                        Method m = wrapped.getClass().getMethod("check", new Class[0]);
                        m.setAccessible(true);
                        m.invoke((Object)wrapped, new Object[0]);
                    }
                    wrapped = (Authenticator)f.get(null);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            try {
                ClassLoader loader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                    @Override
                    public ClassLoader run() {
                        return new URLClassLoader(new URL[0], ClassLoader.getSystemClassLoader());
                    }
                }, null);
                Method m = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
                InputStream ins = ReferencingAuthenticator.class.getResourceAsStream("ReferencingAuthenticator.class");
                byte[] b = IOUtils.readBytesFromStream((InputStream)ins);
                ((Method)ReflectionUtil.setAccessible((AccessibleObject)m)).invoke((Object)loader, ReferencingAuthenticator.class.getName(), b, 0, b.length);
                Class<?> cls = loader.loadClass(ReferencingAuthenticator.class.getName());
                final Authenticator auth = (Authenticator)cls.getConstructor(Authenticator.class, Authenticator.class).newInstance(instance, wrapped);
                if (System.getSecurityManager() == null) {
                    Authenticator.setDefault(auth);
                } else {
                    AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                        @Override
                        public Boolean run() {
                            Authenticator.setDefault(auth);
                            return true;
                        }
                    });
                }
                try {
                    Field f = loader.getClass().getDeclaredField("acc");
                    ((Field)ReflectionUtil.setAccessible((AccessibleObject)f)).set(loader, null);
                }
                catch (Throwable t) {}
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    protected PasswordAuthentication getPasswordAuthentication() {
        Exchange exchange;
        Conduit conduit;
        PasswordAuthentication auth = null;
        Message m = PhaseInterceptorChain.getCurrentMessage();
        if (m != null && (conduit = (exchange = m.getExchange()).getConduit(m)) instanceof HTTPConduit) {
            HTTPConduit httpConduit = (HTTPConduit)conduit;
            if (this.getRequestorType() == Authenticator.RequestorType.PROXY && httpConduit.getProxyAuthorization() != null) {
                String un = httpConduit.getProxyAuthorization().getUserName();
                String pwd = httpConduit.getProxyAuthorization().getPassword();
                if (un != null && pwd != null) {
                    auth = new PasswordAuthentication(un, pwd.toCharArray());
                }
            } else if (this.getRequestorType() == Authenticator.RequestorType.SERVER && httpConduit.getAuthorization() != null) {
                if ("basic".equals(this.getRequestingScheme()) || "digest".equals(this.getRequestingScheme())) {
                    return null;
                }
                String un = httpConduit.getAuthorization().getUserName();
                String pwd = httpConduit.getAuthorization().getPassword();
                if (un != null && pwd != null) {
                    auth = new PasswordAuthentication(un, pwd.toCharArray());
                }
            }
        }
        return auth;
    }
}

