/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.canonical;

import nu.xom.MalformedURIException;

class URIJoiner {
    URIJoiner() {
    }

    static String absolutize(String string, String string2) {
        if ("".equals(string) || string == null) {
            return string2;
        }
        ParsedURI parsedURI = new ParsedURI(string);
        if (parsedURI.path.endsWith("/..")) {
            parsedURI.path = parsedURI.path + '/';
        }
        ParsedURI parsedURI2 = new ParsedURI(string2);
        ParsedURI parsedURI3 = new ParsedURI();
        if (parsedURI2.scheme != null) {
            parsedURI3.scheme = parsedURI2.scheme;
            parsedURI3.authority = parsedURI2.authority;
            parsedURI3.query = parsedURI2.query;
            parsedURI3.path = URIJoiner.removeDotSegments(parsedURI2.path);
        } else {
            if (parsedURI2.authority != null) {
                parsedURI3.authority = parsedURI2.authority;
                parsedURI3.query = parsedURI2.query;
                parsedURI3.path = URIJoiner.removeDotSegments(parsedURI2.path);
            } else {
                if ("".equals(parsedURI2.path)) {
                    parsedURI3.path = parsedURI.path;
                    parsedURI3.query = parsedURI2.query != null ? parsedURI2.query : parsedURI.query;
                } else {
                    if (parsedURI2.path.startsWith("/")) {
                        parsedURI3.path = URIJoiner.removeDotSegments(parsedURI2.path);
                    } else {
                        parsedURI3.path = URIJoiner.merge(parsedURI, parsedURI2.path);
                        parsedURI3.path = URIJoiner.removeDotSegments(parsedURI3.path);
                    }
                    parsedURI3.query = parsedURI2.query;
                }
                parsedURI3.authority = parsedURI.authority;
            }
            parsedURI3.scheme = parsedURI.scheme;
        }
        parsedURI3.fragment = parsedURI2.fragment;
        return parsedURI3.toString();
    }

    static String merge(ParsedURI parsedURI, String string) {
        if (parsedURI.authority != null && "".equals(parsedURI.path) && !"".equals(parsedURI.authority)) {
            return "/" + string;
        }
        int n = parsedURI.path.lastIndexOf(47);
        if (n == -1) {
            return string;
        }
        String string2 = parsedURI.path.substring(0, n + 1);
        return string2 + string;
    }

    static String removeDotSegments(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        while (string.length() > 0) {
            int n;
            if (string.startsWith("/./")) {
                string = '/' + string.substring(3);
                continue;
            }
            if (string.equals("/.")) {
                string = "/";
                continue;
            }
            if (string.equals("/..")) {
                string = "/";
                n = stringBuffer.toString().lastIndexOf(47);
                if (n == -1) continue;
                stringBuffer.setLength(n);
                continue;
            }
            if (string.equals(".")) {
                string = "";
                continue;
            }
            if (string.startsWith("./")) {
                string = string.substring(2);
                continue;
            }
            n = string.indexOf(47);
            if (n == 0) {
                n = string.indexOf(47, 1);
            }
            if (n == -1) {
                stringBuffer.append(string);
                string = "";
                continue;
            }
            stringBuffer.append(string.substring(0, n));
            string = string.substring(n);
        }
        return stringBuffer.toString();
    }

    static class ParsedURI {
        String scheme;
        String schemeSpecificPart;
        String query;
        String fragment;
        String authority;
        String path = "";

        ParsedURI(String string) {
            int n = string.indexOf(58);
            int n2 = string.lastIndexOf(35);
            int n3 = n2 == -1 ? string.indexOf(63) : string.substring(0, n2).indexOf(63);
            if (n != -1) {
                this.scheme = string.substring(0, n);
            }
            if (n3 == -1 && n2 == -1) {
                this.schemeSpecificPart = string.substring(n + 1);
            } else if (n3 != -1) {
                if (n3 < n) {
                    MalformedURIException malformedURIException = new MalformedURIException("Unparseable URI");
                    malformedURIException.setData(string);
                    throw malformedURIException;
                }
                this.schemeSpecificPart = string.substring(n + 1, n3);
            } else {
                if (n2 < n) {
                    MalformedURIException malformedURIException = new MalformedURIException("Unparseable URI");
                    malformedURIException.setData(string);
                    throw malformedURIException;
                }
                this.schemeSpecificPart = string.substring(n + 1, n2);
            }
            if (n2 != -1) {
                this.fragment = string.substring(n2 + 1);
            }
            if (n3 != -1) {
                this.query = n2 == -1 ? string.substring(n3 + 1) : string.substring(n3 + 1, n2);
            }
            if (this.schemeSpecificPart.startsWith("//")) {
                int n4 = 2;
                int n5 = this.schemeSpecificPart.indexOf(47, n4);
                if (n5 == -1) {
                    this.authority = this.schemeSpecificPart.substring(2);
                    this.path = "";
                } else {
                    this.authority = this.schemeSpecificPart.substring(n4, n5);
                    this.path = this.schemeSpecificPart.substring(n5);
                }
            } else {
                this.path = this.schemeSpecificPart;
            }
        }

        ParsedURI() {
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(30);
            if (this.scheme != null) {
                stringBuffer.append(this.scheme);
                stringBuffer.append(':');
            }
            if (this.schemeSpecificPart != null) {
                stringBuffer.append(this.schemeSpecificPart);
            } else {
                if (this.scheme != null) {
                    stringBuffer.append("//");
                }
                if (this.authority != null) {
                    stringBuffer.append(this.authority);
                }
                stringBuffer.append(this.path);
            }
            if (this.query != null) {
                stringBuffer.append('?');
                stringBuffer.append(this.query);
            }
            if (this.fragment != null) {
                stringBuffer.append('#');
                stringBuffer.append(this.fragment);
            }
            return stringBuffer.toString();
        }
    }
}

