/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.webservices.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;

public class ClassLoaderHelper {
    public static Class forName(Class caller, String className) throws ClassNotFoundException {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader != null) {
            try {
                return contextClassLoader.loadClass(className);
            }
            catch (ClassNotFoundException cnfe) {
                // empty catch block
            }
        }
        ClassLoader callerClassLoader = caller.getClassLoader();
        try {
            return callerClassLoader.loadClass(className);
        }
        catch (ClassNotFoundException cnfe) {
            return ClassLoader.getSystemClassLoader().loadClass(className);
        }
    }

    public static String getResourceAsString(Class caller, String resource) throws IOException {
        int count;
        InputStream is = ClassLoaderHelper.getResourceAsStream(caller, resource);
        if (is == null) {
            return null;
        }
        InputStreamReader reader = new InputStreamReader(is);
        StringBuffer stringBuffer = new StringBuffer();
        char[] buffer = new char[1024];
        while ((count = reader.read(buffer)) != -1) {
            stringBuffer.append(buffer, 0, count);
        }
        return stringBuffer.toString();
    }

    public static InputStream getResourceAsStream(Class caller, String resource) {
        String callerName;
        int lastSeparator;
        if (resource == null || resource.length() == 0) {
            return null;
        }
        String absoluteResource = resource.charAt(0) == '/' ? resource : ((lastSeparator = (callerName = caller.getName()).lastIndexOf(46)) == -1 ? '/' + resource : '/' + callerName.substring(0, lastSeparator + 1).replace('.', '/') + resource);
        URL url = ClassLoaderHelper.getResourceAsURL(caller, absoluteResource);
        if (url != null) {
            try {
                return url.openStream();
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        return null;
    }

    public static URL getResourceAsURL(Class caller, String resource) {
        URL contextURL;
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader != null && (contextURL = contextClassLoader.getResource(resource)) != null) {
            return contextURL;
        }
        URL callerURL = caller.getResource(resource);
        if (callerURL != null) {
            return callerURL;
        }
        return ClassLoader.getSystemResource(resource);
    }
}

