/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.mongo.keycloak.entities;

import com.mongodb.DBObject;
import com.mongodb.QueryBuilder;
import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.connections.mongo.api.MongoCollection;
import org.keycloak.connections.mongo.api.MongoField;
import org.keycloak.connections.mongo.api.MongoIdentifiableEntity;
import org.keycloak.connections.mongo.api.MongoStore;
import org.keycloak.connections.mongo.api.context.MongoStoreInvocationContext;
import org.keycloak.models.entities.RoleEntity;
import org.keycloak.models.mongo.keycloak.entities.MongoClientEntity;
import org.keycloak.models.mongo.keycloak.entities.MongoGroupEntity;
import org.keycloak.models.mongo.keycloak.entities.MongoRealmEntity;

@MongoCollection(collectionName="roles")
public class MongoRoleEntity
extends RoleEntity
implements MongoIdentifiableEntity {
    private static final Logger logger = Logger.getLogger(MongoRoleEntity.class);

    @MongoField
    public String getNameIndex() {
        String realmId = this.getRealmId();
        String clientId = this.getClientId();
        String name = this.getName();
        if (realmId != null) {
            return realmId + "//" + name;
        }
        return clientId + "//" + name;
    }

    public void setNameIndex(String ignored) {
    }

    public void afterRemove(MongoStoreInvocationContext invContext) {
        MongoClientEntity appEntity;
        MongoRealmEntity realmEntity;
        MongoStore mongoStore = invContext.getMongoStore();
        DBObject query = new QueryBuilder().and("roleIds").is((Object)this.getId()).get();
        List groups = mongoStore.loadEntities(MongoGroupEntity.class, query, invContext);
        for (MongoGroupEntity group : groups) {
            mongoStore.pullItemFromList((MongoIdentifiableEntity)group, "roleIds", (Object)this.getId(), invContext);
        }
        query = new QueryBuilder().and("scopeIds").is((Object)this.getId()).get();
        List clients = mongoStore.loadEntities(MongoClientEntity.class, query, invContext);
        for (MongoClientEntity client : clients) {
            mongoStore.pullItemFromList((MongoIdentifiableEntity)client, "scopeIds", (Object)this.getId(), invContext);
        }
        if (this.getRealmId() != null && (realmEntity = (MongoRealmEntity)mongoStore.loadEntity(MongoRealmEntity.class, this.getRealmId(), invContext)) != null) {
            mongoStore.pullItemFromList((MongoIdentifiableEntity)realmEntity, "defaultRoles", (Object)this.getName(), invContext);
        }
        if (this.getClientId() != null && (appEntity = (MongoClientEntity)mongoStore.loadEntity(MongoClientEntity.class, this.getClientId(), invContext)) != null) {
            mongoStore.pullItemFromList((MongoIdentifiableEntity)appEntity, "defaultRoles", (Object)this.getName(), invContext);
        }
        query = new QueryBuilder().and("compositeRoleIds").is((Object)this.getId()).get();
        List parentRoles = mongoStore.loadEntities(MongoRoleEntity.class, query, invContext);
        for (MongoRoleEntity role : parentRoles) {
            mongoStore.pullItemFromList((MongoIdentifiableEntity)role, "compositeRoleIds", (Object)this.getId(), invContext);
        }
    }
}

