/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.proton;

import io.netty.channel.ChannelPipeline;
import java.util.List;
import java.util.concurrent.Executor;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.BaseInterceptor;
import org.apache.activemq.artemis.api.core.Interceptor;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.core.protocol.proton.ActiveMQProtonRemotingConnection;
import org.apache.activemq.artemis.core.protocol.proton.ProtonProtocolManagerFactory;
import org.apache.activemq.artemis.core.protocol.proton.converter.ProtonMessageConverter;
import org.apache.activemq.artemis.core.protocol.proton.plug.ActiveMQProtonConnectionCallback;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyServerConnection;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.management.Notification;
import org.apache.activemq.artemis.core.server.management.NotificationListener;
import org.apache.activemq.artemis.spi.core.protocol.ConnectionEntry;
import org.apache.activemq.artemis.spi.core.protocol.MessageConverter;
import org.apache.activemq.artemis.spi.core.protocol.ProtocolManager;
import org.apache.activemq.artemis.spi.core.protocol.ProtocolManagerFactory;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.remoting.Acceptor;
import org.apache.activemq.artemis.spi.core.remoting.Connection;
import org.apache.activemq.artemis.utils.IDGenerator;
import org.proton.plug.AMQPConnectionCallback;
import org.proton.plug.AMQPConnectionContext;
import org.proton.plug.AMQPServerConnectionContext;
import org.proton.plug.context.server.ProtonServerConnectionContextFactory;

public class ProtonProtocolManager
implements ProtocolManager<Interceptor>,
NotificationListener {
    private final ActiveMQServer server;
    private MessageConverter protonConverter;
    private final ProtonProtocolManagerFactory factory;

    public ProtonProtocolManager(ProtonProtocolManagerFactory factory, ActiveMQServer server) {
        this.factory = factory;
        this.server = server;
        this.protonConverter = new ProtonMessageConverter((IDGenerator)server.getStorageManager());
    }

    public ActiveMQServer getServer() {
        return this.server;
    }

    public MessageConverter getConverter() {
        return this.protonConverter;
    }

    public void onNotification(Notification notification) {
    }

    public ProtocolManagerFactory<Interceptor> getFactory() {
        return this.factory;
    }

    public void updateInterceptors(List<BaseInterceptor> incomingInterceptors, List<BaseInterceptor> outgoingInterceptors) {
    }

    public boolean acceptsNoHandshake() {
        return false;
    }

    public ConnectionEntry createConnectionEntry(Acceptor acceptorUsed, Connection remotingConnection) {
        ActiveMQProtonConnectionCallback connectionCallback = new ActiveMQProtonConnectionCallback(this, remotingConnection);
        long ttl = ActiveMQClient.DEFAULT_CONNECTION_TTL;
        if (this.server.getConfiguration().getConnectionTTLOverride() != -1L) {
            ttl = this.server.getConfiguration().getConnectionTTLOverride();
        }
        AMQPServerConnectionContext amqpConnection = ProtonServerConnectionContextFactory.getFactory().createConnection((AMQPConnectionCallback)connectionCallback, (int)ttl, -1, 65535);
        Executor executor = this.server.getExecutorFactory().getExecutor();
        ActiveMQProtonRemotingConnection delegate = new ActiveMQProtonRemotingConnection(this, (AMQPConnectionContext)amqpConnection, remotingConnection, executor);
        connectionCallback.setProtonConnectionDelegate(delegate);
        ConnectionEntry entry = new ConnectionEntry((RemotingConnection)delegate, executor, System.currentTimeMillis(), ttl);
        return entry;
    }

    public void removeHandler(String name) {
    }

    public void handleBuffer(RemotingConnection connection, ActiveMQBuffer buffer) {
        ActiveMQProtonRemotingConnection protonConnection = (ActiveMQProtonRemotingConnection)connection;
        protonConnection.bufferReceived(protonConnection.getID(), buffer);
    }

    public void addChannelHandlers(ChannelPipeline pipeline) {
    }

    public boolean isProtocol(byte[] array) {
        return array.length >= 4 && array[0] == 65 && array[1] == 77 && array[2] == 81 && array[3] == 80;
    }

    public void handshake(NettyServerConnection connection, ActiveMQBuffer buffer) {
    }
}

