/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.workmanager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.resource.spi.work.DistributableWork;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import org.jboss.jca.core.CoreBundle;
import org.jboss.jca.core.CoreLogger;
import org.jboss.jca.core.api.workmanager.DistributedWorkManager;
import org.jboss.jca.core.api.workmanager.DistributedWorkManagerStatistics;
import org.jboss.jca.core.api.workmanager.WorkManager;
import org.jboss.jca.core.spi.workmanager.Address;
import org.jboss.jca.core.spi.workmanager.notification.NotificationListener;
import org.jboss.jca.core.spi.workmanager.policy.Policy;
import org.jboss.jca.core.spi.workmanager.selector.Selector;
import org.jboss.jca.core.spi.workmanager.transport.Transport;
import org.jboss.jca.core.workmanager.DistributedWorkManagerStatisticsImpl;
import org.jboss.jca.core.workmanager.WorkEventListener;
import org.jboss.jca.core.workmanager.WorkManagerImpl;
import org.jboss.jca.core.workmanager.WorkManagerUtil;
import org.jboss.logging.Logger;
import org.jboss.logging.Messages;

public class DistributedWorkManagerImpl
extends WorkManagerImpl
implements DistributedWorkManager {
    private static CoreLogger log = (CoreLogger)Logger.getMessageLogger(CoreLogger.class, (String)DistributedWorkManagerImpl.class.getName());
    private static boolean trace = log.isTraceEnabled();
    private static CoreBundle bundle = (CoreBundle)Messages.getBundle(CoreBundle.class);
    private Policy policy = null;
    private Selector selector = null;
    private Transport transport = null;
    private Collection<NotificationListener> listeners = Collections.synchronizedList(new ArrayList(3));
    private boolean distributedStatisticsEnabled = true;
    private DistributedWorkManagerStatisticsImpl distributedStatistics = null;
    private boolean doWorkDistributionEnabled = true;
    private boolean startWorkDistributionEnabled = true;
    private boolean scheduleWorkDistributionEnabled = true;
    private Address localAddress = null;

    public Policy getPolicy() {
        return this.policy;
    }

    public synchronized void setPolicy(Policy v) {
        if (this.policy != null && this.policy instanceof NotificationListener) {
            this.listeners.remove((NotificationListener)this.policy);
        }
        this.policy = v;
        if (this.policy != null && this.policy instanceof NotificationListener) {
            this.listeners.add((NotificationListener)this.policy);
        }
    }

    public Selector getSelector() {
        return this.selector;
    }

    public synchronized void setSelector(Selector v) {
        if (this.selector != null && this.selector instanceof NotificationListener) {
            this.listeners.remove((NotificationListener)this.selector);
        }
        this.selector = v;
        if (this.selector != null && this.selector instanceof NotificationListener) {
            this.listeners.add((NotificationListener)this.selector);
        }
    }

    public Transport getTransport() {
        return this.transport;
    }

    public synchronized void setTransport(Transport v) {
        if (this.transport != null) {
            if (this.transport instanceof NotificationListener) {
                this.listeners.remove((NotificationListener)this.transport);
            }
            this.removeDistributedStatistics();
        }
        this.transport = v;
        if (this.transport != null) {
            if (this.transport instanceof NotificationListener) {
                this.listeners.add((NotificationListener)this.transport);
            }
            this.initDistributedStatistics();
        }
    }

    public boolean isDistributedStatisticsEnabled() {
        return this.distributedStatisticsEnabled;
    }

    public void setDistributedStatisticsEnabled(boolean v) {
        this.distributedStatisticsEnabled = v;
    }

    public Collection<NotificationListener> getNotificationListeners() {
        return this.listeners;
    }

    void setNotificationListeners(Collection<NotificationListener> v) {
        this.listeners = v;
    }

    public void setDoWorkDistributionEnabled(boolean v) {
        this.doWorkDistributionEnabled = v;
    }

    public boolean isDoWorkDistributionEnabled() {
        return this.doWorkDistributionEnabled;
    }

    public void setStartWorkDistributionEnabled(boolean v) {
        this.startWorkDistributionEnabled = v;
    }

    public boolean isStartWorkDistributionEnabled() {
        return this.startWorkDistributionEnabled;
    }

    public void setScheduleWorkDistributionEnabled(boolean v) {
        this.scheduleWorkDistributionEnabled = v;
    }

    public boolean isScheduleWorkDistributionEnabled() {
        return this.scheduleWorkDistributionEnabled;
    }

    public void localDoWork(Work work) throws WorkException {
        if (this.transport != null) {
            this.checkTransport();
            if (this.getLongRunningThreadPool() != null && WorkManagerUtil.isLongRunning(work)) {
                this.transport.updateLongRunningFree(this.getLocalAddress(), this.getLongRunningThreadPool().getNumberOfFreeThreads() - 1L);
            } else {
                this.transport.updateShortRunningFree(this.getLocalAddress(), this.getShortRunningThreadPool().getNumberOfFreeThreads() - 1L);
            }
            WorkEventListener wel = new WorkEventListener(WorkManagerUtil.isLongRunning(work), this.getShortRunningThreadPool(), this.getLongRunningThreadPool(), this.getLocalAddress(), this.transport);
            super.doWork(work, Long.MAX_VALUE, null, (WorkListener)wel);
        } else {
            super.doWork(work);
        }
    }

    public void localScheduleWork(Work work) throws WorkException {
        if (this.transport != null) {
            this.checkTransport();
            if (this.getLongRunningThreadPool() != null && WorkManagerUtil.isLongRunning(work)) {
                this.transport.updateLongRunningFree(this.getLocalAddress(), this.getLongRunningThreadPool().getNumberOfFreeThreads() - 1L);
            } else {
                this.transport.updateShortRunningFree(this.getLocalAddress(), this.getShortRunningThreadPool().getNumberOfFreeThreads() - 1L);
            }
            WorkEventListener wel = new WorkEventListener(WorkManagerUtil.isLongRunning(work), this.getShortRunningThreadPool(), this.getLongRunningThreadPool(), this.getLocalAddress(), this.transport);
            super.scheduleWork(work, Long.MAX_VALUE, null, (WorkListener)wel);
        } else {
            super.scheduleWork(work);
        }
    }

    public long localStartWork(Work work) throws WorkException {
        if (this.transport != null) {
            this.checkTransport();
            if (this.getLongRunningThreadPool() != null && WorkManagerUtil.isLongRunning(work)) {
                this.transport.updateLongRunningFree(this.getLocalAddress(), this.getLongRunningThreadPool().getNumberOfFreeThreads() - 1L);
            } else {
                this.transport.updateShortRunningFree(this.getLocalAddress(), this.getShortRunningThreadPool().getNumberOfFreeThreads() - 1L);
            }
            WorkEventListener wel = new WorkEventListener(WorkManagerUtil.isLongRunning(work), this.getShortRunningThreadPool(), this.getLongRunningThreadPool(), this.getLocalAddress(), this.transport);
            return super.startWork(work, Long.MAX_VALUE, null, (WorkListener)wel);
        }
        return super.startWork(work);
    }

    @Override
    public void doWork(Work work) throws WorkException {
        if (this.policy == null || this.selector == null || this.transport == null || work == null || !(work instanceof DistributableWork) || !this.doWorkDistributionEnabled) {
            this.localDoWork(work);
        } else {
            Address dwmAddress;
            this.doFirstChecks(work, Long.MAX_VALUE, null);
            this.checkTransport();
            DistributableWork dw = (DistributableWork)work;
            boolean executed = false;
            if (this.policy.shouldDistribute((DistributedWorkManager)this, dw) && (dwmAddress = this.selector.selectDistributedWorkManager(this.getLocalAddress(), dw)) != null && !this.getLocalAddress().equals((Object)dwmAddress)) {
                this.transport.doWork(dwmAddress, dw);
                executed = true;
            }
            if (!executed) {
                this.localDoWork(work);
            }
        }
    }

    @Override
    public long startWork(Work work) throws WorkException {
        Address dwmAddress;
        if (this.policy == null || this.selector == null || this.transport == null || work == null || !(work instanceof DistributableWork) || !this.startWorkDistributionEnabled) {
            return this.localStartWork(work);
        }
        this.doFirstChecks(work, Long.MAX_VALUE, null);
        this.checkTransport();
        DistributableWork dw = (DistributableWork)work;
        if (this.policy.shouldDistribute((DistributedWorkManager)this, dw) && (dwmAddress = this.selector.selectDistributedWorkManager(this.getLocalAddress(), dw)) != null && !this.getLocalAddress().equals((Object)dwmAddress)) {
            return this.transport.startWork(dwmAddress, dw);
        }
        return this.localStartWork(work);
    }

    @Override
    public void scheduleWork(Work work) throws WorkException {
        if (this.policy == null || this.selector == null || this.transport == null || work == null || !(work instanceof DistributableWork) || !this.scheduleWorkDistributionEnabled) {
            this.localScheduleWork(work);
        } else {
            Address dwmAddress;
            this.doFirstChecks(work, Long.MAX_VALUE, null);
            this.checkTransport();
            DistributableWork dw = (DistributableWork)work;
            boolean executed = false;
            if (this.policy.shouldDistribute((DistributedWorkManager)this, dw) && (dwmAddress = this.selector.selectDistributedWorkManager(this.getLocalAddress(), dw)) != null && !this.getLocalAddress().equals((Object)dwmAddress)) {
                this.transport.scheduleWork(dwmAddress, dw);
                executed = true;
            }
            if (!executed) {
                this.localScheduleWork(work);
            }
        }
    }

    private void checkTransport() throws WorkException {
        if (!this.transport.isInitialized()) {
            try {
                this.transport.initialize();
                this.initialize();
            }
            catch (Throwable t) {
                WorkException we = new WorkException("Exception during transport initialization");
                we.initCause(t);
                throw we;
            }
        }
    }

    public DistributedWorkManagerStatistics getDistributedStatistics() {
        return this.distributedStatistics;
    }

    void setDistributedStatistics(DistributedWorkManagerStatisticsImpl v) {
        this.distributedStatistics = v;
    }

    private synchronized void initDistributedStatistics() {
        if (this.distributedStatistics == null) {
            this.distributedStatistics = new DistributedWorkManagerStatisticsImpl();
            this.listeners.add(this.distributedStatistics);
        }
    }

    private synchronized void removeDistributedStatistics() {
        if (this.distributedStatistics != null) {
            this.listeners.remove(this.distributedStatistics);
            this.distributedStatistics.setTransport(null);
            this.distributedStatistics = null;
        }
    }

    @Override
    protected void deltaDoWorkAccepted() {
        if (trace) {
            log.trace("deltaDoWorkAccepted");
        }
        super.deltaDoWorkAccepted();
        if (this.distributedStatisticsEnabled && this.distributedStatistics != null && this.transport != null) {
            try {
                this.checkTransport();
                this.distributedStatistics.sendDeltaDoWorkAccepted();
            }
            catch (WorkException we) {
                log.debugf("deltaDoWorkAccepted: %s", we.getMessage(), (Object)we);
            }
        }
    }

    @Override
    protected void deltaDoWorkRejected() {
        if (trace) {
            log.trace("deltaDoWorkRejected");
        }
        super.deltaDoWorkRejected();
        if (this.distributedStatisticsEnabled && this.distributedStatistics != null && this.transport != null) {
            try {
                this.checkTransport();
                this.distributedStatistics.sendDeltaDoWorkRejected();
            }
            catch (WorkException we) {
                log.debugf("deltaDoWorkRejected: %s", we.getMessage(), (Object)we);
            }
        }
    }

    @Override
    protected void deltaStartWorkAccepted() {
        if (trace) {
            log.trace("deltaStartWorkAccepted");
        }
        super.deltaStartWorkAccepted();
        if (this.distributedStatisticsEnabled && this.distributedStatistics != null && this.transport != null) {
            try {
                this.checkTransport();
                this.distributedStatistics.sendDeltaStartWorkAccepted();
            }
            catch (WorkException we) {
                log.debugf("deltaStartWorkAccepted: %s", we.getMessage(), (Object)we);
            }
        }
    }

    @Override
    protected void deltaStartWorkRejected() {
        if (trace) {
            log.trace("deltaStartWorkRejected");
        }
        super.deltaStartWorkRejected();
        if (this.distributedStatisticsEnabled && this.distributedStatistics != null && this.transport != null) {
            try {
                this.checkTransport();
                this.distributedStatistics.sendDeltaStartWorkRejected();
            }
            catch (WorkException we) {
                log.debugf("deltaStartWorkRejected: %s", we.getMessage(), (Object)we);
            }
        }
    }

    @Override
    protected void deltaScheduleWorkAccepted() {
        if (trace) {
            log.trace("deltaScheduleWorkAccepted");
        }
        super.deltaScheduleWorkAccepted();
        if (this.distributedStatisticsEnabled && this.distributedStatistics != null && this.transport != null) {
            try {
                this.checkTransport();
                this.distributedStatistics.sendDeltaScheduleWorkAccepted();
            }
            catch (WorkException we) {
                log.debugf("deltaScheduleWorkAccepted: %s", we.getMessage(), (Object)we);
            }
        }
    }

    @Override
    protected void deltaScheduleWorkRejected() {
        if (trace) {
            log.trace("deltaScheduleWorkRejected");
        }
        super.deltaScheduleWorkRejected();
        if (this.distributedStatisticsEnabled && this.distributedStatistics != null && this.transport != null) {
            try {
                this.checkTransport();
                this.distributedStatistics.sendDeltaScheduleWorkRejected();
            }
            catch (WorkException we) {
                log.debugf("deltaScheduleWorkRejected: %s", we.getMessage(), (Object)we);
            }
        }
    }

    @Override
    protected void deltaWorkSuccessful() {
        if (trace) {
            log.trace("deltaWorkSuccessful");
        }
        super.deltaWorkSuccessful();
        if (this.distributedStatisticsEnabled && this.distributedStatistics != null && this.transport != null) {
            try {
                this.checkTransport();
                this.distributedStatistics.sendDeltaWorkSuccessful();
            }
            catch (WorkException we) {
                log.debugf("deltaWorkSuccessful: %s", we.getMessage(), (Object)we);
            }
        }
    }

    @Override
    protected void deltaWorkFailed() {
        if (trace) {
            log.trace("deltaWorkFailed");
        }
        super.deltaWorkFailed();
        if (this.distributedStatisticsEnabled && this.distributedStatistics != null && this.transport != null) {
            try {
                this.checkTransport();
                this.distributedStatistics.sendDeltaWorkFailed();
            }
            catch (WorkException we) {
                log.debugf("deltaWorkFailed: %s", we.getMessage(), (Object)we);
            }
        }
    }

    Address getLocalAddress() {
        if (this.localAddress == null) {
            this.localAddress = new Address(this.getId(), this.getName(), this.transport != null ? this.transport.getId() : null);
        }
        return this.localAddress;
    }

    public void initialize() {
        if (this.distributedStatistics != null) {
            this.distributedStatistics.setOwnId(this.getLocalAddress());
            this.distributedStatistics.setTransport(this.transport);
        }
    }

    @Override
    public WorkManager clone() throws CloneNotSupportedException {
        DistributedWorkManagerImpl wm = (DistributedWorkManagerImpl)super.clone();
        wm.setPolicy(this.getPolicy());
        wm.setSelector(this.getSelector());
        wm.setTransport(this.getTransport());
        wm.setDistributedStatisticsEnabled(this.isDistributedStatisticsEnabled());
        wm.setDoWorkDistributionEnabled(this.isDoWorkDistributionEnabled());
        wm.setStartWorkDistributionEnabled(this.isStartWorkDistributionEnabled());
        wm.setScheduleWorkDistributionEnabled(this.isScheduleWorkDistributionEnabled());
        DistributedWorkManagerStatisticsImpl dwmsi = new DistributedWorkManagerStatisticsImpl();
        wm.setDistributedStatistics(dwmsi);
        if (this.getPolicy() != null && this.getPolicy() instanceof NotificationListener) {
            wm.listeners.add((NotificationListener)this.getPolicy());
        }
        if (this.getSelector() != null && this.getSelector() instanceof NotificationListener) {
            wm.listeners.add((NotificationListener)this.getSelector());
        }
        if (this.getTransport() != null && this.getTransport() instanceof NotificationListener) {
            wm.listeners.add((NotificationListener)this.getTransport());
        }
        wm.listeners.add(dwmsi);
        return wm;
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append(" policy=").append(this.policy);
        sb.append(" selector=").append(this.selector);
        sb.append(" transport=").append(this.transport);
        sb.append(" distributedStatisticsEnabled=").append(this.distributedStatisticsEnabled);
        sb.append(" distributedStatistics=").append(this.distributedStatistics);
        sb.append(" listeners=").append(this.listeners);
        sb.append(" doWorkDistributionEnabled=").append(this.doWorkDistributionEnabled);
        sb.append(" startWorkDistributionEnabled=").append(this.startWorkDistributionEnabled);
        sb.append(" scheduleWorkDistributionEnabled=").append(this.scheduleWorkDistributionEnabled);
    }
}

