/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.subsystem.server.extension;

import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.keycloak.subsystem.server.extension.KeycloakAdapterConfigService;

public class KeycloakServerDeploymentProcessor
implements DeploymentUnitProcessor {
    private static final ServiceName cacheContainerService = ServiceName.of((String[])new String[]{"jboss", "infinispan", "keycloak"});

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        KeycloakAdapterConfigService config = KeycloakAdapterConfigService.INSTANCE;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        String deploymentName = deploymentUnit.getName();
        if (!config.isKeycloakServerDeployment(deploymentName)) {
            return;
        }
        EEModuleDescription description = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        String webContext = config.getWebContext();
        if (webContext == null) {
            throw new DeploymentUnitProcessingException("Can't determine web context/module for Keycloak Server");
        }
        description.setModuleName(webContext);
        this.addInfinispanCaches(phaseContext);
    }

    private void addInfinispanCaches(DeploymentPhaseContext context) {
        if (context.getServiceRegistry().getService(cacheContainerService) != null) {
            ServiceTarget st = context.getServiceTarget();
            st.addDependency(cacheContainerService);
            st.addDependency(cacheContainerService.append(new String[]{"realms"}));
            st.addDependency(cacheContainerService.append(new String[]{"users"}));
            st.addDependency(cacheContainerService.append(new String[]{"sessions"}));
            st.addDependency(cacheContainerService.append(new String[]{"offlineSessions"}));
            st.addDependency(cacheContainerService.append(new String[]{"loginFailures"}));
        }
    }

    public void undeploy(DeploymentUnit du) {
    }
}

