/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.login.freemarker;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.MultivaluedMap;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;

public class LoginFormsUtil {
    public static List<IdentityProviderModel> filterIdentityProviders(List<IdentityProviderModel> providers, KeycloakSession session, RealmModel realm, Map<String, Object> attributes, MultivaluedMap<String, String> formData) {
        Boolean usernameEditDisabled = (Boolean)attributes.get("usernameEditDisabled");
        if (usernameEditDisabled != null && usernameEditDisabled.booleanValue()) {
            String username = (String)formData.getFirst((Object)"username");
            if (username == null) {
                throw new IllegalStateException("USERNAME_EDIT_DISABLED but username not known");
            }
            UserModel user = session.users().getUserByUsername(username, realm);
            if (user == null || !user.isEnabled()) {
                throw new IllegalStateException("User " + username + " not found or disabled");
            }
            Set fedLinks = session.users().getFederatedIdentities(user, realm);
            HashSet<String> federatedIdentities = new HashSet<String>();
            for (FederatedIdentityModel fedLink : fedLinks) {
                federatedIdentities.add(fedLink.getIdentityProvider());
            }
            LinkedList<IdentityProviderModel> result = new LinkedList<IdentityProviderModel>();
            for (IdentityProviderModel idp : providers) {
                if (!federatedIdentities.contains(idp.getAlias())) continue;
                result.add(idp);
            }
            return result;
        }
        return providers;
    }
}

