/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.social.microsoft;

import java.net.URLEncoder;
import org.codehaus.jackson.JsonNode;
import org.jboss.logging.Logger;
import org.keycloak.broker.oidc.AbstractOAuth2IdentityProvider;
import org.keycloak.broker.oidc.OAuth2IdentityProviderConfig;
import org.keycloak.broker.oidc.mappers.AbstractJsonUserAttributeMapper;
import org.keycloak.broker.oidc.util.JsonSimpleHttp;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.broker.provider.IdentityBrokerException;
import org.keycloak.broker.provider.IdentityProvider;
import org.keycloak.broker.provider.util.SimpleHttp;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.social.SocialIdentityProvider;

public class MicrosoftIdentityProvider
extends AbstractOAuth2IdentityProvider
implements SocialIdentityProvider {
    private static final Logger log = Logger.getLogger(MicrosoftIdentityProvider.class);
    public static final String AUTH_URL = "https://login.live.com/oauth20_authorize.srf";
    public static final String TOKEN_URL = "https://login.live.com/oauth20_token.srf";
    public static final String PROFILE_URL = "https://apis.live.net/v5.0/me";
    public static final String DEFAULT_SCOPE = "wl.basic,wl.emails";

    public MicrosoftIdentityProvider(OAuth2IdentityProviderConfig config) {
        super(config);
        config.setAuthorizationUrl(AUTH_URL);
        config.setTokenUrl(TOKEN_URL);
        config.setUserInfoUrl(PROFILE_URL);
    }

    protected BrokeredIdentityContext doGetFederatedIdentity(String accessToken) {
        try {
            String URL = "https://apis.live.net/v5.0/me?access_token=" + URLEncoder.encode(accessToken, "UTF-8");
            if (log.isDebugEnabled()) {
                log.debug((Object)("Microsoft Live user profile request to: " + URL));
            }
            JsonNode profile = JsonSimpleHttp.asJson((SimpleHttp)SimpleHttp.doGet((String)URL));
            String id = this.getJsonProperty(profile, "id");
            String email = null;
            if (profile.has("emails")) {
                email = this.getJsonProperty(profile.get("emails"), "preferred");
            }
            BrokeredIdentityContext user = new BrokeredIdentityContext(id);
            user.setUsername(email != null ? email : id);
            user.setFirstName(this.getJsonProperty(profile, "first_name"));
            user.setLastName(this.getJsonProperty(profile, "last_name"));
            if (email != null) {
                user.setEmail(email);
            }
            user.setIdpConfig((IdentityProviderModel)this.getConfig());
            user.setIdp((IdentityProvider)this);
            AbstractJsonUserAttributeMapper.storeUserProfileForMapper((BrokeredIdentityContext)user, (JsonNode)profile, (String)this.getConfig().getAlias());
            return user;
        }
        catch (Exception e) {
            throw new IdentityBrokerException("Could not obtain user profile from Microsoft Live ID.", (Throwable)e);
        }
    }

    protected String getDefaultScopes() {
        return DEFAULT_SCOPE;
    }
}

