/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.accesscontrol.AccessRequirement;
import org.jboss.as.cli.accesscontrol.AccessRequirementBuilder;
import org.jboss.as.cli.handlers.BatchModeCommandHandler;
import org.jboss.as.cli.handlers.CommandHandlerWithArguments;
import org.jboss.as.cli.handlers.DefaultFilenameTabCompleter;
import org.jboss.as.cli.handlers.FilenameTabCompleter;
import org.jboss.as.cli.handlers.WindowsFilenameTabCompleter;
import org.jboss.as.cli.impl.ArgumentWithValue;
import org.jboss.as.cli.impl.ArgumentWithoutValue;
import org.jboss.as.cli.impl.CommaSeparatedCompleter;
import org.jboss.as.cli.impl.DefaultCompleter;
import org.jboss.as.cli.impl.PermittedCandidates;
import org.jboss.as.cli.operation.ParsedCommandLine;
import org.jboss.as.cli.parsing.ExpressionBaseState;
import org.jboss.as.cli.parsing.ParsingState;
import org.jboss.as.cli.parsing.WordCharacterHandler;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class DeploymentOverlayHandler
extends BatchModeCommandHandler {
    private static final String ADD = "add";
    private static final String LINK = "link";
    private static final String LIST_CONTENT = "list-content";
    private static final String LIST_LINKS = "list-links";
    private static final String REDEPLOY_AFFECTED = "redeploy-affected";
    private static final String REMOVE = "remove";
    private static final String UPLOAD = "upload";
    private static final byte REDEPLOY_NONE = 0;
    private static final byte REDEPLOY_ONLY_AFFECTED = 1;
    private static final byte REDEPLOY_ALL = 2;
    private final ArgumentWithoutValue l = new ArgumentWithoutValue(this, "-l"){

        @Override
        public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
            String actionStr = DeploymentOverlayHandler.this.action.getValue(ctx.getParsedCommandLine());
            if (actionStr == null || DeploymentOverlayHandler.LIST_CONTENT.equals(actionStr) || DeploymentOverlayHandler.LIST_LINKS.equals(actionStr)) {
                return super.canAppearNext(ctx);
            }
            return false;
        }
    };
    private final ArgumentWithValue action;
    private final ArgumentWithValue name;
    private final ArgumentWithValue content;
    private final ArgumentWithValue serverGroups;
    private final ArgumentWithoutValue allServerGroups;
    private final ArgumentWithoutValue allRelevantServerGroups;
    private final ArgumentWithValue deployments;
    private final ArgumentWithoutValue redeployAffected;
    private final FilenameTabCompleter pathCompleter;
    private AccessRequirement generalListPermission;
    private AccessRequirement addPermission;
    private AccessRequirement linkPermission;
    private AccessRequirement removePermission;
    private AccessRequirement redeployPermission;
    private AccessRequirement listContentPermission;
    private AccessRequirement listLinksPermission;

    public DeploymentOverlayHandler(CommandContext ctx) {
        super(ctx, "deployment-overlay", true);
        this.l.setAccessRequirement(this.generalListPermission);
        this.action = new ArgumentWithValue((CommandHandlerWithArguments)this, (CommandLineCompleter)new DefaultCompleter(PermittedCandidates.create(ADD, this.addPermission).add(LINK, this.linkPermission).add(LIST_CONTENT, this.listContentPermission).add(LIST_LINKS, this.listLinksPermission).add(REDEPLOY_AFFECTED, this.redeployPermission).add(REMOVE, this.removePermission).add(UPLOAD, this.addPermission)), 0, "--action");
        this.name = new ArgumentWithValue((CommandHandlerWithArguments)this, new DefaultCompleter(new DefaultCompleter.CandidatesProvider(){

            @Override
            public Collection<String> getAllCandidates(CommandContext ctx) {
                ModelNode response;
                ModelControllerClient client = ctx.getModelControllerClient();
                if (client == null) {
                    return Collections.emptyList();
                }
                ModelNode op = new ModelNode();
                op.get("operation").set("read-children-names");
                op.get("address").setEmptyList();
                op.get("child-type").set("deployment-overlay");
                try {
                    response = client.execute(op);
                }
                catch (IOException e) {
                    return Collections.emptyList();
                }
                ModelNode result = response.get("result");
                if (!result.isDefined()) {
                    return Collections.emptyList();
                }
                ArrayList<String> names = new ArrayList<String>();
                for (ModelNode node : result.asList()) {
                    names.add(node.asString());
                }
                return names;
            }
        }), "--name");
        this.name.addRequiredPreceding(this.action);
        this.name.setAccessRequirement(AccessRequirementBuilder.Factory.create(ctx).any().requirement(this.addPermission).requirement(this.removePermission).requirement(this.linkPermission).requirement(this.listContentPermission).requirement(this.listLinksPermission).requirement(this.redeployPermission).build());
        this.pathCompleter = Util.isWindows() ? new WindowsFilenameTabCompleter(ctx) : new DefaultFilenameTabCompleter(ctx);
        this.content = new ArgumentWithValue(this, new CommandLineCompleter(){

            @Override
            public int complete(CommandContext ctx, String buffer, int cursor, List<String> candidates) {
                String actionStr = DeploymentOverlayHandler.this.action.getValue(ctx.getParsedCommandLine());
                if (DeploymentOverlayHandler.ADD.equals(actionStr) || DeploymentOverlayHandler.UPLOAD.equals(actionStr)) {
                    int i = buffer.lastIndexOf(44);
                    if ((i = buffer.indexOf(61, i + 1)) < 0) {
                        return -1;
                    }
                    String path = buffer.substring(i + 1);
                    int pathResult = DeploymentOverlayHandler.this.pathCompleter.complete(ctx, path, 0, candidates);
                    if (pathResult < 0) {
                        return -1;
                    }
                    return i + 1 + pathResult;
                }
                if (DeploymentOverlayHandler.REMOVE.equals(actionStr)) {
                    List<String> existing;
                    String nameStr = DeploymentOverlayHandler.this.name.getValue(ctx.getParsedCommandLine());
                    if (nameStr == null) {
                        return -1;
                    }
                    try {
                        existing = DeploymentOverlayHandler.this.loadContentFor(ctx.getModelControllerClient(), nameStr);
                    }
                    catch (CommandLineException e) {
                        return -1;
                    }
                    if (existing.isEmpty()) {
                        return buffer.length();
                    }
                    candidates.addAll(existing);
                    if (buffer.isEmpty()) {
                        return 0;
                    }
                    String[] specified = buffer.split(",+");
                    candidates.removeAll(Arrays.asList(specified));
                    if (buffer.charAt(buffer.length() - 1) == ',') {
                        return buffer.length();
                    }
                    String chunk = specified[specified.length - 1];
                    for (int i = 0; i < candidates.size(); ++i) {
                        if (candidates.get(i).startsWith(chunk)) continue;
                        candidates.remove(i);
                    }
                    return buffer.length() - chunk.length();
                }
                return -1;
            }
        }, "--content"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                String actionStr = DeploymentOverlayHandler.this.action.getValue(ctx.getParsedCommandLine());
                if (actionStr == null) {
                    return false;
                }
                if (DeploymentOverlayHandler.ADD.equals(actionStr) || DeploymentOverlayHandler.UPLOAD.equals(actionStr) || DeploymentOverlayHandler.REMOVE.equals(actionStr)) {
                    return super.canAppearNext(ctx);
                }
                return false;
            }

            @Override
            protected ParsingState initParsingState() {
                ExpressionBaseState state = new ExpressionBaseState("EXPR", true, false);
                if (Util.isWindows()) {
                    state.setDefaultHandler(WordCharacterHandler.IGNORE_LB_ESCAPE_OFF);
                } else {
                    state.setDefaultHandler(WordCharacterHandler.IGNORE_LB_ESCAPE_ON);
                }
                return state;
            }
        };
        this.content.addRequiredPreceding(this.name);
        this.content.addCantAppearAfter(this.l);
        this.serverGroups = new ArgumentWithValue(this, new CommaSeparatedCompleter(){

            @Override
            protected Collection<String> getAllCandidates(CommandContext ctx) {
                return Util.getServerGroups(ctx.getModelControllerClient());
            }
        }, "--server-groups"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (!ctx.isDomainMode()) {
                    return false;
                }
                String actionStr = DeploymentOverlayHandler.this.action.getValue(ctx.getParsedCommandLine());
                if (actionStr == null) {
                    return false;
                }
                if (DeploymentOverlayHandler.ADD.equals(actionStr) || DeploymentOverlayHandler.LINK.equals(actionStr) || DeploymentOverlayHandler.REMOVE.equals(actionStr) || DeploymentOverlayHandler.LIST_LINKS.equals(actionStr)) {
                    return super.canAppearNext(ctx);
                }
                return false;
            }
        };
        this.serverGroups.addRequiredPreceding(this.name);
        this.allRelevantServerGroups = new ArgumentWithoutValue(this, "--all-relevant-server-groups"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (!ctx.isDomainMode()) {
                    return false;
                }
                String actionStr = DeploymentOverlayHandler.this.action.getValue(ctx.getParsedCommandLine());
                if (actionStr == null) {
                    return false;
                }
                if (DeploymentOverlayHandler.REMOVE.equals(actionStr)) {
                    return super.canAppearNext(ctx);
                }
                return false;
            }
        };
        this.allRelevantServerGroups.addRequiredPreceding(this.name);
        this.allRelevantServerGroups.addCantAppearAfter(this.serverGroups);
        this.serverGroups.addCantAppearAfter(this.allRelevantServerGroups);
        this.allServerGroups = new ArgumentWithoutValue(this, "--all-server-groups"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (!ctx.isDomainMode()) {
                    return false;
                }
                String actionStr = DeploymentOverlayHandler.this.action.getValue(ctx.getParsedCommandLine());
                if (actionStr == null) {
                    return false;
                }
                if (DeploymentOverlayHandler.ADD.equals(actionStr) || DeploymentOverlayHandler.LINK.equals(actionStr)) {
                    return super.canAppearNext(ctx);
                }
                return false;
            }
        };
        this.allServerGroups.addRequiredPreceding(this.name);
        this.allServerGroups.addCantAppearAfter(this.serverGroups);
        this.serverGroups.addCantAppearAfter(this.allServerGroups);
        this.deployments = new ArgumentWithValue(this, new CommaSeparatedCompleter(){

            @Override
            protected Collection<String> getAllCandidates(CommandContext ctx) {
                String actionValue = DeploymentOverlayHandler.this.action.getValue(ctx.getParsedCommandLine());
                ModelControllerClient client = ctx.getModelControllerClient();
                if (DeploymentOverlayHandler.REMOVE.equals(actionValue)) {
                    block9: {
                        String overlay = DeploymentOverlayHandler.this.name.getValue(ctx.getParsedCommandLine());
                        if (overlay == null) {
                            return Collections.emptyList();
                        }
                        try {
                            if (ctx.isDomainMode()) {
                                String groupsStr = DeploymentOverlayHandler.this.serverGroups.getValue(ctx.getParsedCommandLine());
                                if (groupsStr != null) {
                                    String[] groups = groupsStr.split(",+");
                                    if (groups.length == 1) {
                                        return DeploymentOverlayHandler.this.filterLinks(DeploymentOverlayHandler.this.loadLinkResources(client, overlay, groups[0]));
                                    }
                                    if (groups.length > 1) {
                                        HashSet<String> commonLinks = new HashSet<String>();
                                        commonLinks.addAll(DeploymentOverlayHandler.this.filterLinks(DeploymentOverlayHandler.this.loadLinkResources(client, overlay, groups[0])));
                                        for (int i = 1; i < groups.length; ++i) {
                                            commonLinks.retainAll(DeploymentOverlayHandler.this.filterLinks(DeploymentOverlayHandler.this.loadLinkResources(client, overlay, groups[i])));
                                        }
                                        return commonLinks;
                                    }
                                }
                                break block9;
                            }
                            return DeploymentOverlayHandler.this.filterLinks(DeploymentOverlayHandler.this.loadLinkResources(client, overlay, null));
                        }
                        catch (CommandLineException commandLineException) {
                            // empty catch block
                        }
                    }
                    return Collections.emptyList();
                }
                return Util.getDeployments(client);
            }
        }, "--deployments"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (ctx.isDomainMode()) {
                    if (DeploymentOverlayHandler.this.serverGroups.isPresent(ctx.getParsedCommandLine()) || DeploymentOverlayHandler.this.allServerGroups.isPresent(ctx.getParsedCommandLine())) {
                        return super.canAppearNext(ctx);
                    }
                    return false;
                }
                String actionStr = DeploymentOverlayHandler.this.action.getValue(ctx.getParsedCommandLine());
                if (actionStr == null) {
                    return false;
                }
                if (DeploymentOverlayHandler.ADD.equals(actionStr) || DeploymentOverlayHandler.LINK.equals(actionStr) || DeploymentOverlayHandler.REMOVE.equals(actionStr)) {
                    return super.canAppearNext(ctx);
                }
                return false;
            }
        };
        this.deployments.addRequiredPreceding(this.name);
        this.deployments.addCantAppearAfter(this.l);
        this.redeployAffected = new ArgumentWithoutValue(this, "--redeploy-affected"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (DeploymentOverlayHandler.this.deployments.isPresent(ctx.getParsedCommandLine())) {
                    return super.canAppearNext(ctx);
                }
                String actionValue = DeploymentOverlayHandler.this.action.getValue(ctx.getParsedCommandLine());
                if (actionValue != null && (actionValue.equals(DeploymentOverlayHandler.UPLOAD) || actionValue.equals(DeploymentOverlayHandler.REMOVE))) {
                    return super.canAppearNext(ctx);
                }
                return false;
            }
        };
        this.redeployAffected.setAccessRequirement(this.redeployPermission);
    }

    @Override
    protected AccessRequirement setupAccessRequirement(CommandContext ctx) {
        this.generalListPermission = AccessRequirementBuilder.Factory.create(ctx).any().operation("deployment-overlay=?", "read-children-names").build();
        this.addPermission = AccessRequirementBuilder.Factory.create(ctx).any().operation("deployment-overlay=?", ADD).operation("deployment-overlay=?/content=?", ADD).build();
        this.linkPermission = AccessRequirementBuilder.Factory.create(ctx).any().operation("deployment-overlay=?/deployment=?", ADD).serverGroupOperation("deployment-overlay=?", ADD).serverGroupOperation("deployment-overlay=?/deployment=?", ADD).build();
        this.removePermission = AccessRequirementBuilder.Factory.create(ctx).any().operation("deployment-overlay=?", REMOVE).operation("deployment-overlay=?/content=?", REMOVE).operation("deployment-overlay=?/deployment=?", REMOVE).all().serverGroupOperation("deployment-overlay=?/deployment=?", REMOVE).serverGroupOperation("deployment-overlay=?", REMOVE).parent().build();
        this.redeployPermission = AccessRequirementBuilder.Factory.create(ctx).any().operation("deployment=?", "redeploy").serverGroupOperation("deployment=?", "redeploya").build();
        this.listContentPermission = AccessRequirementBuilder.Factory.create(ctx).any().operation("deployment-overlay=?", "read-children-names").build();
        this.listLinksPermission = AccessRequirementBuilder.Factory.create(ctx).any().operation("deployment-overlay=?", "read-children-names").serverGroupOperation("deployment-overlay=?", "read-children-names").build();
        return AccessRequirementBuilder.Factory.create(ctx).any().requirement(this.generalListPermission).requirement(this.addPermission).requirement(this.linkPermission).requirement(this.removePermission).requirement(this.redeployPermission).requirement(this.listContentPermission).requirement(this.listLinksPermission).build();
    }

    @Override
    public boolean isBatchMode(CommandContext ctx) {
        String action = this.action.getValue(ctx.getParsedCommandLine());
        if (action != null && (LIST_LINKS.equals(action) || LIST_CONTENT.equals(action))) {
            return false;
        }
        return super.isBatchMode(ctx);
    }

    @Override
    protected void doHandle(CommandContext ctx) throws CommandLineException {
        ParsedCommandLine args = ctx.getParsedCommandLine();
        if (!args.hasProperties() || this.l.isPresent(args) && args.getOtherProperties().isEmpty() && args.getPropertyNames().size() == 1) {
            ModelNode response;
            ModelNode op = new ModelNode();
            op.get("address").setEmptyList();
            op.get("operation").set("read-children-names");
            op.get("child-type").set("deployment-overlay");
            try {
                response = ctx.getModelControllerClient().execute(op);
            }
            catch (IOException e) {
                throw new CommandLineException("Failed to execute read-children-names", e);
            }
            ModelNode result = response.get("result");
            if (!result.isDefined()) {
                String descr = Util.getFailureDescription(response);
                if (descr != null) {
                    throw new CommandLineException(descr);
                }
                throw new CommandLineException("The response of read-children-names is missing result: " + response);
            }
            if (this.l.isPresent(args)) {
                for (ModelNode node : result.asList()) {
                    ctx.printLine(node.asString());
                }
            } else {
                ArrayList<String> names = new ArrayList<String>();
                for (ModelNode node : result.asList()) {
                    names.add(node.asString());
                }
                ctx.printColumns(names);
            }
            return;
        }
        String action = this.action.getValue(args, true);
        if (ADD.equals(action)) {
            this.add(ctx, true);
        } else if (UPLOAD.equals(action)) {
            this.upload(ctx, true);
        } else if (LIST_CONTENT.equals(action)) {
            this.listContent(ctx);
        } else if (LIST_LINKS.equals(action)) {
            this.listLinks(ctx);
        } else {
            super.doHandle(ctx);
        }
    }

    @Override
    protected ModelNode buildRequestWithoutHeaders(CommandContext ctx) throws CommandFormatException {
        ParsedCommandLine args = ctx.getParsedCommandLine();
        String action = this.action.getValue(args, true);
        try {
            if (REMOVE.equals(action)) {
                return this.remove(ctx);
            }
            if (LINK.equals(action)) {
                return this.link(ctx);
            }
            if (REDEPLOY_AFFECTED.equals(action)) {
                return this.redeployAffected(ctx);
            }
            if (ADD.equals(action)) {
                return this.add(ctx, false);
            }
            if (UPLOAD.equals(action)) {
                return this.upload(ctx, false);
            }
            throw new CommandFormatException("Doesn't know how to build request for action '" + action + "'");
        }
        catch (CommandFormatException e) {
            throw e;
        }
        catch (CommandLineException e) {
            throw new CommandFormatException("Failed to build " + action + " request.", e);
        }
    }

    protected ModelNode redeployAffected(CommandContext ctx) throws CommandLineException {
        ParsedCommandLine args = ctx.getParsedCommandLine();
        this.assertNotPresent(this.serverGroups, args);
        this.assertNotPresent(this.allServerGroups, args);
        this.assertNotPresent(this.allRelevantServerGroups, args);
        this.assertNotPresent(this.content, args);
        this.assertNotPresent(this.deployments, args);
        this.assertNotPresent(this.redeployAffected, args);
        String overlay = this.name.getValue(args, true);
        ModelControllerClient client = ctx.getModelControllerClient();
        ModelNode redeployOp = new ModelNode();
        redeployOp.get("operation").set("composite");
        redeployOp.get("address").setEmptyList();
        ModelNode steps = redeployOp.get("steps");
        if (ctx.isDomainMode()) {
            for (String group : Util.getServerGroupsReferencingOverlay(overlay, client)) {
                this.addRemoveRedeployLinksSteps(client, steps, overlay, group, null, false, (byte)2);
            }
        } else {
            this.addRemoveRedeployLinksSteps(client, steps, overlay, null, null, false, (byte)2);
        }
        if (!steps.isDefined() || steps.asList().isEmpty()) {
            throw new CommandFormatException("None of the deployments affected.");
        }
        return redeployOp;
    }

    protected void listLinks(CommandContext ctx) throws CommandLineException {
        ModelControllerClient client = ctx.getModelControllerClient();
        ParsedCommandLine args = ctx.getParsedCommandLine();
        this.assertNotPresent(this.allRelevantServerGroups, args);
        this.assertNotPresent(this.content, args);
        this.assertNotPresent(this.deployments, args);
        this.assertNotPresent(this.redeployAffected, args);
        String name = this.name.getValue(args, true);
        if (name == null) {
            throw new CommandFormatException(this.name + " is missing value.");
        }
        String sg = this.serverGroups.getValue(ctx.getParsedCommandLine());
        if (ctx.isDomainMode()) {
            List<String> groups = sg == null ? Util.getServerGroups(client) : Arrays.asList(sg.split(",+"));
            if (groups.size() == 0) {
                throw new CommandFormatException(this.serverGroups.getFullName() + " is missing value.");
            }
            for (String group : groups) {
                List<String> links = this.loadLinks(client, name, group);
                if (links.isEmpty()) continue;
                ctx.printLine("SERVER GROUP: " + group + Util.LINE_SEPARATOR);
                ctx.printColumns(links);
                ctx.printLine("");
            }
        } else {
            List<String> content = this.loadLinks(client, name, sg);
            if (this.l.isPresent(args)) {
                for (String contentPath : content) {
                    ctx.printLine(contentPath);
                }
            } else {
                ctx.printColumns(content);
            }
        }
    }

    protected void listContent(CommandContext ctx) throws CommandLineException {
        ModelControllerClient client = ctx.getModelControllerClient();
        ParsedCommandLine args = ctx.getParsedCommandLine();
        this.assertNotPresent(this.serverGroups, args);
        this.assertNotPresent(this.allServerGroups, args);
        this.assertNotPresent(this.allRelevantServerGroups, args);
        this.assertNotPresent(this.deployments, args);
        this.assertNotPresent(this.content, args);
        this.assertNotPresent(this.redeployAffected, args);
        String name = this.name.getValue(args, true);
        if (name == null) {
            throw new CommandFormatException(this.name.getFullName() + " is missing value.");
        }
        List<String> content = this.loadContentFor(client, name);
        if (this.l.isPresent(args)) {
            for (String contentPath : content) {
                ctx.printLine(contentPath);
            }
        } else {
            ctx.printColumns(content);
        }
    }

    protected ModelNode remove(CommandContext ctx) throws CommandLineException {
        byte redeploy;
        List<String> sg;
        ModelControllerClient client = ctx.getModelControllerClient();
        ParsedCommandLine args = ctx.getParsedCommandLine();
        this.assertNotPresent(this.allServerGroups, args);
        String name = this.name.getValue(args, true);
        if (name == null) {
            throw new CommandFormatException(this.name + " is missing value.");
        }
        String contentStr = this.content.getValue(args);
        String deploymentStr = this.deployments.getValue(args);
        String sgStr = this.serverGroups.getValue(args);
        if (sgStr == null) {
            sg = this.allRelevantServerGroups.isPresent(args) ? Util.getServerGroupsReferencingOverlay(name, client) : null;
        } else {
            sg = Arrays.asList(sgStr.split(",+"));
            if (sg.isEmpty()) {
                throw new CommandFormatException(this.serverGroups.getFullName() + " is missing value.");
            }
        }
        ModelNode composite = new ModelNode();
        composite.get("operation").set("composite");
        composite.get("address").setEmptyList();
        ModelNode steps = composite.get("steps");
        byte by = redeploy = this.redeployAffected.isPresent(args) ? (byte)1 : 0;
        if (contentStr != null || deploymentStr == null && sg == null) {
            if (redeploy == 1) {
                redeploy = 2;
            }
            List<String> contentList = contentStr == null ? this.loadContentFor(client, name) : Arrays.asList(contentStr.split(",+"));
            for (String content : contentList) {
                ModelNode op = new ModelNode();
                ModelNode addr = op.get("address");
                addr.add("deployment-overlay", name);
                addr.add("content", content);
                op.get("operation").set(REMOVE);
                steps.add(op);
            }
        }
        if (deploymentStr != null || contentStr == null) {
            List<String> links;
            if (ctx.isDomainMode()) {
                if (deploymentStr == null) {
                    List<String> groups = sg == null ? Util.getServerGroupsReferencingOverlay(name, client) : sg;
                    for (String group : groups) {
                        this.addRemoveRedeployLinksSteps(client, steps, name, group, null, true, redeploy);
                    }
                } else {
                    if (ctx.isDomainMode() && sg == null) {
                        throw new CommandFormatException(this.serverGroups.getFullName() + " or " + this.allRelevantServerGroups.getFullName() + " is required.");
                    }
                    links = Arrays.asList(deploymentStr.split(",+"));
                    for (String group : sg) {
                        this.addRemoveRedeployLinksSteps(client, steps, name, group, links, true, redeploy);
                    }
                }
            } else if (deploymentStr == null) {
                this.addRemoveRedeployLinksSteps(client, steps, name, null, null, true, redeploy);
            } else {
                links = Arrays.asList(deploymentStr.split(",+"));
                this.addRemoveRedeployLinksSteps(client, steps, name, null, links, true, redeploy);
            }
        } else if (redeploy == 2) {
            if (ctx.isDomainMode()) {
                for (String group : Util.getServerGroupsReferencingOverlay(name, client)) {
                    this.addRemoveRedeployLinksSteps(client, steps, name, group, null, false, redeploy);
                }
            } else {
                this.addRemoveRedeployLinksSteps(client, steps, name, null, null, false, redeploy);
            }
        }
        if (contentStr == null && deploymentStr == null && sg == null) {
            ModelNode op = new ModelNode();
            op.get("address").add("deployment-overlay", name);
            op.get("operation").set(REMOVE);
            steps.add(op);
        }
        return composite;
    }

    protected ModelNode add(CommandContext ctx, boolean stream) throws CommandLineException {
        ParsedCommandLine args = ctx.getParsedCommandLine();
        this.assertNotPresent(this.allRelevantServerGroups, args);
        String name = this.name.getValue(args, true);
        String contentStr = this.content.getValue(args, true);
        String[] contentPairs = contentStr.split(",+");
        if (contentPairs.length == 0) {
            throw new CommandFormatException("Overlay content is not specified.");
        }
        String[] contentNames = new String[contentPairs.length];
        File[] contentPaths = new File[contentPairs.length];
        for (int i = 0; i < contentPairs.length; ++i) {
            String pair = contentPairs[i];
            int equalsIndex = pair.indexOf(61);
            if (equalsIndex < 0) {
                throw new CommandFormatException("Content pair is not following archive-path=fs-path format: '" + pair + "'");
            }
            contentNames[i] = pair.substring(0, equalsIndex);
            if (contentNames[i].length() == 0) {
                throw new CommandFormatException("The archive path is missing for the content '" + pair + "'");
            }
            String path = pair.substring(equalsIndex + 1);
            if (path.length() == 0) {
                throw new CommandFormatException("The filesystem paths is missing for the content '" + pair + "'");
            }
            File f = new File(path = this.pathCompleter.translatePath(path));
            if (!f.exists()) {
                throw new CommandFormatException("Content file doesn't exist " + f.getAbsolutePath());
            }
            contentPaths[i] = f;
        }
        String[] deployments = this.getLinks(this.deployments, args);
        ModelControllerClient client = ctx.getModelControllerClient();
        ModelNode composite = new ModelNode();
        OperationBuilder opBuilder = stream ? new OperationBuilder(composite, true) : null;
        composite.get("operation").set("composite");
        composite.get("address").setEmptyList();
        ModelNode steps = composite.get("steps");
        ModelNode op = new ModelNode();
        ModelNode address = op.get("address");
        address.add("deployment-overlay", name);
        op.get("operation").set(ADD);
        steps.add(op);
        for (int i = 0; i < contentNames.length; ++i) {
            String contentName = contentNames[i];
            op = new ModelNode();
            address = op.get("address");
            address.add("deployment-overlay", name);
            address.add("content", contentName);
            op.get("operation").set(ADD);
            if (opBuilder != null) {
                op.get("content").get("input-stream-index").set(i);
                opBuilder.addFileAsAttachment(contentPaths[i]);
            } else {
                op.get("content").get("bytes").set(Util.readBytes(contentPaths[i]));
            }
            steps.add(op);
        }
        if (deployments != null) {
            if (ctx.isDomainMode()) {
                List<String> sg = this.getServerGroupsToLink(ctx);
                for (String group : sg) {
                    op = new ModelNode();
                    address = op.get("address");
                    address.add("server-group", group);
                    address.add("deployment-overlay", name);
                    op.get("operation").set(ADD);
                    steps.add(op);
                    this.addAddRedeployLinksSteps(ctx, steps, name, group, deployments, false);
                }
            } else {
                this.addAddRedeployLinksSteps(ctx, steps, name, null, deployments, false);
            }
        } else if (ctx.isDomainMode() && (this.serverGroups.isPresent(args) || this.allServerGroups.isPresent(args))) {
            throw new CommandFormatException("server groups are specified but " + this.deployments.getFullName() + " is not.");
        }
        if (opBuilder == null) {
            return composite;
        }
        try {
            ModelNode result = client.execute(opBuilder.build());
            if (!Util.isSuccess(result)) {
                throw new CommandFormatException(Util.getFailureDescription(result));
            }
        }
        catch (IOException e) {
            throw new CommandFormatException("Failed to add overlay", e);
        }
        return null;
    }

    protected ModelNode link(CommandContext ctx) throws CommandLineException {
        ParsedCommandLine args = ctx.getParsedCommandLine();
        this.assertNotPresent(this.allRelevantServerGroups, args);
        String name = this.name.getValue(args, true);
        String[] deployments = this.getLinks(this.deployments, args);
        if (deployments == null) {
            throw new CommandFormatException(this.deployments.getFullName() + " is required.");
        }
        ModelNode composite = new ModelNode();
        composite.get("operation").set("composite");
        composite.get("address").setEmptyList();
        ModelNode steps = composite.get("steps");
        ModelControllerClient client = ctx.getModelControllerClient();
        if (ctx.isDomainMode()) {
            List<String> sg = this.getServerGroupsToLink(ctx);
            for (String group : sg) {
                if (!Util.isValidPath(client, "server-group", group, "deployment-overlay", name)) {
                    ModelNode op = new ModelNode();
                    ModelNode address = op.get("address");
                    address.add("server-group", group);
                    address.add("deployment-overlay", name);
                    op.get("operation").set(ADD);
                    steps.add(op);
                }
                this.addAddRedeployLinksSteps(ctx, steps, name, group, deployments, false);
            }
        } else {
            this.addAddRedeployLinksSteps(ctx, steps, name, null, deployments, false);
        }
        return composite;
    }

    protected ModelNode upload(CommandContext ctx, boolean stream) throws CommandLineException {
        ParsedCommandLine args = ctx.getParsedCommandLine();
        String name = this.name.getValue(args, true);
        if (!Util.isValidPath(ctx.getModelControllerClient(), "deployment-overlay", name)) {
            throw new CommandLineException("Deployment overlay " + name + " does not exist.");
        }
        String contentStr = this.content.getValue(args, true);
        String[] contentPairs = contentStr.split(",+");
        if (contentPairs.length == 0) {
            throw new CommandFormatException("Overlay content is not specified.");
        }
        String[] contentNames = new String[contentPairs.length];
        File[] contentPaths = new File[contentPairs.length];
        for (int i = 0; i < contentPairs.length; ++i) {
            String pair = contentPairs[i];
            int equalsIndex = pair.indexOf(61);
            if (equalsIndex < 0) {
                throw new CommandFormatException("Content pair is not following archive-path=fs-path format: '" + pair + "'");
            }
            contentNames[i] = pair.substring(0, equalsIndex);
            if (contentNames[i].length() == 0) {
                throw new CommandFormatException("The archive path is missing for the content '" + pair + "'");
            }
            String path = pair.substring(equalsIndex + 1);
            if (path.length() == 0) {
                throw new CommandFormatException("The filesystem paths is missing for the content '" + pair + "'");
            }
            File f = new File(path = this.pathCompleter.translatePath(path));
            if (!f.exists()) {
                throw new CommandFormatException("Content file doesn't exist " + f.getAbsolutePath());
            }
            contentPaths[i] = f;
        }
        String deploymentsStr = this.deployments.getValue(args);
        if (deploymentsStr != null) {
            throw new CommandFormatException(this.deployments.getFullName() + " can't be used in combination with upload.");
        }
        ModelControllerClient client = ctx.getModelControllerClient();
        ModelNode composite = new ModelNode();
        OperationBuilder opBuilder = stream ? new OperationBuilder(composite, true) : null;
        composite.get("operation").set("composite");
        composite.get("address").setEmptyList();
        ModelNode steps = composite.get("steps");
        for (int i = 0; i < contentNames.length; ++i) {
            ModelNode op = new ModelNode();
            ModelNode address = op.get("address");
            address.add("deployment-overlay", name);
            address.add("content", contentNames[i]);
            op.get("operation").set(ADD);
            if (opBuilder != null) {
                op.get("content").get("input-stream-index").set(i);
                opBuilder.addFileAsAttachment(contentPaths[i]);
            } else {
                op.get("content").get("bytes").set(Util.readBytes(contentPaths[i]));
            }
            steps.add(op);
        }
        if (this.redeployAffected.isPresent(args)) {
            if (ctx.isDomainMode()) {
                for (String sgName : Util.getServerGroups(client)) {
                    this.addRemoveRedeployLinksSteps(client, steps, name, sgName, null, false, (byte)2);
                }
            } else {
                this.addRemoveRedeployLinksSteps(client, steps, name, null, null, false, (byte)2);
            }
        }
        if (opBuilder == null) {
            return composite;
        }
        try {
            ModelNode result = client.execute(opBuilder.build());
            if (!Util.isSuccess(result)) {
                throw new CommandFormatException(Util.getFailureDescription(result));
            }
        }
        catch (IOException e) {
            throw new CommandFormatException("Failed to add overlay", e);
        }
        return null;
    }

    protected List<String> loadContentFor(ModelControllerClient client, String overlay) throws CommandLineException {
        ModelNode response;
        ModelNode op = new ModelNode();
        op.get("address").add("deployment-overlay", overlay);
        op.get("operation").set("read-children-names");
        op.get("child-type").set("content");
        try {
            response = client.execute(op);
        }
        catch (IOException e) {
            throw new CommandLineException("Failed to load the list of the existing content for overlay " + overlay, e);
        }
        ModelNode result = response.get("result");
        if (!result.isDefined()) {
            throw new CommandLineException("Failed to load the list of the existing content for overlay " + overlay + ": " + response);
        }
        ArrayList<String> contentList = new ArrayList<String>();
        for (ModelNode node : result.asList()) {
            contentList.add(node.asString());
        }
        return contentList;
    }

    protected List<String> loadLinks(ModelControllerClient client, String overlay, String serverGroup) throws CommandLineException {
        ModelNode response;
        ModelNode op = new ModelNode();
        ModelNode addr = op.get("address");
        if (serverGroup != null) {
            addr.add("server-group", serverGroup);
        }
        addr.add("deployment-overlay", overlay);
        op.get("operation").set("read-children-names");
        op.get("child-type").set("deployment");
        try {
            response = client.execute(op);
        }
        catch (IOException e) {
            throw new CommandLineException("Failed to load the list of deployments for overlay " + overlay, e);
        }
        ModelNode result = response.get("result");
        if (!result.isDefined()) {
            String descr = Util.getFailureDescription(response);
            if (descr != null && descr.contains("WFLYCTL0216")) {
                return Collections.emptyList();
            }
            throw new CommandLineException("Failed to load the list of deployments for overlay " + overlay + ": " + response);
        }
        ArrayList<String> contentList = new ArrayList<String>();
        for (ModelNode node : result.asList()) {
            contentList.add(node.asString());
        }
        return contentList;
    }

    protected ModelNode loadLinkResources(ModelControllerClient client, String overlay, String serverGroup) throws CommandLineException {
        ModelNode response;
        ModelNode op = new ModelNode();
        ModelNode addr = op.get("address");
        if (serverGroup != null) {
            addr.add("server-group", serverGroup);
        }
        addr.add("deployment-overlay", overlay);
        op.get("operation").set("read-children-resources");
        op.get("child-type").set("deployment");
        try {
            response = client.execute(op);
        }
        catch (IOException e) {
            throw new CommandLineException("Failed to load the list of deployments for overlay " + overlay, e);
        }
        ModelNode result = response.get("result");
        if (!result.isDefined()) {
            String descr = Util.getFailureDescription(response);
            if (descr != null && (descr.contains("WFLYCTL0216") || descr.contains("WFLYCTL0202"))) {
                return null;
            }
            throw new CommandLineException("Failed to load the list of deployments for overlay " + overlay + ": " + response);
        }
        return result;
    }

    protected void addRedeployStep(ModelNode steps, String deployment, String serverGroup) {
        ModelNode step = new ModelNode();
        ModelNode address = step.get("address");
        if (serverGroup != null) {
            address.add("server-group", serverGroup);
        }
        address.add("deployment", deployment);
        step.get("operation").set("redeploy");
        steps.add(step);
    }

    protected String[] getLinks(ArgumentWithValue linksArg, ParsedCommandLine args) throws CommandFormatException {
        String[] deployments;
        String deploymentsStr = linksArg.getValue(args);
        if (deploymentsStr == null) {
            deployments = null;
        } else {
            deployments = deploymentsStr.split(",+");
            if (deployments.length == 0) {
                throw new CommandFormatException(linksArg.getFullName() + " is missing value.");
            }
        }
        return deployments;
    }

    protected List<String> getServerGroupsToLink(CommandContext ctx) throws CommandFormatException {
        List<String> sg;
        String sgStr = this.serverGroups.getValue(ctx.getParsedCommandLine());
        if (this.allServerGroups.isPresent(ctx.getParsedCommandLine())) {
            if (sgStr != null) {
                throw new CommandFormatException("Only one of " + this.allServerGroups.getFullName() + " or " + this.serverGroups.getFullName() + " can be specified at a time.");
            }
            sg = Util.getServerGroups(ctx.getModelControllerClient());
            if (sg.isEmpty()) {
                throw new CommandFormatException("No server group is available.");
            }
        } else {
            if (sgStr == null) {
                throw new CommandFormatException(this.serverGroups.getFullName() + " or " + this.allServerGroups.getFullName() + " must be specified.");
            }
            sg = Arrays.asList(sgStr.split(",+"));
            if (sg.isEmpty()) {
                throw new CommandFormatException(this.serverGroups.getFullName() + " is missing value.");
            }
        }
        return sg;
    }

    protected void addAddRedeployLinksSteps(CommandContext ctx, ModelNode steps, String overlay, String serverGroup, String[] links, boolean regexp) throws CommandLineException {
        for (String link : links) {
            ModelNode addr;
            ModelNode step;
            List<String> matchingDeployments;
            ModelNode op = new ModelNode();
            ModelNode address = op.get("address");
            if (serverGroup != null) {
                address.add("server-group", serverGroup);
            }
            address.add("deployment-overlay", overlay);
            address.add("deployment", link);
            op.get("operation").set(ADD);
            steps.add(op);
            if (!this.redeployAffected.isPresent(ctx.getParsedCommandLine()) || (matchingDeployments = Util.getMatchingDeployments(ctx.getModelControllerClient(), link, serverGroup, true)).isEmpty()) continue;
            if (serverGroup == null) {
                for (String deployment : matchingDeployments) {
                    step = new ModelNode();
                    addr = step.get("address");
                    addr.add("deployment", deployment);
                    step.get("operation").set("redeploy");
                    steps.add(step);
                }
                continue;
            }
            for (String deployment : matchingDeployments) {
                step = new ModelNode();
                addr = step.get("address");
                addr.add("server-group", serverGroup);
                addr.add("deployment", deployment);
                step.get("operation").set("redeploy");
                steps.add(step);
            }
        }
    }

    protected void addRemoveRedeployLinksSteps(ModelControllerClient client, ModelNode steps, String overlay, String sgName, List<String> specifiedLinks, boolean removeLinks, byte redeploy) throws CommandLineException {
        Iterator<String> linkNames;
        ModelNode linkResources = this.loadLinkResources(client, overlay, sgName);
        if (linkResources == null) {
            return;
        }
        if (linkResources.keys().isEmpty()) {
            return;
        }
        if (removeLinks) {
            linkNames = specifiedLinks != null ? specifiedLinks.iterator() : linkResources.keys().iterator();
            while (linkNames.hasNext()) {
                String linkName = linkNames.next();
                ModelNode op = new ModelNode();
                ModelNode addr = op.get("address");
                if (sgName != null) {
                    addr.add("server-group", sgName);
                }
                addr.add("deployment-overlay", overlay);
                addr.add("deployment", linkName);
                op.get("operation").set(REMOVE);
                steps.add(op);
            }
            if (specifiedLinks == null && sgName != null) {
                ModelNode op = new ModelNode();
                ModelNode addr = op.get("address");
                addr.add("server-group", sgName);
                addr.add("deployment-overlay", overlay);
                op.get("operation").set(REMOVE);
                steps.add(op);
            }
        }
        if (redeploy == 2) {
            linkNames = linkResources.keys().iterator();
        } else if (redeploy == 1 && specifiedLinks != null) {
            linkNames = specifiedLinks.iterator();
        } else {
            return;
        }
        List<String> sgDeployments = Util.getDeployments(client, sgName);
        while (linkNames.hasNext() && !sgDeployments.isEmpty()) {
            String linkName = linkNames.next();
            ModelNode link = linkResources.get(linkName);
            if (!link.isDefined()) {
                StringBuilder buf = new StringBuilder();
                buf.append(linkName);
                buf.append(" not found among the registered links ");
                if (sgName != null) {
                    buf.append("for server group ").append(sgName).append(' ');
                }
                buf.append(linkResources.keys());
                throw new CommandFormatException(buf.toString());
            }
            this.addRedeploySteps(steps, sgName, linkName, link, sgDeployments);
        }
    }

    protected void addRedeploySteps(ModelNode steps, String serverGroup, String linkName, ModelNode link, List<String> remainingDeployments) {
        Pattern pattern = Pattern.compile(Util.wildcardToJavaRegex(linkName));
        Iterator<String> i = remainingDeployments.iterator();
        while (i.hasNext()) {
            String deployment = i.next();
            if (!pattern.matcher(deployment).matches()) continue;
            i.remove();
            this.addRedeployStep(steps, deployment, serverGroup);
        }
    }

    protected void assertNotPresent(ArgumentWithoutValue arg, ParsedCommandLine args) throws CommandFormatException {
        if (arg.isPresent(args)) {
            throw new CommandFormatException(arg.getFullName() + " is not allowed with action '" + this.action.getValue(args) + "'");
        }
    }

    protected List<String> filterLinks(ModelNode linkResources) {
        if (linkResources != null && !linkResources.keys().isEmpty()) {
            List<Property> links = linkResources.asPropertyList();
            ArrayList<String> linkNames = new ArrayList<String>(links.size());
            for (Property link : links) {
                linkNames.add(link.getName());
            }
            return linkNames;
        }
        return Collections.emptyList();
    }
}

