/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.datasources;

import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import org.jboss.as.connector.subsystems.datasources.Constants;
import org.jboss.as.connector.subsystems.datasources.ModifiableDataSource;
import org.jboss.as.connector.subsystems.datasources.ModifiableXaDataSource;
import org.jboss.as.connector.util.ModelNodeUtil;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.jca.common.api.metadata.Defaults;
import org.jboss.jca.common.api.metadata.common.Capacity;
import org.jboss.jca.common.api.metadata.common.Credential;
import org.jboss.jca.common.api.metadata.common.Extension;
import org.jboss.jca.common.api.metadata.common.FlushStrategy;
import org.jboss.jca.common.api.metadata.common.Recovery;
import org.jboss.jca.common.api.metadata.ds.DsPool;
import org.jboss.jca.common.api.metadata.ds.DsSecurity;
import org.jboss.jca.common.api.metadata.ds.DsXaPool;
import org.jboss.jca.common.api.metadata.ds.Statement;
import org.jboss.jca.common.api.metadata.ds.TimeOut;
import org.jboss.jca.common.api.metadata.ds.TransactionIsolation;
import org.jboss.jca.common.api.metadata.ds.Validation;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.jca.common.metadata.common.CredentialImpl;
import org.jboss.jca.common.metadata.ds.DsPoolImpl;
import org.jboss.jca.common.metadata.ds.DsSecurityImpl;
import org.jboss.jca.common.metadata.ds.DsXaPoolImpl;
import org.jboss.jca.common.metadata.ds.StatementImpl;
import org.jboss.jca.common.metadata.ds.TimeOutImpl;
import org.jboss.jca.common.metadata.ds.ValidationImpl;

class DataSourceModelNodeUtil {
    DataSourceModelNodeUtil() {
    }

    static ModifiableDataSource from(OperationContext operationContext, ModelNode dataSourceNode, String dsName) throws OperationFailedException, ValidateException {
        Map<String, String> connectionProperties = Collections.emptyMap();
        String connectionUrl = ModelNodeUtil.getResolvedStringIfSetOrGetDefault(operationContext, dataSourceNode, Constants.CONNECTION_URL);
        String driverClass = ModelNodeUtil.getResolvedStringIfSetOrGetDefault(operationContext, dataSourceNode, Constants.DRIVER_CLASS);
        String dataSourceClass = ModelNodeUtil.getResolvedStringIfSetOrGetDefault(operationContext, dataSourceNode, Constants.DATASOURCE_CLASS);
        String jndiName = ModelNodeUtil.getResolvedStringIfSetOrGetDefault(operationContext, dataSourceNode, Constants.JNDI_NAME);
        String driver = ModelNodeUtil.getResolvedStringIfSetOrGetDefault(operationContext, dataSourceNode, Constants.DATASOURCE_DRIVER);
        String newConnectionSql = ModelNodeUtil.getResolvedStringIfSetOrGetDefault(operationContext, dataSourceNode, Constants.NEW_CONNECTION_SQL);
        String poolName = dsName;
        String urlDelimiter = ModelNodeUtil.getResolvedStringIfSetOrGetDefault(operationContext, dataSourceNode, Constants.URL_DELIMITER);
        String urlSelectorStrategyClassName = ModelNodeUtil.getResolvedStringIfSetOrGetDefault(operationContext, dataSourceNode, Constants.URL_SELECTOR_STRATEGY_CLASS_NAME);
        boolean useJavaContext = ModelNodeUtil.getBooleanIfSetOrGetDefault(operationContext, dataSourceNode, Constants.USE_JAVA_CONTEXT);
        boolean enabled = ModelNodeUtil.getBooleanIfSetOrGetDefault(operationContext, dataSourceNode, Constants.ENABLED);
        boolean connectable = ModelNodeUtil.getBooleanIfSetOrGetDefault(operationContext, dataSourceNode, Constants.CONNECTABLE);
        Boolean tracking = ModelNodeUtil.getBooleanIfSetOrGetDefault(operationContext, dataSourceNode, Constants.TRACKING);
        Boolean enlistmentTrace = ModelNodeUtil.getBooleanIfSetOrGetDefault(operationContext, dataSourceNode, Constants.ENLISTMENT_TRACE);
        String mcp = ModelNodeUtil.getResolvedStringIfSetOrGetDefault(operationContext, dataSourceNode, Constants.MCP);
        boolean jta = ModelNodeUtil.getBooleanIfSetOrGetDefault(operationContext, dataSourceNode, Constants.JTA);
        Integer maxPoolSize = ModelNodeUtil.getIntIfSetOrGetDefault(operationContext, dataSourceNode, org.jboss.as.connector.subsystems.common.pool.Constants.MAX_POOL_SIZE);
        Integer minPoolSize = ModelNodeUtil.getIntIfSetOrGetDefault(operationContext, dataSourceNode, org.jboss.as.connector.subsystems.common.pool.Constants.MIN_POOL_SIZE);
        Integer initialPoolSize = ModelNodeUtil.getIntIfSetOrGetDefault(operationContext, dataSourceNode, org.jboss.as.connector.subsystems.common.pool.Constants.INITIAL_POOL_SIZE);
        boolean prefill = ModelNodeUtil.getBooleanIfSetOrGetDefault(operationContext, dataSourceNode, org.jboss.as.connector.subsystems.common.pool.Constants.POOL_PREFILL);
        boolean useStrictMin = ModelNodeUtil.getBooleanIfSetOrGetDefault(operationContext, dataSourceNode, org.jboss.as.connector.subsystems.common.pool.Constants.POOL_USE_STRICT_MIN);
        String flushStrategyString = ModelNodeUtil.getResolvedStringIfSetOrGetDefault(operationContext, dataSourceNode, org.jboss.as.connector.subsystems.common.pool.Constants.POOL_FLUSH_STRATEGY);
        FlushStrategy flushStrategy = FlushStrategy.forName((String)flushStrategyString);
        Boolean allowMultipleUsers = ModelNodeUtil.getBooleanIfSetOrGetDefault(operationContext, dataSourceNode, Constants.ALLOW_MULTIPLE_USERS);
        Extension incrementer = ModelNodeUtil.extractExtension(operationContext, dataSourceNode, org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_INCREMENTER_CLASS, org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_INCREMENTER_PROPERTIES);
        Extension decrementer = ModelNodeUtil.extractExtension(operationContext, dataSourceNode, org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_DECREMENTER_CLASS, org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_DECREMENTER_PROPERTIES);
        Capacity capacity = new Capacity(incrementer, decrementer);
        Extension connectionListener = ModelNodeUtil.extractExtension(operationContext, dataSourceNode, Constants.CONNECTION_LISTENER_CLASS, Constants.CONNECTION_LISTENER_PROPERTIES);
        DsPoolImpl pool = new DsPoolImpl(minPoolSize, initialPoolSize, maxPoolSize, Boolean.valueOf(prefill), Boolean.valueOf(useStrictMin), flushStrategy, allowMultipleUsers, capacity, connectionListener);
        String username = ModelNodeUtil.getResolvedStringIfSetOrGetDefault(operationContext, dataSourceNode, Constants.USERNAME);
        String password = ModelNodeUtil.getResolvedStringIfSetOrGetDefault(operationContext, dataSourceNode, Constants.PASSWORD);
        String securityDomain = ModelNodeUtil.getResolvedStringIfSetOrGetDefault(operationContext, dataSourceNode, Constants.SECURITY_DOMAIN);
        Extension reauthPlugin = ModelNodeUtil.extractExtension(operationContext, dataSourceNode, Constants.REAUTH_PLUGIN_CLASSNAME, Constants.REAUTHPLUGIN_PROPERTIES);
        DsSecurityImpl security = new DsSecurityImpl(username, password, securityDomain, reauthPlugin);
        boolean sharePreparedStatements = ModelNodeUtil.getBooleanIfSetOrGetDefault(operationContext, dataSourceNode, Constants.SHARE_PREPARED_STATEMENTS);
        Long preparedStatementsCacheSize = ModelNodeUtil.getLongIfSetOrGetDefault(operationContext, dataSourceNode, Constants.PREPARED_STATEMENTS_CACHE_SIZE);
        String trackStatementsString = ModelNodeUtil.getResolvedStringIfSetOrGetDefault(operationContext, dataSourceNode, Constants.TRACK_STATEMENTS);
        Statement.TrackStatementsEnum trackStatements = Statement.TrackStatementsEnum.valueOf((String)trackStatementsString.toUpperCase(Locale.ENGLISH));
        StatementImpl statement = new StatementImpl(Boolean.valueOf(sharePreparedStatements), preparedStatementsCacheSize, trackStatements);
        Integer allocationRetry = ModelNodeUtil.getIntIfSetOrGetDefault(operationContext, dataSourceNode, Constants.ALLOCATION_RETRY);
        Long allocationRetryWaitMillis = ModelNodeUtil.getLongIfSetOrGetDefault(operationContext, dataSourceNode, Constants.ALLOCATION_RETRY_WAIT_MILLIS);
        Long blockingTimeoutMillis = ModelNodeUtil.getLongIfSetOrGetDefault(operationContext, dataSourceNode, org.jboss.as.connector.subsystems.common.pool.Constants.BLOCKING_TIMEOUT_WAIT_MILLIS);
        Long idleTimeoutMinutes = ModelNodeUtil.getLongIfSetOrGetDefault(operationContext, dataSourceNode, org.jboss.as.connector.subsystems.common.pool.Constants.IDLETIMEOUTMINUTES);
        Long queryTimeout = ModelNodeUtil.getLongIfSetOrGetDefault(operationContext, dataSourceNode, Constants.QUERY_TIMEOUT);
        Integer xaResourceTimeout = ModelNodeUtil.getIntIfSetOrGetDefault(operationContext, dataSourceNode, Constants.XA_RESOURCE_TIMEOUT);
        Long useTryLock = ModelNodeUtil.getLongIfSetOrGetDefault(operationContext, dataSourceNode, Constants.USE_TRY_LOCK);
        boolean setTxQueryTimeout = ModelNodeUtil.getBooleanIfSetOrGetDefault(operationContext, dataSourceNode, Constants.SET_TX_QUERY_TIMEOUT);
        TimeOutImpl timeOut = new TimeOutImpl(blockingTimeoutMillis, idleTimeoutMinutes, allocationRetry, allocationRetryWaitMillis, xaResourceTimeout, Boolean.valueOf(setTxQueryTimeout), queryTimeout, useTryLock);
        String transactionIsolationString = ModelNodeUtil.getResolvedStringIfSetOrGetDefault(operationContext, dataSourceNode, Constants.TRANSACTION_ISOLATION);
        TransactionIsolation transactionIsolation = null;
        if (transactionIsolationString != null && (transactionIsolation = TransactionIsolation.forName((String)transactionIsolationString)) == null) {
            transactionIsolation = TransactionIsolation.customLevel((String)transactionIsolationString);
        }
        String checkValidConnectionSql = ModelNodeUtil.getResolvedStringIfSetOrGetDefault(operationContext, dataSourceNode, Constants.CHECK_VALID_CONNECTION_SQL);
        Extension exceptionSorter = ModelNodeUtil.extractExtension(operationContext, dataSourceNode, Constants.EXCEPTION_SORTER_CLASSNAME, Constants.EXCEPTION_SORTER_PROPERTIES);
        Extension staleConnectionChecker = ModelNodeUtil.extractExtension(operationContext, dataSourceNode, Constants.STALE_CONNECTION_CHECKER_CLASSNAME, Constants.STALE_CONNECTION_CHECKER_PROPERTIES);
        Extension validConnectionChecker = ModelNodeUtil.extractExtension(operationContext, dataSourceNode, Constants.VALID_CONNECTION_CHECKER_CLASSNAME, Constants.VALID_CONNECTION_CHECKER_PROPERTIES);
        Long backgroundValidationMillis = ModelNodeUtil.getLongIfSetOrGetDefault(operationContext, dataSourceNode, org.jboss.as.connector.subsystems.common.pool.Constants.BACKGROUNDVALIDATIONMILLIS);
        Boolean backgroundValidation = ModelNodeUtil.getBooleanIfSetOrGetDefault(operationContext, dataSourceNode, org.jboss.as.connector.subsystems.common.pool.Constants.BACKGROUNDVALIDATION);
        boolean useFastFail = ModelNodeUtil.getBooleanIfSetOrGetDefault(operationContext, dataSourceNode, org.jboss.as.connector.subsystems.common.pool.Constants.USE_FAST_FAIL);
        Boolean validateOnMatch = ModelNodeUtil.getBooleanIfSetOrGetDefault(operationContext, dataSourceNode, Constants.VALIDATE_ON_MATCH);
        boolean spy = ModelNodeUtil.getBooleanIfSetOrGetDefault(operationContext, dataSourceNode, Constants.SPY);
        boolean useCcm = ModelNodeUtil.getBooleanIfSetOrGetDefault(operationContext, dataSourceNode, Constants.USE_CCM);
        ValidationImpl validation = new ValidationImpl(backgroundValidation, backgroundValidationMillis, Boolean.valueOf(useFastFail), validConnectionChecker, checkValidConnectionSql, validateOnMatch, staleConnectionChecker, exceptionSorter);
        return new ModifiableDataSource(connectionUrl, driverClass, dataSourceClass, driver, transactionIsolation, connectionProperties, (TimeOut)timeOut, (DsSecurity)security, (Statement)statement, (Validation)validation, urlDelimiter, urlSelectorStrategyClassName, newConnectionSql, useJavaContext, poolName, enabled, jndiName, spy, useCcm, jta, connectable, tracking, mcp, enlistmentTrace, (DsPool)pool);
    }

    static ModifiableXaDataSource xaFrom(OperationContext operationContext, ModelNode dataSourceNode, String dsName) throws OperationFailedException, ValidateException {
        Map<String, String> xaDataSourceProperty = Collections.emptyMap();
        String xaDataSourceClass = ModelNodeUtil.getResolvedStringIfSetOrGetDefault(operationContext, dataSourceNode, Constants.XA_DATASOURCE_CLASS);
        String jndiName = ModelNodeUtil.getResolvedStringIfSetOrGetDefault(operationContext, dataSourceNode, Constants.JNDI_NAME);
        String module = ModelNodeUtil.getResolvedStringIfSetOrGetDefault(operationContext, dataSourceNode, Constants.DATASOURCE_DRIVER);
        String newConnectionSql = ModelNodeUtil.getResolvedStringIfSetOrGetDefault(operationContext, dataSourceNode, Constants.NEW_CONNECTION_SQL);
        String poolName = dsName;
        String urlDelimiter = ModelNodeUtil.getResolvedStringIfSetOrGetDefault(operationContext, dataSourceNode, Constants.URL_DELIMITER);
        String urlSelectorStrategyClassName = ModelNodeUtil.getResolvedStringIfSetOrGetDefault(operationContext, dataSourceNode, Constants.URL_SELECTOR_STRATEGY_CLASS_NAME);
        Boolean useJavaContext = ModelNodeUtil.getBooleanIfSetOrGetDefault(operationContext, dataSourceNode, Constants.USE_JAVA_CONTEXT);
        Boolean enabled = ModelNodeUtil.getBooleanIfSetOrGetDefault(operationContext, dataSourceNode, Constants.ENABLED);
        boolean connectable = ModelNodeUtil.getBooleanIfSetOrGetDefault(operationContext, dataSourceNode, Constants.CONNECTABLE);
        Boolean tracking = ModelNodeUtil.getBooleanIfSetOrGetDefault(operationContext, dataSourceNode, Constants.TRACKING);
        Boolean enlistmentTrace = ModelNodeUtil.getBooleanIfSetOrGetDefault(operationContext, dataSourceNode, Constants.ENLISTMENT_TRACE);
        String mcp = ModelNodeUtil.getResolvedStringIfSetOrGetDefault(operationContext, dataSourceNode, Constants.MCP);
        Integer maxPoolSize = ModelNodeUtil.getIntIfSetOrGetDefault(operationContext, dataSourceNode, org.jboss.as.connector.subsystems.common.pool.Constants.MAX_POOL_SIZE);
        Integer minPoolSize = ModelNodeUtil.getIntIfSetOrGetDefault(operationContext, dataSourceNode, org.jboss.as.connector.subsystems.common.pool.Constants.MIN_POOL_SIZE);
        Integer initialPoolSize = ModelNodeUtil.getIntIfSetOrGetDefault(operationContext, dataSourceNode, org.jboss.as.connector.subsystems.common.pool.Constants.INITIAL_POOL_SIZE);
        Boolean prefill = ModelNodeUtil.getBooleanIfSetOrGetDefault(operationContext, dataSourceNode, org.jboss.as.connector.subsystems.common.pool.Constants.POOL_PREFILL);
        Boolean useStrictMin = ModelNodeUtil.getBooleanIfSetOrGetDefault(operationContext, dataSourceNode, org.jboss.as.connector.subsystems.common.pool.Constants.POOL_USE_STRICT_MIN);
        Boolean interleaving = ModelNodeUtil.getBooleanIfSetOrGetDefault(operationContext, dataSourceNode, Constants.INTERLEAVING);
        Boolean noTxSeparatePool = ModelNodeUtil.getBooleanIfSetOrGetDefault(operationContext, dataSourceNode, Constants.NO_TX_SEPARATE_POOL);
        Boolean padXid = ModelNodeUtil.getBooleanIfSetOrGetDefault(operationContext, dataSourceNode, Constants.PAD_XID);
        Boolean isSameRmOverride = ModelNodeUtil.getBooleanIfSetOrGetDefault(operationContext, dataSourceNode, Constants.SAME_RM_OVERRIDE);
        Boolean wrapXaDataSource = ModelNodeUtil.getBooleanIfSetOrGetDefault(operationContext, dataSourceNode, Constants.WRAP_XA_RESOURCE);
        String flushStrategyString = ModelNodeUtil.getResolvedStringIfSetOrGetDefault(operationContext, dataSourceNode, org.jboss.as.connector.subsystems.common.pool.Constants.POOL_FLUSH_STRATEGY);
        FlushStrategy flushStrategy = FlushStrategy.forName((String)flushStrategyString);
        Boolean allowMultipleUsers = ModelNodeUtil.getBooleanIfSetOrGetDefault(operationContext, dataSourceNode, Constants.ALLOW_MULTIPLE_USERS);
        Extension incrementer = ModelNodeUtil.extractExtension(operationContext, dataSourceNode, org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_INCREMENTER_CLASS, org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_INCREMENTER_PROPERTIES);
        Extension decrementer = ModelNodeUtil.extractExtension(operationContext, dataSourceNode, org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_DECREMENTER_CLASS, org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_DECREMENTER_PROPERTIES);
        Capacity capacity = new Capacity(incrementer, decrementer);
        Extension connectionListener = ModelNodeUtil.extractExtension(operationContext, dataSourceNode, Constants.CONNECTION_LISTENER_CLASS, Constants.CONNECTION_LISTENER_PROPERTIES);
        DsXaPoolImpl xaPool = new DsXaPoolImpl(minPoolSize, initialPoolSize, maxPoolSize, prefill, useStrictMin, flushStrategy, isSameRmOverride, interleaving, padXid, wrapXaDataSource, noTxSeparatePool, allowMultipleUsers, capacity, connectionListener);
        String username = ModelNodeUtil.getResolvedStringIfSetOrGetDefault(operationContext, dataSourceNode, Constants.USERNAME);
        String password = ModelNodeUtil.getResolvedStringIfSetOrGetDefault(operationContext, dataSourceNode, Constants.PASSWORD);
        String securityDomain = ModelNodeUtil.getResolvedStringIfSetOrGetDefault(operationContext, dataSourceNode, Constants.SECURITY_DOMAIN);
        Extension reauthPlugin = ModelNodeUtil.extractExtension(operationContext, dataSourceNode, Constants.REAUTH_PLUGIN_CLASSNAME, Constants.REAUTHPLUGIN_PROPERTIES);
        DsSecurityImpl security = new DsSecurityImpl(username, password, securityDomain, reauthPlugin);
        Boolean sharePreparedStatements = dataSourceNode.hasDefined(Constants.SHARE_PREPARED_STATEMENTS.getName()) ? dataSourceNode.get(Constants.SHARE_PREPARED_STATEMENTS.getName()).asBoolean() : Defaults.SHARE_PREPARED_STATEMENTS.booleanValue();
        Long preparedStatementsCacheSize = ModelNodeUtil.getLongIfSetOrGetDefault(operationContext, dataSourceNode, Constants.PREPARED_STATEMENTS_CACHE_SIZE);
        String trackStatementsString = ModelNodeUtil.getResolvedStringIfSetOrGetDefault(operationContext, dataSourceNode, Constants.TRACK_STATEMENTS);
        Statement.TrackStatementsEnum trackStatements = Statement.TrackStatementsEnum.valueOf((String)trackStatementsString.toUpperCase(Locale.ENGLISH));
        StatementImpl statement = new StatementImpl(sharePreparedStatements, preparedStatementsCacheSize, trackStatements);
        Integer allocationRetry = ModelNodeUtil.getIntIfSetOrGetDefault(operationContext, dataSourceNode, Constants.ALLOCATION_RETRY);
        Long allocationRetryWaitMillis = ModelNodeUtil.getLongIfSetOrGetDefault(operationContext, dataSourceNode, Constants.ALLOCATION_RETRY_WAIT_MILLIS);
        Long blockingTimeoutMillis = ModelNodeUtil.getLongIfSetOrGetDefault(operationContext, dataSourceNode, org.jboss.as.connector.subsystems.common.pool.Constants.BLOCKING_TIMEOUT_WAIT_MILLIS);
        Long idleTimeoutMinutes = ModelNodeUtil.getLongIfSetOrGetDefault(operationContext, dataSourceNode, org.jboss.as.connector.subsystems.common.pool.Constants.IDLETIMEOUTMINUTES);
        Long queryTimeout = ModelNodeUtil.getLongIfSetOrGetDefault(operationContext, dataSourceNode, Constants.QUERY_TIMEOUT);
        Integer xaResourceTimeout = ModelNodeUtil.getIntIfSetOrGetDefault(operationContext, dataSourceNode, Constants.XA_RESOURCE_TIMEOUT);
        Long useTryLock = ModelNodeUtil.getLongIfSetOrGetDefault(operationContext, dataSourceNode, Constants.USE_TRY_LOCK);
        Boolean setTxQueryTimeout = ModelNodeUtil.getBooleanIfSetOrGetDefault(operationContext, dataSourceNode, Constants.SET_TX_QUERY_TIMEOUT);
        TimeOutImpl timeOut = new TimeOutImpl(blockingTimeoutMillis, idleTimeoutMinutes, allocationRetry, allocationRetryWaitMillis, xaResourceTimeout, setTxQueryTimeout, queryTimeout, useTryLock);
        String transactionIsolationString = ModelNodeUtil.getResolvedStringIfSetOrGetDefault(operationContext, dataSourceNode, Constants.TRANSACTION_ISOLATION);
        TransactionIsolation transactionIsolation = null;
        if (transactionIsolationString != null && (transactionIsolation = TransactionIsolation.forName((String)transactionIsolationString)) == null) {
            transactionIsolation = TransactionIsolation.customLevel((String)transactionIsolationString);
        }
        String checkValidConnectionSql = ModelNodeUtil.getResolvedStringIfSetOrGetDefault(operationContext, dataSourceNode, Constants.CHECK_VALID_CONNECTION_SQL);
        Extension exceptionSorter = ModelNodeUtil.extractExtension(operationContext, dataSourceNode, Constants.EXCEPTION_SORTER_CLASSNAME, Constants.EXCEPTION_SORTER_PROPERTIES);
        Extension staleConnectionChecker = ModelNodeUtil.extractExtension(operationContext, dataSourceNode, Constants.STALE_CONNECTION_CHECKER_CLASSNAME, Constants.STALE_CONNECTION_CHECKER_PROPERTIES);
        Extension validConnectionChecker = ModelNodeUtil.extractExtension(operationContext, dataSourceNode, Constants.VALID_CONNECTION_CHECKER_CLASSNAME, Constants.VALID_CONNECTION_CHECKER_PROPERTIES);
        Long backgroundValidationMillis = ModelNodeUtil.getLongIfSetOrGetDefault(operationContext, dataSourceNode, org.jboss.as.connector.subsystems.common.pool.Constants.BACKGROUNDVALIDATIONMILLIS);
        Boolean backgroundValidation = ModelNodeUtil.getBooleanIfSetOrGetDefault(operationContext, dataSourceNode, org.jboss.as.connector.subsystems.common.pool.Constants.BACKGROUNDVALIDATION);
        boolean useFastFail = ModelNodeUtil.getBooleanIfSetOrGetDefault(operationContext, dataSourceNode, org.jboss.as.connector.subsystems.common.pool.Constants.USE_FAST_FAIL);
        Boolean validateOnMatch = ModelNodeUtil.getBooleanIfSetOrGetDefault(operationContext, dataSourceNode, Constants.VALIDATE_ON_MATCH);
        Boolean spy = ModelNodeUtil.getBooleanIfSetOrGetDefault(operationContext, dataSourceNode, Constants.SPY);
        Boolean useCcm = ModelNodeUtil.getBooleanIfSetOrGetDefault(operationContext, dataSourceNode, Constants.USE_CCM);
        ValidationImpl validation = new ValidationImpl(backgroundValidation, backgroundValidationMillis, Boolean.valueOf(useFastFail), validConnectionChecker, checkValidConnectionSql, validateOnMatch, staleConnectionChecker, exceptionSorter);
        String recoveryUsername = ModelNodeUtil.getResolvedStringIfSetOrGetDefault(operationContext, dataSourceNode, Constants.RECOVERY_USERNAME);
        String recoveryPassword = ModelNodeUtil.getResolvedStringIfSetOrGetDefault(operationContext, dataSourceNode, Constants.RECOVERY_PASSWORD);
        String recoverySecurityDomain = ModelNodeUtil.getResolvedStringIfSetOrGetDefault(operationContext, dataSourceNode, Constants.RECOVERY_SECURITY_DOMAIN);
        Boolean noRecovery = ModelNodeUtil.getBooleanIfSetOrGetDefault(operationContext, dataSourceNode, Constants.NO_RECOVERY);
        String urlProperty = ModelNodeUtil.getResolvedStringIfSetOrGetDefault(operationContext, dataSourceNode, Constants.URL_PROPERTY);
        Recovery recovery = null;
        if (recoveryUsername != null && recoveryPassword != null || recoverySecurityDomain != null || noRecovery != null) {
            CredentialImpl credential = null;
            if (recoveryUsername != null && recoveryPassword != null || recoverySecurityDomain != null) {
                credential = new CredentialImpl(recoveryUsername, recoveryPassword, recoverySecurityDomain);
            }
            Extension recoverPlugin = ModelNodeUtil.extractExtension(operationContext, dataSourceNode, Constants.RECOVER_PLUGIN_CLASSNAME, Constants.RECOVER_PLUGIN_PROPERTIES);
            if (noRecovery == null) {
                noRecovery = Boolean.FALSE;
            }
            recovery = new Recovery((Credential)credential, recoverPlugin, noRecovery);
        }
        return new ModifiableXaDataSource(transactionIsolation, (TimeOut)timeOut, (DsSecurity)security, (Statement)statement, (Validation)validation, urlDelimiter, urlProperty, urlSelectorStrategyClassName, useJavaContext, poolName, enabled, jndiName, spy, useCcm, connectable, tracking, mcp, enlistmentTrace, xaDataSourceProperty, xaDataSourceClass, module, newConnectionSql, (DsXaPool)xaPool, recovery);
    }
}

