/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.Future;
import javax.transaction.UserTransaction;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.client.EJBClientContextIdentifier;
import org.jboss.ejb.client.EJBClientTransactionContext;
import org.jboss.ejb.client.EJBInvocationHandler;
import org.jboss.ejb.client.EJBLocator;
import org.jboss.ejb.client.EJBReceiver;
import org.jboss.ejb.client.EJBReceiverContext;
import org.jboss.ejb.client.FinishedFuture;
import org.jboss.ejb.client.Logs;
import org.jboss.ejb.client.StatefulEJBLocator;
import org.jboss.ejb.client.Version;

public final class EJBClient {
    private static final Logs log = Logs.MAIN;
    private static final ThreadLocal<Future<?>> FUTURE_RESULT;

    private EJBClient() {
    }

    public static <T> T asynchronous(T proxy) throws IllegalArgumentException {
        InvocationHandler invocationHandler = Proxy.getInvocationHandler(proxy);
        if (invocationHandler instanceof EJBInvocationHandler) {
            EJBInvocationHandler remoteInvocationHandler = (EJBInvocationHandler)invocationHandler;
            if (remoteInvocationHandler.isAsyncHandler()) {
                return proxy;
            }
            return (T)Proxy.newProxyInstance(proxy.getClass().getClassLoader(), proxy.getClass().getInterfaces(), remoteInvocationHandler.getAsyncHandler());
        }
        throw log.unknownProxy(proxy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> Future<T> getFutureResult(T operation) throws IllegalStateException {
        if (operation != null) {
            return new FinishedFuture<T>(operation);
        }
        ThreadLocal<Future<?>> futureResult = FUTURE_RESULT;
        try {
            Future<?> future = futureResult.get();
            if (future == null) {
                throw log.noAsyncInProgress();
            }
            Future<?> future2 = future;
            return future2;
        }
        finally {
            futureResult.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Future<?> getFutureResult() throws IllegalStateException {
        ThreadLocal<Future<?>> futureResult = FUTURE_RESULT;
        try {
            Future<?> future = futureResult.get();
            if (future == null) {
                throw log.noAsyncInProgress();
            }
            Future<?> future2 = future;
            return future2;
        }
        finally {
            futureResult.remove();
        }
    }

    static void setFutureResult(Future<?> future) {
        FUTURE_RESULT.set(future);
    }

    public static <T> T createProxy(EJBLocator<T> locator) throws IllegalArgumentException {
        return EJBClient.createProxy(locator, null);
    }

    public static <T> T createProxy(EJBLocator<T> locator, EJBClientContextIdentifier identifier) {
        if (locator == null) {
            throw Logs.MAIN.paramCannotBeNull("EJB locator");
        }
        return locator.createProxyInstance(new EJBInvocationHandler<T>(identifier, locator));
    }

    public static boolean isEJBProxy(Object object) {
        return object != null && Proxy.isProxyClass(object.getClass()) && Proxy.getInvocationHandler(object) instanceof EJBInvocationHandler;
    }

    public static <T> StatefulEJBLocator<T> createSession(Class<T> viewType, String appName, String moduleName, String beanName, String distinctName) throws Exception {
        return EJBClient.createSession(null, viewType, appName, moduleName, beanName, distinctName);
    }

    public static <T> StatefulEJBLocator<T> createSession(EJBClientContextIdentifier ejbClientContextIdentifier, Class<T> viewType, String appName, String moduleName, String beanName, String distinctName) throws Exception {
        EJBClientContext clientContext = ejbClientContextIdentifier != null ? EJBClientContext.require(ejbClientContextIdentifier) : EJBClientContext.requireCurrent();
        return EJBClient.createSessionWithPossibleRetries(clientContext, new HashSet<String>(), viewType, appName, moduleName, beanName, distinctName);
    }

    private static <T> StatefulEJBLocator<T> createSessionWithPossibleRetries(EJBClientContext clientContext, Collection<String> excludedNodeNames, Class<T> viewType, String appName, String moduleName, String beanName, String distinctName) throws Exception {
        EJBReceiver ejbReceiver = clientContext.requireEJBReceiver(excludedNodeNames, appName, moduleName, distinctName);
        EJBReceiverContext receiverContext = clientContext.requireEJBReceiverContext(ejbReceiver);
        try {
            return ejbReceiver.openSession(receiverContext, viewType, appName, moduleName, distinctName, beanName);
        }
        catch (Exception e) {
            Logs.MAIN.debugf(e, "Retrying session creation which failed on node %s due to:", ejbReceiver.getNodeName());
            excludedNodeNames.add(ejbReceiver.getNodeName());
            return EJBClient.createSessionWithPossibleRetries(clientContext, excludedNodeNames, viewType, appName, moduleName, beanName, distinctName);
        }
    }

    public static <T> EJBLocator<? extends T> getLocatorFor(T proxy) throws IllegalArgumentException {
        return EJBInvocationHandler.forProxy(proxy).getLocator();
    }

    public static EJBClientContextIdentifier getEJBClientContextIdentifierFor(Object proxy) throws IllegalArgumentException {
        return EJBInvocationHandler.forProxy(proxy).getEjbClientContextIdentifier();
    }

    public static UserTransaction getUserTransaction(String targetNodeName) {
        return EJBClientTransactionContext.requireCurrent().getUserTransaction(targetNodeName);
    }

    static {
        log.greeting(Version.getVersionString());
        FUTURE_RESULT = new ThreadLocal();
    }
}

