/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.config;

public enum ConfigurationKey {
    CONCURRENT_DEPLOYMENT("org.jboss.weld.bootstrap.concurrentDeployment", true),
    PRELOADER_THREAD_POOL_SIZE("org.jboss.weld.bootstrap.preloaderThreadPoolSize", Math.max(1, Runtime.getRuntime().availableProcessors() - 1)),
    NON_PORTABLE_MODE("org.jboss.weld.nonPortableMode", false),
    EXECUTOR_THREAD_POOL_SIZE("org.jboss.weld.executor.threadPoolSize", Runtime.getRuntime().availableProcessors()),
    EXECUTOR_THREAD_POOL_DEBUG("org.jboss.weld.executor.threadPoolDebug", false),
    EXECUTOR_THREAD_POOL_TYPE("org.jboss.weld.executor.threadPoolType", ""),
    EXECUTOR_THREAD_POOL_KEEP_ALIVE_TIME("org.jboss.weld.executor.threadPoolKeepAliveTime", 60L),
    RESOLUTION_CACHE_SIZE("org.jboss.weld.resolution.cacheSize", 65536L),
    PROXY_DUMP("org.jboss.weld.proxy.dump", ""),
    RELAXED_CONSTRUCTION("org.jboss.weld.construction.relaxed", false),
    PROXY_INSTANTIATOR("org.jboss.weld.proxy.instantiator", ""),
    PROXY_UNSAFE("org.jboss.weld.proxy.unsafe", false),
    DISABLE_XML_VALIDATION("org.jboss.weld.xml.disableValidating", false),
    INJECTABLE_REFERENCE_OPTIMIZATION("org.jboss.weld.injection.injectableReferenceOptimization", false),
    PROBE_INVOCATION_MONITOR_EXCLUDE_TYPE("org.jboss.weld.probe.invocationMonitor.excludeType", ""),
    PROBE_INVOCATION_MONITOR_SKIP_JAVABEAN_PROPERTIES("org.jboss.weld.probe.invocationMonitor.skipJavaBeanProperties", true),
    PROBE_EVENT_MONITOR_EXCLUDE_TYPE("org.jboss.weld.probe.eventMonitor.excludeType", ""),
    BEAN_IDENTIFIER_INDEX_OPTIMIZATION("org.jboss.weld.serialization.beanIdentifierIndexOptimization", true),
    PROBE_EMBED_INFO_SNIPPET("org.jboss.weld.probe.embedInfoSnippet", true),
    DEFAULT_BEAN_NAMES_FOLLOW_JAVABEAN_RULES("org.jboss.weld.bean.defaultNamesFollowJavaBeanRules", false),
    CONTEXT_ATTRIBUTES_LAZY_FETCH("org.jboss.weld.context.attributes.lazyFetch", true),
    PROBE_JMX_SUPPORT("org.jboss.weld.probe.jmxSupport", false),
    PROBE_EVENT_MONITOR_CONTAINER_LIFECYCLE_EVENTS("org.jboss.weld.probe.eventMonitor.containerLifecycleEvents", false),
    PROBE_ALLOW_REMOTE_ADDRESS("org.jboss.weld.probe.allowRemoteAddress", "127.0.0.1|::1|::1%.+|0:0:0:0:0:0:0:1|0:0:0:0:0:0:0:1%.+");

    private final String key;
    private final Object defaultValue;

    private ConfigurationKey(String key, Object defaultValue) {
        this.key = key;
        if (!ConfigurationKey.isValueTypeSupported(defaultValue.getClass())) {
            throw new IllegalArgumentException("Unsupported value type: " + defaultValue);
        }
        this.defaultValue = defaultValue;
    }

    public String get() {
        return this.key;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isValidValue(Object value) {
        return this.isValidValueType(value.getClass());
    }

    public boolean isValidValueType(Class<?> valueType) {
        return this.defaultValue.getClass().isAssignableFrom(valueType);
    }

    public Object convertValue(String value) {
        if (this.defaultValue instanceof Boolean) {
            return Boolean.valueOf(value);
        }
        if (this.defaultValue instanceof Long) {
            return Long.valueOf(value);
        }
        if (this.defaultValue instanceof Integer) {
            return Integer.valueOf(value);
        }
        return value.toString();
    }

    public static boolean isValueTypeSupported(Class<?> valueType) {
        return valueType.equals(String.class) || valueType.equals(Boolean.class) || valueType.equals(Integer.class) || valueType.equals(Long.class);
    }

    public static ConfigurationKey fromString(String from) {
        for (ConfigurationKey key : ConfigurationKey.values()) {
            if (!key.get().equals(from)) continue;
            return key;
        }
        return null;
    }
}

