/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.utils;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.openssl.PEMWriter;
import org.keycloak.common.util.Base64Url;
import org.keycloak.common.util.CertificateUtils;
import org.keycloak.common.util.PemUtils;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakSessionTask;
import org.keycloak.models.KeycloakTransactionManager;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.ScopeContainerModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserFederationMapperModel;
import org.keycloak.models.UserFederationProviderModel;
import org.keycloak.models.UserModel;
import org.keycloak.representations.idm.CertificateRepresentation;

public final class KeycloakModelUtils {
    private KeycloakModelUtils() {
    }

    public static String generateId() {
        return UUID.randomUUID().toString();
    }

    public static String generateSecret() {
        return KeycloakModelUtils.generateSecret(32);
    }

    public static String generateSecret(int bytes) {
        byte[] buf = new byte[bytes];
        new SecureRandom().nextBytes(buf);
        return Base64Url.encode((byte[])buf);
    }

    public static PublicKey getPublicKey(String publicKeyPem) {
        if (publicKeyPem != null) {
            try {
                return PemUtils.decodePublicKey((String)publicKeyPem);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static X509Certificate getCertificate(String cert) {
        if (cert != null) {
            try {
                return PemUtils.decodeCertificate((String)cert);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static PrivateKey getPrivateKey(String privateKeyPem) {
        if (privateKeyPem != null) {
            try {
                return PemUtils.decodePrivateKey((String)privateKeyPem);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static Key getSecretKey(String secret) {
        return secret != null ? new SecretKeySpec(secret.getBytes(), "HmacSHA256") : null;
    }

    public static String getPemFromKey(Key key) {
        StringWriter writer = new StringWriter();
        PEMWriter pemWriter = new PEMWriter((Writer)writer);
        try {
            pemWriter.writeObject((Object)key);
            pemWriter.flush();
            pemWriter.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String s = writer.toString();
        return PemUtils.removeBeginEnd((String)s);
    }

    public static String getPemFromCertificate(X509Certificate certificate) {
        StringWriter writer = new StringWriter();
        PEMWriter pemWriter = new PEMWriter((Writer)writer);
        try {
            pemWriter.writeObject((Object)certificate);
            pemWriter.flush();
            pemWriter.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String s = writer.toString();
        return PemUtils.removeBeginEnd((String)s);
    }

    public static void generateRealmKeys(RealmModel realm) {
        KeyPair keyPair = null;
        try {
            KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA");
            generator.initialize(2048);
            keyPair = generator.generateKeyPair();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        realm.setPrivateKey(keyPair.getPrivate());
        realm.setPublicKey(keyPair.getPublic());
        X509Certificate certificate = null;
        try {
            certificate = CertificateUtils.generateV1SelfSignedCertificate((KeyPair)keyPair, (String)realm.getName());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        realm.setCertificate(certificate);
        realm.setCodeSecret(KeycloakModelUtils.generateCodeSecret());
    }

    public static void generateRealmCertificate(RealmModel realm) {
        X509Certificate certificate = null;
        try {
            certificate = CertificateUtils.generateV1SelfSignedCertificate((KeyPair)new KeyPair(realm.getPublicKey(), realm.getPrivateKey()), (String)realm.getName());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        realm.setCertificate(certificate);
    }

    public static CertificateRepresentation generateKeyPairCertificate(String subject) {
        KeyPair keyPair = null;
        try {
            KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA");
            generator.initialize(2048);
            keyPair = generator.generateKeyPair();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        X509Certificate certificate = null;
        try {
            certificate = CertificateUtils.generateV1SelfSignedCertificate((KeyPair)keyPair, (String)subject);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        String privateKeyPem = KeycloakModelUtils.getPemFromKey(keyPair.getPrivate());
        String certPem = KeycloakModelUtils.getPemFromCertificate(certificate);
        CertificateRepresentation rep = new CertificateRepresentation();
        rep.setPrivateKey(privateKeyPem);
        rep.setCertificate(certPem);
        return rep;
    }

    public static UserCredentialModel generateSecret(ClientModel client) {
        UserCredentialModel secret = UserCredentialModel.generateSecret();
        client.setSecret(secret.getValue());
        return secret;
    }

    public static String getDefaultClientAuthenticatorType() {
        return "client-secret";
    }

    public static String generateCodeSecret() {
        return UUID.randomUUID().toString();
    }

    public static ClientModel createClient(RealmModel realm, String name) {
        ClientModel app = realm.addClient(name);
        app.setClientAuthenticatorType(KeycloakModelUtils.getDefaultClientAuthenticatorType());
        KeycloakModelUtils.generateSecret(app);
        app.setFullScopeAllowed(true);
        return app;
    }

    public static boolean searchFor(RoleModel role, RoleModel composite, Set<RoleModel> visited) {
        if (visited.contains(composite)) {
            return false;
        }
        visited.add(composite);
        Set<RoleModel> composites = composite.getComposites();
        if (composites.contains(role)) {
            return true;
        }
        for (RoleModel contained : composites) {
            if (!contained.isComposite() || !KeycloakModelUtils.searchFor(role, contained, visited)) continue;
            return true;
        }
        return false;
    }

    public static UserModel findUserByNameOrEmail(KeycloakSession session, RealmModel realm, String username) {
        UserModel user = session.users().getUserByUsername(username, realm);
        if (user == null && username.contains("@")) {
            user = session.users().getUserByEmail(username, realm);
        }
        return user;
    }

    public static void runJobInTransaction(KeycloakSessionFactory factory, KeycloakSessionTask task) {
        KeycloakSession session = factory.create();
        KeycloakTransactionManager tx = session.getTransaction();
        try {
            tx.begin();
            task.run(session);
            if (tx.isActive()) {
                if (tx.getRollbackOnly()) {
                    tx.rollback();
                } else {
                    tx.commit();
                }
            }
        }
        catch (RuntimeException re) {
            if (tx.isActive()) {
                tx.rollback();
            }
            throw re;
        }
        finally {
            session.close();
        }
    }

    public static String getMasterRealmAdminApplicationClientId(String realmName) {
        return realmName + "-realm";
    }

    public static boolean hasRole(Set<RoleModel> roles, RoleModel targetRole) {
        if (roles.contains(targetRole)) {
            return true;
        }
        for (RoleModel mapping : roles) {
            if (!mapping.hasRole(targetRole)) continue;
            return true;
        }
        return false;
    }

    public static boolean isMember(Set<GroupModel> groups, GroupModel targetGroup) {
        if (groups.contains(targetGroup)) {
            return true;
        }
        Iterator<GroupModel> iterator = groups.iterator();
        while (iterator.hasNext()) {
            GroupModel mapping;
            GroupModel child = mapping = iterator.next();
            while (child.getParent() != null) {
                if (child.getParent().equals(targetGroup)) {
                    return true;
                }
                child = child.getParent();
            }
        }
        return false;
    }

    public static void ensureUniqueDisplayName(String displayName, UserFederationProviderModel myProvider, List<UserFederationProviderModel> federationProviders) throws ModelDuplicateException {
        if (displayName != null) {
            for (UserFederationProviderModel federationProvider : federationProviders) {
                if (myProvider != null && (myProvider.equals(federationProvider) || myProvider.getId() != null && myProvider.getId().equals(federationProvider.getId())) || !displayName.equals(federationProvider.getDisplayName())) continue;
                throw new ModelDuplicateException("There is already existing federation provider with display name: " + displayName);
            }
        }
    }

    public static UserFederationProviderModel findUserFederationProviderByDisplayName(String displayName, RealmModel realm) {
        if (displayName == null) {
            return null;
        }
        for (UserFederationProviderModel fedProvider : realm.getUserFederationProviders()) {
            if (!displayName.equals(fedProvider.getDisplayName())) continue;
            return fedProvider;
        }
        return null;
    }

    public static UserFederationProviderModel findUserFederationProviderById(String fedProviderId, RealmModel realm) {
        for (UserFederationProviderModel fedProvider : realm.getUserFederationProviders()) {
            if (!fedProviderId.equals(fedProvider.getId())) continue;
            return fedProvider;
        }
        return null;
    }

    public static UserFederationMapperModel createUserFederationMapperModel(String name, String federationProviderId, String mapperType, String ... config) {
        UserFederationMapperModel mapperModel = new UserFederationMapperModel();
        mapperModel.setName(name);
        mapperModel.setFederationProviderId(federationProviderId);
        mapperModel.setFederationMapperType(mapperType);
        HashMap<String, String> configMap = new HashMap<String, String>();
        String key = null;
        for (String configEntry : config) {
            if (key == null) {
                key = configEntry;
                continue;
            }
            configMap.put(key, configEntry);
            key = null;
        }
        if (key != null) {
            throw new IllegalStateException("Invalid count of arguments for config. Maybe mistake?");
        }
        mapperModel.setConfig(configMap);
        return mapperModel;
    }

    public static String toLowerCaseSafe(String str) {
        return str == null ? null : str.toLowerCase();
    }

    public static void setupOfflineTokens(RealmModel realm) {
        if (realm.getRole("offline_access") == null) {
            RoleModel role = realm.addRole("offline_access");
            role.setDescription("${role_offline-access}");
            role.setScopeParamRequired(true);
            realm.addDefaultRole("offline_access");
        }
    }

    public static void deepFindAuthenticationExecutions(RealmModel realm, AuthenticationFlowModel flow, List<AuthenticationExecutionModel> result) {
        List<AuthenticationExecutionModel> executions = realm.getAuthenticationExecutions(flow.getId());
        for (AuthenticationExecutionModel execution : executions) {
            if (execution.isAuthenticatorFlow()) {
                AuthenticationFlowModel subFlow = realm.getAuthenticationFlowById(execution.getFlowId());
                KeycloakModelUtils.deepFindAuthenticationExecutions(realm, subFlow, result);
                continue;
            }
            result.add(execution);
        }
    }

    public static String resolveFirstAttribute(GroupModel group, String name) {
        String value = group.getFirstAttribute(name);
        if (value != null) {
            return value;
        }
        if (group.getParentId() == null) {
            return null;
        }
        return KeycloakModelUtils.resolveFirstAttribute(group.getParent(), name);
    }

    public static String resolveFirstAttribute(UserModel user, String name) {
        String value = user.getFirstAttribute(name);
        if (value != null) {
            return value;
        }
        for (GroupModel group : user.getGroups()) {
            value = KeycloakModelUtils.resolveFirstAttribute(group, name);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public static List<String> resolveAttribute(GroupModel group, String name) {
        List<String> values = group.getAttribute(name);
        if (values != null && !values.isEmpty()) {
            return values;
        }
        if (group.getParentId() == null) {
            return null;
        }
        return KeycloakModelUtils.resolveAttribute(group.getParent(), name);
    }

    public static List<String> resolveAttribute(UserModel user, String name) {
        List<String> values = user.getAttribute(name);
        if (!values.isEmpty()) {
            return values;
        }
        for (GroupModel group : user.getGroups()) {
            values = KeycloakModelUtils.resolveAttribute(group, name);
            if (values == null) continue;
            return values;
        }
        return Collections.emptyList();
    }

    private static GroupModel findSubGroup(String[] path, int index, GroupModel parent) {
        for (GroupModel group : parent.getSubGroups()) {
            if (!group.getName().equals(path[index])) continue;
            if (path.length == index + 1) {
                return group;
            }
            if (index + 1 < path.length) {
                GroupModel found = KeycloakModelUtils.findSubGroup(path, index + 1, group);
                if (found == null) continue;
                return found;
            }
            return null;
        }
        return null;
    }

    public static GroupModel findGroupByPath(RealmModel realm, String path) {
        String[] split;
        if (path == null) {
            return null;
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if ((split = path.split("/")).length == 0) {
            return null;
        }
        GroupModel found = null;
        for (GroupModel group : realm.getTopLevelGroups()) {
            if (!group.getName().equals(split[0])) continue;
            if (split.length == 1) {
                found = group;
                break;
            }
            if (split.length <= 1 || (found = KeycloakModelUtils.findSubGroup(split, 1, group)) == null) continue;
            break;
        }
        return found;
    }

    public static Set<RoleModel> getClientScopeMappings(ClientModel client, ScopeContainerModel container) {
        Set<RoleModel> mappings = container.getScopeMappings();
        HashSet<RoleModel> result = new HashSet<RoleModel>();
        for (RoleModel role : mappings) {
            RoleContainerModel roleContainer = role.getContainer();
            if (!(roleContainer instanceof ClientModel) || !client.getId().equals(((ClientModel)roleContainer).getId())) continue;
            result.add(role);
        }
        return result;
    }

    public static RoleModel getRoleFromString(RealmModel realm, String roleName) {
        String[] parsedRole = KeycloakModelUtils.parseRole(roleName);
        RoleModel role = null;
        if (parsedRole[0] == null) {
            role = realm.getRole(parsedRole[1]);
        } else {
            ClientModel client = realm.getClientByClientId(parsedRole[0]);
            if (client != null) {
                role = client.getRole(parsedRole[1]);
            }
        }
        return role;
    }

    public static String[] parseRole(String role) {
        int scopeIndex = role.lastIndexOf(46);
        if (scopeIndex > -1) {
            String appName = role.substring(0, scopeIndex);
            role = role.substring(scopeIndex + 1);
            String[] rtn = new String[]{appName, role};
            return rtn;
        }
        String[] rtn = new String[]{null, role};
        return rtn;
    }
}

