/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.exportimport.dir;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.codehaus.jackson.map.ObjectMapper;
import org.keycloak.exportimport.util.ExportUtils;
import org.keycloak.exportimport.util.MultipleStepsExportProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.representations.VersionRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.util.JsonSerialization;

public class DirExportProvider
extends MultipleStepsExportProvider {
    private final File rootDirectory;

    public DirExportProvider() {
        String tempDir = System.getProperty("java.io.tmpdir");
        this.rootDirectory = new File(tempDir + "/keycloak-export");
        this.rootDirectory.mkdirs();
        this.logger.infof("Exporting into directory %s", (Object)this.rootDirectory.getAbsolutePath());
    }

    public DirExportProvider(File rootDirectory) {
        this.rootDirectory = rootDirectory;
        this.rootDirectory.mkdirs();
        this.logger.infof("Exporting into directory %s", (Object)this.rootDirectory.getAbsolutePath());
    }

    public static boolean recursiveDeleteDir(File dirPath) {
        if (dirPath.exists()) {
            File[] files = dirPath.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    DirExportProvider.recursiveDeleteDir(files[i]);
                    continue;
                }
                files[i].delete();
            }
        }
        if (dirPath.exists()) {
            return dirPath.delete();
        }
        return true;
    }

    public void writeRealm(String fileName, RealmRepresentation rep) throws IOException {
        File file = new File(this.rootDirectory, fileName);
        FileOutputStream stream = new FileOutputStream(file);
        JsonSerialization.prettyMapper.writeValue((OutputStream)stream, (Object)rep);
    }

    protected void writeUsers(String fileName, KeycloakSession session, RealmModel realm, List<UserModel> users) throws IOException {
        File file = new File(this.rootDirectory, fileName);
        FileOutputStream os = new FileOutputStream(file);
        ExportUtils.exportUsersToStream((KeycloakSession)session, (RealmModel)realm, users, (ObjectMapper)JsonSerialization.prettyMapper, (OutputStream)os);
    }

    protected void writeVersion(String fileName, VersionRepresentation version) throws IOException {
        File file = new File(this.rootDirectory, fileName);
        FileOutputStream stream = new FileOutputStream(file);
        JsonSerialization.prettyMapper.writeValue((OutputStream)stream, (Object)version);
    }

    public void close() {
    }
}

