/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.tools.query;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.envers.RevisionType;
import org.hibernate.envers.internal.entities.RevisionTypeType;
import org.hibernate.envers.internal.tools.MutableInteger;
import org.hibernate.envers.internal.tools.StringTools;
import org.hibernate.envers.internal.tools.query.Parameters;
import org.hibernate.envers.tools.Pair;
import org.hibernate.type.CustomType;
import org.hibernate.type.Type;
import org.hibernate.usertype.UserType;

public class QueryBuilder {
    private final String entityName;
    private final String alias;
    private final MutableInteger aliasCounter;
    private final MutableInteger paramCounter;
    private final Parameters rootParameters;
    private final List<Pair<String, String>> froms;
    private final List<Pair<String, Boolean>> orders;
    private final List<String> projections;

    public QueryBuilder(String entityName, String alias) {
        this(entityName, alias, new MutableInteger(), new MutableInteger());
    }

    private QueryBuilder(String entityName, String alias, MutableInteger aliasCounter, MutableInteger paramCounter) {
        this.entityName = entityName;
        this.alias = alias;
        this.aliasCounter = aliasCounter;
        this.paramCounter = paramCounter;
        this.rootParameters = new Parameters(alias, "and", paramCounter);
        this.froms = new ArrayList<Pair<String, String>>();
        this.orders = new ArrayList<Pair<String, Boolean>>();
        this.projections = new ArrayList<String>();
        this.addFrom(entityName, alias);
    }

    private QueryBuilder(QueryBuilder other) {
        this.entityName = other.entityName;
        this.alias = other.alias;
        this.aliasCounter = other.aliasCounter.deepCopy();
        this.paramCounter = other.paramCounter.deepCopy();
        this.rootParameters = other.rootParameters.deepCopy();
        this.froms = new ArrayList<Pair<String, String>>(other.froms);
        this.orders = new ArrayList<Pair<String, Boolean>>(other.orders);
        this.projections = new ArrayList<String>(other.projections);
    }

    public QueryBuilder deepCopy() {
        return new QueryBuilder(this);
    }

    public void addFrom(String entityName, String alias) {
        this.froms.add(Pair.make(entityName, alias));
    }

    private String generateAlias() {
        return "_e" + this.aliasCounter.getAndIncrease();
    }

    public QueryBuilder newSubQueryBuilder() {
        return this.newSubQueryBuilder(this.entityName, this.generateAlias());
    }

    public QueryBuilder newSubQueryBuilder(String entityName, String alias) {
        return new QueryBuilder(entityName, alias, this.aliasCounter, this.paramCounter);
    }

    public Parameters getRootParameters() {
        return this.rootParameters;
    }

    public void addOrder(String propertyName, boolean ascending) {
        this.orders.add(Pair.make(propertyName, ascending));
    }

    public void addProjection(String function, String propertyName, boolean distinct) {
        this.addProjection(function, propertyName, distinct, true);
    }

    public void addProjection(String function, String propertyName, boolean distinct, boolean addAlias) {
        if (function == null) {
            this.projections.add((distinct ? "distinct " : "") + (addAlias ? this.alias + "." : "") + propertyName);
        } else {
            this.projections.add(function + "(" + (distinct ? "distinct " : "") + (addAlias ? this.alias + "." : "") + propertyName + ")");
        }
    }

    public void build(StringBuilder sb, Map<String, Object> queryParamValues) {
        sb.append("select ");
        if (this.projections.size() > 0) {
            StringTools.append(sb, this.projections.iterator(), ", ");
        } else {
            StringTools.append(sb, this.getAliasList().iterator(), ", ");
        }
        sb.append(" from ");
        StringTools.append(sb, this.getFromList().iterator(), ", ");
        if (!this.rootParameters.isEmpty()) {
            sb.append(" where ");
            this.rootParameters.build(sb, queryParamValues);
        }
        if (this.orders.size() > 0) {
            sb.append(" order by ");
            StringTools.append(sb, this.getOrderList().iterator(), ", ");
        }
    }

    private List<String> getAliasList() {
        ArrayList<String> aliasList = new ArrayList<String>();
        for (Pair<String, String> from : this.froms) {
            aliasList.add(from.getSecond());
        }
        return aliasList;
    }

    public String getRootAlias() {
        return this.alias;
    }

    private List<String> getFromList() {
        ArrayList<String> fromList = new ArrayList<String>();
        for (Pair<String, String> from : this.froms) {
            fromList.add(from.getFirst() + " " + from.getSecond());
        }
        return fromList;
    }

    private List<String> getOrderList() {
        ArrayList<String> orderList = new ArrayList<String>();
        for (Pair<String, Boolean> order : this.orders) {
            orderList.add(this.alias + "." + order.getFirst() + " " + (order.getSecond() != false ? "asc" : "desc"));
        }
        return orderList;
    }

    public Query toQuery(Session session) {
        StringBuilder querySb = new StringBuilder();
        HashMap<String, Object> queryParamValues = new HashMap<String, Object>();
        this.build(querySb, queryParamValues);
        Query query = session.createQuery(querySb.toString());
        for (Map.Entry paramValue : queryParamValues.entrySet()) {
            if (paramValue.getValue() instanceof RevisionType) {
                query.setParameter((String)paramValue.getKey(), paramValue.getValue(), (Type)new CustomType((UserType)new RevisionTypeType()));
                continue;
            }
            query.setParameter((String)paramValue.getKey(), paramValue.getValue());
        }
        return query;
    }
}

