/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.proton.plug;

import io.netty.buffer.ByteBuf;
import java.util.concurrent.Executor;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.core.protocol.proton.ProtonProtocolManager;
import org.apache.activemq.artemis.core.protocol.proton.plug.ActiveMQProtonConnectionCallback;
import org.apache.activemq.artemis.core.server.QueueQueryResult;
import org.apache.activemq.artemis.core.server.ServerConsumer;
import org.apache.activemq.artemis.core.server.ServerMessage;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.protocol.SessionCallback;
import org.apache.activemq.artemis.spi.core.remoting.Connection;
import org.apache.activemq.artemis.spi.core.remoting.ReadyListener;
import org.apache.activemq.artemis.utils.ByteUtil;
import org.apache.activemq.artemis.utils.IDGenerator;
import org.apache.activemq.artemis.utils.SimpleIDGenerator;
import org.apache.activemq.artemis.utils.UUIDGenerator;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.transport.AmqpError;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.Link;
import org.apache.qpid.proton.engine.Receiver;
import org.apache.qpid.proton.jms.EncodedMessage;
import org.apache.qpid.proton.message.ProtonJMessage;
import org.proton.plug.AMQPConnectionContext;
import org.proton.plug.AMQPSessionCallback;
import org.proton.plug.AMQPSessionContext;
import org.proton.plug.SASLResult;
import org.proton.plug.context.ProtonPlugSender;
import org.proton.plug.sasl.PlainSASLResult;

public class ProtonSessionIntegrationCallback
implements AMQPSessionCallback,
SessionCallback {
    protected final IDGenerator consumerIDGenerator = new SimpleIDGenerator(0L);
    private final ActiveMQProtonConnectionCallback protonSPI;
    private final ProtonProtocolManager manager;
    private final AMQPConnectionContext connection;
    private final Connection transportConnection;
    private ServerSession serverSession;
    private AMQPSessionContext protonSession;

    public ProtonSessionIntegrationCallback(ActiveMQProtonConnectionCallback protonSPI, ProtonProtocolManager manager, AMQPConnectionContext connection, Connection transportConnection) {
        this.protonSPI = protonSPI;
        this.manager = manager;
        this.connection = connection;
        this.transportConnection = transportConnection;
    }

    public boolean isWritable(ReadyListener callback) {
        return this.transportConnection.isWritable(callback);
    }

    public void onFlowConsumer(Object consumer, int credits) {
        ((ServerConsumer)consumer).receiveCredits(-1);
    }

    public void init(AMQPSessionContext protonSession, SASLResult saslResult) throws Exception {
        this.protonSession = protonSession;
        String name = UUIDGenerator.getInstance().generateStringUUID();
        String user = null;
        String passcode = null;
        if (saslResult != null) {
            user = saslResult.getUser();
            if (saslResult instanceof PlainSASLResult) {
                passcode = ((PlainSASLResult)saslResult).getPassword();
            }
        }
        this.serverSession = this.manager.getServer().createSession(name, user, passcode, 102400, (RemotingConnection)this.protonSPI.getProtonConnectionDelegate(), false, false, false, true, (String)null, (SessionCallback)this, null, true);
    }

    public void start() {
    }

    public Object createSender(ProtonPlugSender protonSender, String queue, String filer, boolean browserOnly) throws Exception {
        long consumerID = this.consumerIDGenerator.generateID();
        ServerConsumer consumer = this.serverSession.createConsumer(consumerID, SimpleString.toSimpleString((String)queue), SimpleString.toSimpleString((String)filer), browserOnly);
        consumer.setStarted(true);
        consumer.setProtocolContext((Object)protonSender);
        return consumer;
    }

    public void startSender(Object brokerConsumer) throws Exception {
        ServerConsumer serverConsumer = (ServerConsumer)brokerConsumer;
        serverConsumer.receiveCredits(-1);
    }

    public void createTemporaryQueue(String queueName) throws Exception {
        this.serverSession.createQueue(SimpleString.toSimpleString((String)queueName), SimpleString.toSimpleString((String)queueName), null, true, false);
    }

    public boolean queueQuery(String queueName) throws Exception {
        boolean queryResult = false;
        QueueQueryResult queueQuery = this.serverSession.executeQueueQuery(SimpleString.toSimpleString((String)queueName));
        if (queueQuery.isExists()) {
            queryResult = true;
        } else if (queueQuery.isAutoCreateJmsQueues()) {
            this.serverSession.createQueue(new SimpleString(queueName), new SimpleString(queueName), null, false, true);
            queryResult = true;
        } else {
            queryResult = false;
        }
        return queryResult;
    }

    public void closeSender(final Object brokerConsumer) throws Exception {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    ((ServerConsumer)brokerConsumer).close(false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        Executor executor = this.protonSPI.getExeuctor();
        if (executor != null) {
            executor.execute(runnable);
        } else {
            runnable.run();
        }
    }

    public ProtonJMessage encodeMessage(Object message, int deliveryCount) throws Exception {
        return (ProtonJMessage)this.manager.getConverter().outbound((ServerMessage)message, deliveryCount);
    }

    public Binary getCurrentTXID() {
        return new Binary(ByteUtil.longToBytes((long)this.serverSession.getCurrentTransaction().getID()));
    }

    public String tempQueueName() {
        return UUIDGenerator.getInstance().generateStringUUID();
    }

    public void commitCurrentTX() throws Exception {
        this.serverSession.commit();
    }

    public void rollbackCurrentTX() throws Exception {
        this.serverSession.rollback(false);
    }

    public void close() throws Exception {
        this.serverSession.close(false);
    }

    public void ack(Object brokerConsumer, Object message) throws Exception {
        ((ServerConsumer)brokerConsumer).individualAcknowledge(null, ((ServerMessage)message).getMessageID());
    }

    public void cancel(Object brokerConsumer, Object message, boolean updateCounts) throws Exception {
        ((ServerConsumer)brokerConsumer).individualCancel(((ServerMessage)message).getMessageID(), updateCounts);
    }

    public void resumeDelivery(Object consumer) {
        ((ServerConsumer)consumer).receiveCredits(-1);
    }

    public void serverSend(final Receiver receiver, final Delivery delivery, String address, int messageFormat, ByteBuf messageEncoded) throws Exception {
        EncodedMessage encodedMessage = new EncodedMessage((long)messageFormat, messageEncoded.array(), messageEncoded.arrayOffset(), messageEncoded.writerIndex());
        ServerMessage message = this.manager.getConverter().inbound((Object)encodedMessage);
        if (address != null) {
            message.setAddress(new SimpleString(address));
        }
        this.serverSession.send(message, false);
        this.manager.getServer().getStorageManager().afterCompleteOperations(new IOCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void done() {
                Object object = ProtonSessionIntegrationCallback.this.connection.getLock();
                synchronized (object) {
                    delivery.settle();
                    ProtonSessionIntegrationCallback.this.connection.flush();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onError(int errorCode, String errorMessage) {
                Object object = ProtonSessionIntegrationCallback.this.connection.getLock();
                synchronized (object) {
                    receiver.setCondition(new ErrorCondition(AmqpError.ILLEGAL_STATE, errorCode + ":" + errorMessage));
                    ProtonSessionIntegrationCallback.this.connection.flush();
                }
            }
        });
    }

    public void sendProducerCreditsMessage(int credits, SimpleString address) {
    }

    public void sendProducerCreditsFailMessage(int credits, SimpleString address) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sendMessage(ServerMessage message, ServerConsumer consumer, int deliveryCount) {
        ProtonPlugSender plugSender = (ProtonPlugSender)consumer.getProtocolContext();
        try {
            return plugSender.deliverMessage((Object)message, deliveryCount);
        }
        catch (Exception e) {
            Object object = this.connection.getLock();
            synchronized (object) {
                plugSender.getSender().setCondition(new ErrorCondition(AmqpError.INTERNAL_ERROR, e.getMessage()));
                this.connection.flush();
            }
            throw new IllegalStateException("Can't deliver message " + e, e);
        }
    }

    public int sendLargeMessage(ServerMessage message, ServerConsumer consumer, long bodySize, int deliveryCount) {
        return 0;
    }

    public int sendLargeMessageContinuation(ServerConsumer consumer, byte[] body, boolean continues, boolean requiresResponse) {
        return 0;
    }

    public void closed() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(ServerConsumer consumer, String queueName) {
        Object object = this.connection.getLock();
        synchronized (object) {
            ((Link)consumer.getProtocolContext()).close();
            this.connection.flush();
        }
    }

    public boolean hasCredits(ServerConsumer consumer) {
        ProtonPlugSender plugSender = (ProtonPlugSender)consumer.getProtocolContext();
        return plugSender != null && plugSender.getSender().getCredit() > 0;
    }
}

