/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.mongo.keycloak.adapters;

import org.keycloak.connections.mongo.api.MongoIdentifiableEntity;
import org.keycloak.connections.mongo.api.MongoStore;
import org.keycloak.connections.mongo.api.context.MongoStoreInvocationContext;

public abstract class AbstractMongoAdapter<T extends MongoIdentifiableEntity> {
    protected final MongoStoreInvocationContext invocationContext;

    public AbstractMongoAdapter(MongoStoreInvocationContext invocationContext) {
        this.invocationContext = invocationContext;
    }

    protected abstract T getMongoEntity();

    protected void updateMongoEntity() {
        this.getMongoStore().updateEntity(this.getMongoEntity(), this.invocationContext);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractMongoAdapter that = (AbstractMongoAdapter)o;
        if (this.getMongoEntity() == null && that.getMongoEntity() == null) {
            return true;
        }
        return this.getMongoEntity().equals(that.getMongoEntity());
    }

    public int hashCode() {
        return this.getMongoEntity() != null ? this.getMongoEntity().hashCode() : super.hashCode();
    }

    protected MongoStore getMongoStore() {
        return this.invocationContext.getMongoStore();
    }
}

