/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;
import org.infinispan.Cache;

public class RemovableIterator<K, C>
implements Iterator<C> {
    protected final Iterator<C> realIterator;
    protected final Cache<K, ?> cache;
    protected final Function<? super C, K> removeFunction;
    protected C previousValue;
    protected C currentValue;

    public RemovableIterator(Iterator<C> realIterator, Cache<K, ?> cache, Function<? super C, K> removeFunction) {
        this.realIterator = realIterator;
        this.cache = cache;
        this.removeFunction = removeFunction;
    }

    protected C getNextFromIterator() {
        if (this.realIterator.hasNext()) {
            return this.realIterator.next();
        }
        return null;
    }

    @Override
    public boolean hasNext() {
        return this.currentValue != null || (this.currentValue = this.getNextFromIterator()) != null;
    }

    @Override
    public C next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.previousValue = this.currentValue;
        this.currentValue = null;
        return this.previousValue;
    }

    @Override
    public void remove() {
        if (this.previousValue == null) {
            throw new IllegalStateException();
        }
        this.cache.remove(this.removeFunction.apply(this.previousValue));
        this.previousValue = null;
    }
}

