/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.keycloak.migration.MigrationModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientTemplateModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakTransaction;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RealmProvider;
import org.keycloak.models.RoleModel;
import org.keycloak.models.cache.CacheRealmProvider;
import org.keycloak.models.cache.RealmCache;
import org.keycloak.models.cache.entities.CachedClient;
import org.keycloak.models.cache.entities.CachedClientRole;
import org.keycloak.models.cache.entities.CachedClientTemplate;
import org.keycloak.models.cache.entities.CachedGroup;
import org.keycloak.models.cache.entities.CachedRealm;
import org.keycloak.models.cache.entities.CachedRealmRole;
import org.keycloak.models.cache.entities.CachedRole;
import org.keycloak.models.cache.infinispan.ClientAdapter;
import org.keycloak.models.cache.infinispan.ClientTemplateAdapter;
import org.keycloak.models.cache.infinispan.GroupAdapter;
import org.keycloak.models.cache.infinispan.RealmAdapter;
import org.keycloak.models.cache.infinispan.RoleAdapter;

public class DefaultCacheRealmProvider
implements CacheRealmProvider {
    protected RealmCache cache;
    protected KeycloakSession session;
    protected RealmProvider delegate;
    protected boolean transactionActive;
    protected boolean setRollbackOnly;
    protected Set<String> realmInvalidations = new HashSet<String>();
    protected Set<String> appInvalidations = new HashSet<String>();
    protected Set<String> clientTemplateInvalidations = new HashSet<String>();
    protected Set<String> roleInvalidations = new HashSet<String>();
    protected Set<String> groupInvalidations = new HashSet<String>();
    protected Map<String, RealmModel> managedRealms = new HashMap<String, RealmModel>();
    protected Map<String, ClientModel> managedApplications = new HashMap<String, ClientModel>();
    protected Map<String, ClientTemplateModel> managedClientTemplates = new HashMap<String, ClientTemplateModel>();
    protected Map<String, RoleModel> managedRoles = new HashMap<String, RoleModel>();
    protected Map<String, GroupModel> managedGroups = new HashMap<String, GroupModel>();
    protected boolean clearAll;

    public DefaultCacheRealmProvider(RealmCache cache, KeycloakSession session) {
        this.cache = cache;
        this.session = session;
        session.getTransaction().enlistAfterCompletion(this.getTransaction());
    }

    public MigrationModel getMigrationModel() {
        return this.getDelegate().getMigrationModel();
    }

    public boolean isEnabled() {
        return this.cache.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.cache.setEnabled(enabled);
    }

    public RealmProvider getDelegate() {
        if (!this.transactionActive) {
            throw new IllegalStateException("Cannot access delegate without a transaction");
        }
        if (this.delegate != null) {
            return this.delegate;
        }
        this.delegate = (RealmProvider)this.session.getProvider(RealmProvider.class);
        return this.delegate;
    }

    public void registerRealmInvalidation(String id) {
        this.realmInvalidations.add(id);
    }

    public void registerApplicationInvalidation(String id) {
        this.appInvalidations.add(id);
    }

    public void registerClientTemplateInvalidation(String id) {
        this.clientTemplateInvalidations.add(id);
    }

    public void registerRoleInvalidation(String id) {
        this.roleInvalidations.add(id);
    }

    public void registerGroupInvalidation(String id) {
        this.groupInvalidations.add(id);
    }

    protected void runInvalidations() {
        for (String id : this.realmInvalidations) {
            this.cache.invalidateCachedRealmById(id);
        }
        for (String id : this.roleInvalidations) {
            this.cache.invalidateRoleById(id);
        }
        for (String id : this.groupInvalidations) {
            this.cache.invalidateGroupById(id);
        }
        for (String id : this.appInvalidations) {
            this.cache.invalidateCachedApplicationById(id);
        }
        for (String id : this.clientTemplateInvalidations) {
            this.cache.invalidateCachedClientTemplateById(id);
        }
    }

    private KeycloakTransaction getTransaction() {
        return new KeycloakTransaction(){

            public void begin() {
                DefaultCacheRealmProvider.this.transactionActive = true;
            }

            public void commit() {
                if (DefaultCacheRealmProvider.this.delegate == null) {
                    return;
                }
                if (DefaultCacheRealmProvider.this.clearAll) {
                    DefaultCacheRealmProvider.this.cache.clear();
                }
                DefaultCacheRealmProvider.this.runInvalidations();
                DefaultCacheRealmProvider.this.transactionActive = false;
            }

            public void rollback() {
                DefaultCacheRealmProvider.this.setRollbackOnly = true;
                DefaultCacheRealmProvider.this.runInvalidations();
                DefaultCacheRealmProvider.this.transactionActive = false;
            }

            public void setRollbackOnly() {
                DefaultCacheRealmProvider.this.setRollbackOnly = true;
            }

            public boolean getRollbackOnly() {
                return DefaultCacheRealmProvider.this.setRollbackOnly;
            }

            public boolean isActive() {
                return DefaultCacheRealmProvider.this.transactionActive;
            }
        };
    }

    public RealmModel createRealm(String name) {
        RealmModel realm = this.getDelegate().createRealm(name);
        if (!this.cache.isEnabled()) {
            return realm;
        }
        this.registerRealmInvalidation(realm.getId());
        return realm;
    }

    public RealmModel createRealm(String id, String name) {
        RealmModel realm = this.getDelegate().createRealm(id, name);
        if (!this.cache.isEnabled()) {
            return realm;
        }
        this.registerRealmInvalidation(realm.getId());
        return realm;
    }

    public RealmModel getRealm(String id) {
        if (!this.cache.isEnabled()) {
            return this.getDelegate().getRealm(id);
        }
        CachedRealm cached = this.cache.getCachedRealm(id);
        if (cached == null) {
            RealmModel model = this.getDelegate().getRealm(id);
            if (model == null) {
                return null;
            }
            if (this.realmInvalidations.contains(id)) {
                return model;
            }
            cached = new CachedRealm(this.cache, (RealmProvider)this, model);
            this.cache.addCachedRealm(cached);
        } else {
            if (this.realmInvalidations.contains(id)) {
                return this.getDelegate().getRealm(id);
            }
            if (this.managedRealms.containsKey(id)) {
                return this.managedRealms.get(id);
            }
        }
        RealmAdapter adapter = new RealmAdapter(cached, this);
        this.managedRealms.put(id, adapter);
        return adapter;
    }

    public RealmModel getRealmByName(String name) {
        if (!this.cache.isEnabled()) {
            return this.getDelegate().getRealmByName(name);
        }
        CachedRealm cached = this.cache.getCachedRealmByName(name);
        if (cached == null) {
            RealmModel model = this.getDelegate().getRealmByName(name);
            if (model == null) {
                return null;
            }
            if (this.realmInvalidations.contains(model.getId())) {
                return model;
            }
            cached = new CachedRealm(this.cache, (RealmProvider)this, model);
            this.cache.addCachedRealm(cached);
        } else {
            if (this.realmInvalidations.contains(cached.getId())) {
                return this.getDelegate().getRealmByName(name);
            }
            if (this.managedRealms.containsKey(cached.getId())) {
                return this.managedRealms.get(cached.getId());
            }
        }
        RealmAdapter adapter = new RealmAdapter(cached, this);
        this.managedRealms.put(cached.getId(), adapter);
        return adapter;
    }

    public List<RealmModel> getRealms() {
        List backendRealms = this.getDelegate().getRealms();
        LinkedList<RealmModel> cachedRealms = new LinkedList<RealmModel>();
        for (RealmModel realm : backendRealms) {
            RealmModel cached = this.getRealm(realm.getId());
            cachedRealms.add(cached);
        }
        return cachedRealms;
    }

    public boolean removeRealm(String id) {
        if (!this.cache.isEnabled()) {
            return this.getDelegate().removeRealm(id);
        }
        this.cache.invalidateCachedRealmById(id);
        RealmModel realm = this.getDelegate().getRealm(id);
        Set realmRoles = null;
        if (realm != null) {
            realmRoles = realm.getRoles();
        }
        boolean didIt = this.getDelegate().removeRealm(id);
        this.realmInvalidations.add(id);
        if (didIt && realmRoles != null) {
            for (RoleModel role : realmRoles) {
                this.roleInvalidations.add(role.getId());
            }
        }
        return didIt;
    }

    public void close() {
        if (this.delegate != null) {
            this.delegate.close();
        }
    }

    public RoleModel getRoleById(String id, RealmModel realm) {
        if (!this.cache.isEnabled()) {
            return this.getDelegate().getRoleById(id, realm);
        }
        Object cached = this.cache.getRole(id);
        if (cached != null && !cached.getRealm().equals(realm.getId())) {
            cached = null;
        }
        if (cached == null) {
            RoleModel model = this.getDelegate().getRoleById(id, realm);
            if (model == null) {
                return null;
            }
            if (this.roleInvalidations.contains(id)) {
                return model;
            }
            cached = model.getContainer() instanceof ClientModel ? new CachedClientRole(((ClientModel)model.getContainer()).getId(), model, realm) : new CachedRealmRole(model, realm);
            this.cache.addCachedRole(cached);
        } else {
            if (this.roleInvalidations.contains(id)) {
                return this.getDelegate().getRoleById(id, realm);
            }
            if (this.managedRoles.containsKey(id)) {
                return this.managedRoles.get(id);
            }
        }
        RoleAdapter adapter = new RoleAdapter((CachedRole)cached, this.cache, this, realm);
        this.managedRoles.put(id, adapter);
        return adapter;
    }

    public GroupModel getGroupById(String id, RealmModel realm) {
        if (!this.cache.isEnabled()) {
            return this.getDelegate().getGroupById(id, realm);
        }
        CachedGroup cached = this.cache.getGroup(id);
        if (cached != null && !cached.getRealm().equals(realm.getId())) {
            cached = null;
        }
        if (cached == null) {
            GroupModel model = this.getDelegate().getGroupById(id, realm);
            if (model == null) {
                return null;
            }
            if (this.groupInvalidations.contains(id)) {
                return model;
            }
            cached = new CachedGroup(realm, model);
            this.cache.addCachedGroup(cached);
        } else {
            if (this.groupInvalidations.contains(id)) {
                return this.getDelegate().getGroupById(id, realm);
            }
            if (this.managedGroups.containsKey(id)) {
                return this.managedGroups.get(id);
            }
        }
        GroupAdapter adapter = new GroupAdapter(cached, this, this.session, realm);
        this.managedGroups.put(id, adapter);
        return adapter;
    }

    public ClientModel getClientById(String id, RealmModel realm) {
        if (!this.cache.isEnabled()) {
            return this.getDelegate().getClientById(id, realm);
        }
        CachedClient cached = this.cache.getApplication(id);
        if (cached != null && !cached.getRealm().equals(realm.getId())) {
            cached = null;
        }
        if (cached == null) {
            ClientModel model = this.getDelegate().getClientById(id, realm);
            if (model == null) {
                return null;
            }
            if (this.appInvalidations.contains(id)) {
                return model;
            }
            cached = new CachedClient(this.cache, this.getDelegate(), realm, model);
            this.cache.addCachedClient(cached);
        } else {
            if (this.appInvalidations.contains(id)) {
                return this.getDelegate().getClientById(id, realm);
            }
            if (this.managedApplications.containsKey(id)) {
                return this.managedApplications.get(id);
            }
        }
        ClientAdapter adapter = new ClientAdapter(realm, cached, this, this.cache);
        this.managedApplications.put(id, adapter);
        return adapter;
    }

    public ClientTemplateModel getClientTemplateById(String id, RealmModel realm) {
        if (!this.cache.isEnabled()) {
            return this.getDelegate().getClientTemplateById(id, realm);
        }
        CachedClientTemplate cached = this.cache.getClientTemplate(id);
        if (cached != null && !cached.getRealm().equals(realm.getId())) {
            cached = null;
        }
        if (cached == null) {
            ClientTemplateModel model = this.getDelegate().getClientTemplateById(id, realm);
            if (model == null) {
                return null;
            }
            if (this.clientTemplateInvalidations.contains(id)) {
                return model;
            }
            cached = new CachedClientTemplate(this.cache, this.getDelegate(), realm, model);
            this.cache.addCachedClientTemplate(cached);
        } else {
            if (this.clientTemplateInvalidations.contains(id)) {
                return this.getDelegate().getClientTemplateById(id, realm);
            }
            if (this.managedClientTemplates.containsKey(id)) {
                return this.managedClientTemplates.get(id);
            }
        }
        ClientTemplateAdapter adapter = new ClientTemplateAdapter(realm, cached, this, this.cache);
        this.managedClientTemplates.put(id, adapter);
        return adapter;
    }
}

