/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.uri;

import java.io.NotSerializableException;
import java.net.URI;
import java.util.Map;
import org.apache.activemq.artemis.api.core.BroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.JGroupsFileBroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.JGroupsPropertiesBroadcastEndpointFactory;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.uri.AbstractCFSchema;
import org.apache.activemq.artemis.uri.JGroupsServerLocatorSchema;
import org.apache.activemq.artemis.uri.JMSConnectionOptions;
import org.apache.activemq.artemis.utils.uri.URISchema;

public class JGroupsSchema
extends AbstractCFSchema {
    public String getSchemaName() {
        return "jgroups";
    }

    public ActiveMQConnectionFactory internalNewObject(URI uri, Map<String, String> query, String name) throws Exception {
        JMSConnectionOptions options = this.newConectionOptions(uri, query);
        DiscoveryGroupConfiguration dcConfig = JGroupsServerLocatorSchema.getDiscoveryGroupConfiguration((URI)uri, query, (String)name);
        ActiveMQConnectionFactory factory = options.isHa() ? ActiveMQJMSClient.createConnectionFactoryWithHA(dcConfig, options.getFactoryTypeEnum()) : ActiveMQJMSClient.createConnectionFactoryWithoutHA(dcConfig, options.getFactoryTypeEnum());
        return (ActiveMQConnectionFactory)URISchema.setData((URI)uri, (Object)factory, query);
    }

    protected URI internalNewURI(ActiveMQConnectionFactory bean) throws Exception {
        String auth;
        DiscoveryGroupConfiguration dgc = bean.getDiscoveryGroupConfiguration();
        BroadcastEndpointFactory endpoint = dgc.getBroadcastEndpointFactory();
        if (endpoint instanceof JGroupsFileBroadcastEndpointFactory) {
            auth = ((JGroupsFileBroadcastEndpointFactory)endpoint).getChannelName();
        } else if (endpoint instanceof JGroupsPropertiesBroadcastEndpointFactory) {
            auth = ((JGroupsPropertiesBroadcastEndpointFactory)endpoint).getChannelName();
        } else {
            throw new NotSerializableException(endpoint + "not serializable");
        }
        String query = URISchema.getData(null, (Object[])new Object[]{bean, dgc, endpoint});
        dgc.setBroadcastEndpointFactory(endpoint);
        return new URI("jgroups", null, auth, -1, null, query, null);
    }
}

