/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.filters;

import io.undertow.Handlers;
import io.undertow.predicate.Predicate;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.builder.PredicatedHandlersParser;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.wildfly.extension.undertow.filters.Filter;
import org.wildfly.extension.undertow.logging.UndertowLogger;

public class ExpressionFilterDefinition
extends Filter {
    public static final AttributeDefinition EXPRESSION = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("expression", ModelType.STRING).setAllowNull(false)).setAllowExpression(true)).build();
    public static final AttributeDefinition MODULE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("module", ModelType.STRING).setAllowNull(true)).setAllowExpression(true)).build();
    public static final ExpressionFilterDefinition INSTANCE = new ExpressionFilterDefinition();

    private ExpressionFilterDefinition() {
        super("expression-filter");
    }

    @Override
    public Collection<AttributeDefinition> getAttributes() {
        return Arrays.asList(EXPRESSION, MODULE);
    }

    @Override
    public HttpHandler createHttpHandler(Predicate predicate, ModelNode model, HttpHandler next) {
        ClassLoader classLoader;
        String expression = model.get(EXPRESSION.getName()).asString();
        String moduleName = null;
        if (model.hasDefined(MODULE.getName())) {
            moduleName = model.get(MODULE.getName()).asString();
        }
        if (moduleName == null) {
            classLoader = this.getClass().getClassLoader();
        } else {
            try {
                ModuleLoader moduleLoader = Module.getBootModuleLoader();
                Module filterModule = moduleLoader.loadModule(ModuleIdentifier.fromString((String)moduleName));
                classLoader = filterModule.getClassLoader();
            }
            catch (ModuleLoadException e) {
                throw UndertowLogger.ROOT_LOGGER.couldNotLoadHandlerFromModule(expression, moduleName, (Exception)((Object)e));
            }
        }
        List handlers = PredicatedHandlersParser.parse((String)expression, (ClassLoader)classLoader);
        UndertowLogger.ROOT_LOGGER.debugf("Creating http handler %s from module %s", expression, moduleName);
        if (predicate != null) {
            return Handlers.predicate((Predicate)predicate, (HttpHandler)Handlers.predicates((List)handlers, (HttpHandler)next), (HttpHandler)next);
        }
        return Handlers.predicates((List)handlers, (HttpHandler)next);
    }

    @Override
    protected Class[] getConstructorSignature() {
        throw new IllegalStateException();
    }
}

